/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.MavenCoordinates;
import com.gradle.publish.PluginConfig;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public class PluginBundleExtension {
    private final Project project;
    private final NamedDomainObjectContainer<PluginConfig> pluginConfigs;
    private String website;
    private String description;
    private String vcsUrl;
    private Collection<String> tags;
    private MavenCoordinates mavenCoordinates = new MavenCoordinates();
    private Closure<?> withDependenciesBlock;

    public PluginBundleExtension(Project project) {
        this(project, (NamedDomainObjectContainer<PluginConfig>)project.container(PluginConfig.class));
    }

    PluginBundleExtension(Project project, NamedDomainObjectContainer<PluginConfig> pluginConfigs) {
        this.project = project;
        this.pluginConfigs = pluginConfigs;
    }

    public void plugins(Closure<?> block) {
        this.project.configure(this.pluginConfigs, block);
    }

    public void mavenCoordinates(Closure<?> block) {
        this.project.configure((Object)this.mavenCoordinates, block);
    }

    public void withDependencies(Closure<?> block) {
        this.withDependenciesBlock = block;
    }

    public NamedDomainObjectContainer<PluginConfig> getPlugins() {
        return this.pluginConfigs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginBundleExtension{");
        if (this.website != null) {
            sb.append(", website='").append(this.website).append('\'');
        }
        if (this.description != null) {
            sb.append(", description='").append(this.description).append('\'');
        }
        if (this.vcsUrl != null) {
            sb.append(", vcsUrl='").append(this.vcsUrl).append('\'');
        }
        if (this.tags != null) {
            sb.append(", tags='").append(this.tags).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVcsUrl() {
        return this.vcsUrl;
    }

    public void setVcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
    }

    public MavenCoordinates getMavenCoordinates() {
        return this.mavenCoordinates;
    }

    public void setMavenCoordinates(MavenCoordinates mavenCoordinates) {
        this.mavenCoordinates = mavenCoordinates;
    }

    public Closure<?> getWithDependenciesBlock() {
        return this.withDependenciesBlock;
    }

    public void setTags(Collection<String> tags) {
        this.tags = tags;
    }

    public Collection<String> getTags() {
        if (this.tags == null) {
            return Collections.emptySet();
        }
        return this.tags;
    }
}

