/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.receipts.protocols.v1.models.fragments;

import com.gradle.protocols.util.Hasher;
import com.gradle.receipts.protocols.v1.models.ReceiptFragment;
import com.gradle.receipts.protocols.v1.models.ReceiptFragmentType;
import java.util.Properties;

public class SystemFragment
extends ReceiptFragment {
    private final Properties properties;
    private final String gradleVersion;
    private final int cpuCores;
    private final long buildDirFreeDiskSpace;
    private final long totalMemory;
    private final long buildDirTotalDiskSpace;

    private static String propertiesHash(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object key : properties.keySet()) {
            stringBuilder.append(key + ":" + properties.get(key));
        }
        return Hasher.hash(stringBuilder.toString());
    }

    public SystemFragment(Properties properties, String gradleVersion, int cpuCores, long buildDirFreeDiskSpace, long buildDirTotalDiskSpace, long totalMemory) {
        super(ReceiptFragmentType.SYSTEM, Hasher.hashMultiple(SystemFragment.propertiesHash(properties), cpuCores, totalMemory, gradleVersion, buildDirFreeDiskSpace, buildDirTotalDiskSpace));
        this.properties = properties;
        this.gradleVersion = gradleVersion;
        this.cpuCores = cpuCores;
        this.buildDirFreeDiskSpace = buildDirFreeDiskSpace;
        this.buildDirTotalDiskSpace = buildDirTotalDiskSpace;
        this.totalMemory = totalMemory;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public String getGradleVersion() {
        return this.gradleVersion;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public long getBuildDirFreeDiskSpace() {
        return this.buildDirFreeDiskSpace;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getBuildDirTotalDiskSpace() {
        return this.buildDirTotalDiskSpace;
    }
}

