/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.Config;
import com.gradle.publish.Util;
import com.gradle.publish.protocols.v1.models.login.LoginCheckRequest;
import com.gradle.publish.protocols.v1.models.login.LoginCheckResponse;
import com.gradle.publish.protocols.v1.models.login.LoginInitRequest;
import com.gradle.publish.protocols.v1.models.login.LoginInitResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.util.LayoutPreservingProperties;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginTask
extends DefaultTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginTask.class);
    public static String PROPERTIES_FILE_LOCATION = "com.gradle.login.properties.file";
    private Config ghConfig = new Config(this.getProject());

    private boolean isLoggedIn(LoginCheckRequest loginCheckRequest) throws IOException {
        URL url = new URL(this.ghConfig.getPortalUrl() + loginCheckRequest.requestProtocolURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(loginCheckRequest.getRequestMethod());
        String response = IOUtils.toString((InputStream)connection.getInputStream());
        LOGGER.debug("Is logged in response: " + response);
        LoginCheckResponse loginCheckResponse = (LoginCheckResponse)loginCheckRequest.convertResponse(response);
        connection.disconnect();
        if (loginCheckResponse.getCompleted().booleanValue()) {
            System.out.println(loginCheckResponse.getSuccessMessage());
            String key = loginCheckResponse.getKey();
            String secret = loginCheckResponse.getSecret();
            this.updateKeySecretProperties(key, secret, loginCheckResponse.getSuccessMessage());
        }
        return loginCheckResponse.getCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(File propertiesFile) throws IOException {
        LayoutPreservingProperties props = new LayoutPreservingProperties(System.getProperties());
        props.setRemoveComments(true);
        if (propertiesFile == null || !propertiesFile.exists()) {
            return props;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertiesFile);
            props.load((InputStream)in);
            LayoutPreservingProperties layoutPreservingProperties = props;
            return layoutPreservingProperties;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    static File getDefaultPropertiesFile(Project project) {
        String overridePropertiesFileProp = System.getProperty(PROPERTIES_FILE_LOCATION);
        if (overridePropertiesFileProp != null) {
            return new File(overridePropertiesFileProp);
        }
        File projectPropFile = new File(project.getProjectDir(), "gradle.properties");
        if (projectPropFile != null && projectPropFile.exists()) {
            return projectPropFile;
        }
        File defaultGradleDir = project.getGradle().getGradleUserHomeDir();
        File gradleHomeFile = new File(defaultGradleDir, "gradle.properties");
        return gradleHomeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKeySecretProperties(String key, String secret, String message) throws IOException {
        OutputStream out = null;
        try {
            File propertiesFile = LoginTask.getDefaultPropertiesFile(this.getProject());
            Properties props = LoginTask.loadProperties(propertiesFile);
            props.setProperty("gradle.publish.key", key);
            props.setProperty("gradle.publish.secret", secret);
            LOGGER.debug("Updating key and secret in file: " + propertiesFile.getAbsolutePath());
            out = new FileOutputStream(propertiesFile);
            props.store(out, "Updated secret and key with server message: " + message);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @TaskAction
    public void login() throws IOException, InterruptedException {
        String keyName = InetAddress.getLocalHost().getHostName();
        LoginInitRequest request = new LoginInitRequest(keyName);
        URL url = new URL(this.ghConfig.getPortalUrl() + request.requestProtocolURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(request.getRequestMethod());
        String stringResponse = IOUtils.toString((InputStream)connection.getInputStream());
        int status = connection.getResponseCode();
        LOGGER.debug("Login response: " + stringResponse);
        LoginInitResponse apiResponse = (LoginInitResponse)Util.convertResponse(request, url, stringResponse, status);
        System.out.println("\nTo update credentials, paste the following URL in your browser:\n\n   " + apiResponse.getValidateUrl() + "\n" + "\n");
        connection.disconnect();
        Long startTime = System.currentTimeMillis();
        while (!this.isLoggedIn(apiResponse.getNextRequest()) && System.currentTimeMillis() - startTime < this.ghConfig.loginMaxWait()) {
            Thread.sleep(this.ghConfig.loginSleepInterval());
            LOGGER.trace("Trying login again: " + apiResponse.getToken());
        }
    }
}

