/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.LoginTask;
import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PluginConfig;
import com.gradle.publish.PluginDeclarationAccessor;
import com.gradle.publish.PublishTask;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishPlugin
implements Plugin<Project> {
    public static final String LOGIN_TASK_NAME = "login";
    private static final String PUBLISH_TASK_DESCRIPTION = "Publishes this plugin to the Gradle Plugin portal.";
    private static final String LOGIN_TASK_DESCRIPTION = "Update the gradle.properties files so this machine can publish to the Gradle Plugin portal.";
    private static final String PORTAL_BUILD_GROUP_NAME = "Plugin Portal";
    private static final String BASE_TASK_NAME = "publishPlugin";
    private static final String SOURCES_JAR_TASK_NAME = "publishPluginJar";
    private static final String JAVA_DOCS_TASK_NAME = "publishPluginJavaDocsJar";
    private static final String GROOVY_DOCS_TASK_NAME = "publishPluginGroovyDocsJar";
    private static final String PUBLISH_TASK_NAME = "publishPlugins";
    public static final String PLUGIN_BUNDLE_EXTENSION_NAME = "pluginBundle";
    static final String SOURCES_CLASSIFIER = "sources";
    static final String JAVADOC_CLASSIFIER = "javadoc";
    static final String GROOVYDOC_CLASSIFIER = "groovydoc";
    static final String POM_EXT = "pom";
    static final String GMM_EXT = "module";
    public static final String JAR_TASK_NAME = "jar";
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishPlugin.class);

    public void apply(final Project project) {
        project.getPlugins().apply("org.gradle.java-library");
        PluginBundleExtension bundle = new PluginBundleExtension(project);
        project.getExtensions().add(PLUGIN_BUNDLE_EXTENSION_NAME, (Object)bundle);
        final PublishTask publishTask = (PublishTask)project.getTasks().create(PUBLISH_TASK_NAME, PublishTask.class);
        publishTask.setDescription(PUBLISH_TASK_DESCRIPTION);
        publishTask.setGroup(PORTAL_BUILD_GROUP_NAME);
        publishTask.setBundleConfig(bundle);
        File pomFile = new File(new File(project.getBuildDir(), "publish-generated-resources"), "pom.xml");
        publishTask.setPomFile(pomFile);
        LOGGER.debug("Setup: publishPlugins of " + this.getClass().getName());
        LoginTask loginTask = (LoginTask)project.getTasks().create(LOGIN_TASK_NAME, LoginTask.class);
        loginTask.setDescription(LOGIN_TASK_DESCRIPTION);
        loginTask.setGroup(PORTAL_BUILD_GROUP_NAME);
        LOGGER.debug("Created task: login of " + this.getClass().getName());
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project finalProject) {
                Configuration archives = project.getConfigurations().getByName("archives");
                PublishPlugin.this.configureDefaultArtifacts(project, archives);
                PublishPlugin.this.setupPublishTaskDependencies(publishTask, archives);
            }
        });
        this.wireToJavaGradlePluginAndMavenPublish(project, bundle.getPlugins(), publishTask);
    }

    private void configureDefaultArtifacts(Project project, Configuration archivesConfiguration) {
        Jar jarTask = (Jar)project.getTasks().getByPath(JAR_TASK_NAME);
        if (this.isDefaultArchiveConfiguration(archivesConfiguration, jarTask)) {
            if (!this.hasOnlyJarTask(archivesConfiguration, jarTask)) {
                this.addArchiveTaskArtifact(archivesConfiguration, jarTask);
            }
            this.addArchiveTaskArtifact(archivesConfiguration, this.createAndSetupJarSourcesTask(project));
            this.addArchiveTaskArtifact(archivesConfiguration, this.createAndSetupJavaDocsTask(project));
            this.addArchiveTaskArtifact(archivesConfiguration, this.createAndSetupGroovyDocsTask(project));
        }
    }

    private void addArchiveTaskArtifact(Configuration archivesConfiguration, Jar task) {
        if (task != null) {
            task.getProject().getArtifacts().add(archivesConfiguration.getName(), (Object)task);
        }
    }

    private boolean isDefaultArchiveConfiguration(Configuration archivesConfiguration, Jar jarTask) {
        return archivesConfiguration.getArtifacts().isEmpty() || this.hasOnlyJarTask(archivesConfiguration, jarTask);
    }

    private boolean hasOnlyJarTask(Configuration archivesConfiguration, Jar jarTask) {
        PublishArtifactSet arts = archivesConfiguration.getAllArtifacts();
        if (PublishPlugin.runningOnPreGradle7()) {
            return arts.size() == 1 && ((PublishArtifact)arts.iterator().next()).getFile().equals(jarTask.getArchivePath());
        }
        return arts.size() == 1 && ((PublishArtifact)arts.iterator().next()).getFile().equals(((RegularFile)jarTask.getArchiveFile().get()).getAsFile());
    }

    private void setupPublishTaskDependencies(PublishTask publishTask, Configuration archivesConfiguration) {
        for (PublishArtifact artifact : archivesConfiguration.getAllArtifacts()) {
            publishTask.dependsOn(new Object[]{artifact});
        }
    }

    private Jar createAndSetupGroovyDocsTask(Project project) {
        if (!project.getPlugins().withType(GroovyPlugin.class).isEmpty()) {
            Jar docsJarTask = this.createBasicDocJarTask(project, GROOVY_DOCS_TASK_NAME, GROOVYDOC_CLASSIFIER, "Assembles a jar archive containing the documentation for Groovy code.");
            Groovydoc groovydoc = (Groovydoc)project.getTasks().findByName(GROOVYDOC_CLASSIFIER);
            docsJarTask.dependsOn(new Object[]{groovydoc});
            docsJarTask.from(new Object[]{groovydoc.getDestinationDir()});
            return docsJarTask;
        }
        return null;
    }

    private Jar createAndSetupJavaDocsTask(Project project) {
        Jar docsJarTask = this.createBasicDocJarTask(project, JAVA_DOCS_TASK_NAME, JAVADOC_CLASSIFIER, "Assembles a jar archive containing the documentation for the main Java source code.");
        Javadoc javadoc = (Javadoc)project.getTasks().findByName(JAVADOC_CLASSIFIER);
        docsJarTask.dependsOn(new Object[]{javadoc});
        docsJarTask.from(new Object[]{javadoc.getDestinationDir()});
        return docsJarTask;
    }

    private Jar createBasicDocJarTask(Project project, String name, String classifier, String description) {
        Jar docsJarTask = (Jar)project.getTasks().create(name, Jar.class);
        docsJarTask.setDescription(description);
        docsJarTask.setGroup("build");
        if (PublishPlugin.runningOnPreGradle7()) {
            docsJarTask.setClassifier(classifier);
        } else {
            docsJarTask.getArchiveClassifier().set((Object)classifier);
        }
        return docsJarTask;
    }

    private Jar createAndSetupJarSourcesTask(Project project) {
        Jar sourcesJarTask = (Jar)project.getTasks().create(SOURCES_JAR_TASK_NAME, Jar.class);
        sourcesJarTask.setDescription("Assembles a jar archive containing the main source code.");
        sourcesJarTask.setGroup("build");
        if (PublishPlugin.runningOnPreGradle7()) {
            sourcesJarTask.setClassifier(SOURCES_CLASSIFIER);
        } else {
            sourcesJarTask.getArchiveClassifier().set((Object)SOURCES_CLASSIFIER);
        }
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName("main");
        SourceDirectorySet allMainSources = mainSourceSet.getAllSource();
        sourcesJarTask.from(new Object[]{allMainSources});
        return sourcesJarTask;
    }

    private void wireToJavaGradlePluginAndMavenPublish(final Project project, final NamedDomainObjectContainer<PluginConfig> pluginConfigs, final PublishTask publishTask) {
        project.getPluginManager().withPlugin("java-gradle-plugin", (Action)new Action<AppliedPlugin>(){

            public void execute(AppliedPlugin appliedPlugin) {
                final GradlePluginDevelopmentExtension pluginDevelopmentExtension = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
                PublishPlugin.this.createPluginsFromJavaGradlePluginDeclarations(pluginDevelopmentExtension, (NamedDomainObjectContainer<PluginConfig>)pluginConfigs, project);
                project.getPluginManager().withPlugin("maven-publish", (Action)new Action<AppliedPlugin>(){

                    public void execute(AppliedPlugin appliedPlugin) {
                        PublishPlugin.this.reusePomFromPluginMavenPublication(project, pluginDevelopmentExtension, publishTask);
                    }
                });
            }
        });
    }

    private void createPluginsFromJavaGradlePluginDeclarations(GradlePluginDevelopmentExtension pluginDevelopmentExtension, final NamedDomainObjectContainer<PluginConfig> pluginConfigs, final Project project) {
        NamedDomainObjectContainer pluginDeclarations = pluginDevelopmentExtension.getPlugins();
        pluginDeclarations.all((Action)new Action<PluginDeclaration>(){

            public void execute(final PluginDeclaration pluginDeclaration) {
                final PluginConfig pluginConfig = (PluginConfig)pluginConfigs.maybeCreate(pluginDeclaration.getName());
                project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        new PluginDeclarationAccessor(pluginDeclaration).configureDefaults(pluginConfig);
                    }
                });
            }
        });
    }

    private void reusePomFromPluginMavenPublication(Project project, final GradlePluginDevelopmentExtension pluginDevelopmentExtension, final PublishTask publishTask) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (pluginDevelopmentExtension.isAutomatedPublishing()) {
                    publishTask.useAutomatedPublishing();
                }
            }
        });
    }

    private static boolean runningOnPreGradle7() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"7.0")) < 0;
    }
}

