/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish.plugin.dep.oauth.signpost.signature;

import com.gradle.publish.plugin.dep.oauth.signpost.OAuth;
import com.gradle.publish.plugin.dep.oauth.signpost.http.HttpParameters;
import com.gradle.publish.plugin.dep.oauth.signpost.http.HttpRequest;
import com.gradle.publish.plugin.dep.oauth.signpost.signature.SigningStrategy;
import java.util.Iterator;

public class QueryStringSigningStrategy
implements SigningStrategy {
    private static final long serialVersionUID = 1L;

    public String writeSignature(String signature, HttpRequest request, HttpParameters requestParameters) {
        HttpParameters oauthParams = requestParameters.getOAuthParameters();
        oauthParams.put("oauth_signature", signature, true);
        Iterator<String> iter = oauthParams.keySet().iterator();
        String firstKey = iter.next();
        StringBuilder sb = new StringBuilder(OAuth.addQueryString(request.getRequestUrl(), oauthParams.getAsQueryString(firstKey)));
        while (iter.hasNext()) {
            sb.append("&");
            String key = iter.next();
            sb.append(oauthParams.getAsQueryString(key));
        }
        String signedUrl = sb.toString();
        request.setRequestUrl(signedUrl);
        return signedUrl;
    }
}

