/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import java.util.HashSet;
import java.util.Map;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractDirectorySensitiveFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class RelativePathFingerprintingStrategy
extends AbstractDirectorySensitiveFingerprintingStrategy {
    private final Interner<String> stringInterner;
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public RelativePathFingerprintingStrategy(Interner<String> interner, DirectorySensitivity directorySensitivity, FileSystemLocationSnapshotHasher fileSystemLocationSnapshotHasher) {
        super("RELATIVE_PATH", directorySensitivity, fileSystemLocationSnapshotHasher);
        this.stringInterner = interner;
        this.normalizedContentHasher = fileSystemLocationSnapshotHasher;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot fileSystemSnapshot) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet hashSet = new HashSet();
        fileSystemSnapshot.accept(new RelativePathTracker(), (fileSystemLocationSnapshot, relativePathSupplier) -> {
            FileSystemLocationFingerprint fileSystemLocationFingerprint;
            String string = fileSystemLocationSnapshot.getAbsolutePath();
            if (!hashSet.add(string) || !this.getDirectorySensitivity().shouldFingerprint(fileSystemLocationSnapshot)) return SnapshotVisitResult.CONTINUE;
            if (relativePathSupplier.isRoot()) {
                if (fileSystemLocationSnapshot.getType() != FileType.RegularFile) return SnapshotVisitResult.CONTINUE;
                fileSystemLocationFingerprint = this.fingerprint(fileSystemLocationSnapshot.getName(), fileSystemLocationSnapshot.getType(), fileSystemLocationSnapshot);
            } else {
                fileSystemLocationFingerprint = this.fingerprint(this.stringInterner.intern(relativePathSupplier.toRelativePath()), fileSystemLocationSnapshot.getType(), fileSystemLocationSnapshot);
            }
            if (fileSystemLocationFingerprint == null) return SnapshotVisitResult.CONTINUE;
            builder.put(string, fileSystemLocationFingerprint);
            return SnapshotVisitResult.CONTINUE;
        });
        return builder.build();
    }

    FileSystemLocationFingerprint fingerprint(String string, FileType fileType, FileSystemLocationSnapshot fileSystemLocationSnapshot) {
        HashCode hashCode = this.getNormalizedContentHash(fileSystemLocationSnapshot, this.normalizedContentHasher);
        return hashCode == null ? null : new DefaultFileSystemLocationFingerprint(string, fileType, hashCode);
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

