/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.function.Supplier;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.file.FilePathUtil;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;

public class DefaultZipEntryContext
implements ZipEntryContext {
    private final ZipEntry entry;
    private final String fullName;
    private final String rootParentName;

    public DefaultZipEntryContext(ZipEntry zipEntry, String string, String string2) {
        this.entry = zipEntry;
        this.fullName = string;
        this.rootParentName = string2;
    }

    @Override
    public ZipEntry getEntry() {
        return this.entry;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getRootParentName() {
        return this.rootParentName;
    }

    @Override
    public Supplier<String[]> getRelativePathSegments() {
        return new ZipEntryRelativePath(this.entry);
    }

    private static class ZipEntryRelativePath
    implements Supplier<String[]> {
        private final ZipEntry zipEntry;

        ZipEntryRelativePath(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }

        @Override
        public String[] get() {
            return FilePathUtil.getPathSegments(this.zipEntry.getName());
        }
    }
}

