/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;

public class VariableReference
extends SpelNodeImpl {
    private final String name;

    public VariableReference(String string, int n2, int n3) {
        super(n2, n3, new SpelNodeImpl[0]);
        this.name = string;
    }

    @Override
    public ValueRef getValueRef(ExpressionState expressionState) throws SpelEvaluationException {
        if (this.name.equals("this")) {
            return new ValueRef.TypedValueHolderValueRef(expressionState.getActiveContextObject(), this);
        }
        if (this.name.equals("root")) {
            return new ValueRef.TypedValueHolderValueRef(expressionState.getRootContextObject(), this);
        }
        TypedValue typedValue = expressionState.lookupVariable(this.name);
        return new VariableRef(this.name, typedValue, expressionState.getEvaluationContext());
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws SpelEvaluationException {
        if (this.name.equals("this")) {
            return expressionState.getActiveContextObject();
        }
        if (this.name.equals("root")) {
            TypedValue typedValue = expressionState.getRootContextObject();
            this.exitTypeDescriptor = CodeFlow.toDescriptorFromObject(typedValue.getValue());
            return typedValue;
        }
        TypedValue typedValue = expressionState.lookupVariable(this.name);
        Object object = typedValue.getValue();
        this.exitTypeDescriptor = object == null || !Modifier.isPublic(object.getClass().getModifiers()) ? "Ljava/lang/Object" : CodeFlow.toDescriptorFromObject(object);
        return typedValue;
    }

    @Override
    public TypedValue setValueInternal(ExpressionState expressionState, Supplier<TypedValue> supplier) throws EvaluationException {
        return expressionState.assignVariable(this.name, supplier);
    }

    @Override
    public String toStringAST() {
        return "#" + this.name;
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        if (this.name.equals("root")) {
            methodVisitor.visitVarInsn(25, 1);
        } else {
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitLdcInsn(this.name);
            methodVisitor.visitMethodInsn(185, "com/gradle/maven/extension/internal/dep/org/springframework/expression/EvaluationContext", "lookupVariable", "(Ljava/lang/String;)Ljava/lang/Object;", true);
        }
        CodeFlow.insertCheckCast(methodVisitor, this.exitTypeDescriptor);
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }

    private static class VariableRef
    implements ValueRef {
        private final String name;
        private final TypedValue value;
        private final EvaluationContext evaluationContext;

        public VariableRef(String string, TypedValue typedValue, EvaluationContext evaluationContext) {
            this.name = string;
            this.value = typedValue;
            this.evaluationContext = evaluationContext;
        }

        @Override
        public TypedValue getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object object) {
            this.evaluationContext.setVariable(this.name, object);
        }
    }
}

