/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.Label;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorNot
extends SpelNodeImpl {
    public OperatorNot(int n2, int n3, SpelNodeImpl spelNodeImpl) {
        super(n2, n3, spelNodeImpl);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        try {
            Boolean bl2 = this.children[0].getValue(expressionState, Boolean.class);
            if (bl2 == null) {
                throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
            }
            return BooleanTypedValue.forValue(bl2 == false);
        }
        catch (SpelEvaluationException spelEvaluationException) {
            spelEvaluationException.setPosition(this.getChild(0).getStartPosition());
            throw spelEvaluationException;
        }
    }

    @Override
    public String toStringAST() {
        return "!" + this.getChild(0).toStringAST();
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl spelNodeImpl = this.children[0];
        return spelNodeImpl.isCompilable() && CodeFlow.isBooleanCompatible(spelNodeImpl.exitTypeDescriptor);
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        this.children[0].generateCode(methodVisitor, codeFlow);
        codeFlow.unboxBooleanIfNecessary(methodVisitor);
        Label label = new Label();
        Label label2 = new Label();
        methodVisitor.visitJumpInsn(154, label);
        methodVisitor.visitInsn(4);
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label);
        methodVisitor.visitInsn(3);
        methodVisitor.visitLabel(label2);
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

