/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.common;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;

public abstract class ExpressionUtils {
    public static <T> T convertTypedValue(EvaluationContext evaluationContext, TypedValue typedValue, Class<T> clazz) {
        Object object = typedValue.getValue();
        if (clazz == null) {
            return (T)object;
        }
        if (evaluationContext != null) {
            return (T)evaluationContext.getTypeConverter().convertValue(object, typedValue.getTypeDescriptor(), TypeDescriptor.valueOf(clazz));
        }
        if (ClassUtils.isAssignableValue(clazz, object)) {
            return (T)object;
        }
        throw new EvaluationException("Cannot convert value '" + object + "' to type '" + clazz.getName() + "'");
    }

    public static int toInt(TypeConverter typeConverter, TypedValue typedValue) {
        return ExpressionUtils.convertValue(typeConverter, typedValue, Integer.class);
    }

    public static boolean toBoolean(TypeConverter typeConverter, TypedValue typedValue) {
        return ExpressionUtils.convertValue(typeConverter, typedValue, Boolean.class);
    }

    public static double toDouble(TypeConverter typeConverter, TypedValue typedValue) {
        return ExpressionUtils.convertValue(typeConverter, typedValue, Double.class);
    }

    public static long toLong(TypeConverter typeConverter, TypedValue typedValue) {
        return ExpressionUtils.convertValue(typeConverter, typedValue, Long.class);
    }

    public static char toChar(TypeConverter typeConverter, TypedValue typedValue) {
        return ExpressionUtils.convertValue(typeConverter, typedValue, Character.class).charValue();
    }

    public static short toShort(TypeConverter typeConverter, TypedValue typedValue) {
        return ExpressionUtils.convertValue(typeConverter, typedValue, Short.class);
    }

    public static float toFloat(TypeConverter typeConverter, TypedValue typedValue) {
        return ExpressionUtils.convertValue(typeConverter, typedValue, Float.class).floatValue();
    }

    public static byte toByte(TypeConverter typeConverter, TypedValue typedValue) {
        return ExpressionUtils.convertValue(typeConverter, typedValue, Byte.class);
    }

    private static <T> T convertValue(TypeConverter typeConverter, TypedValue typedValue, Class<T> clazz) {
        Object object = typeConverter.convertValue(typedValue.getValue(), typedValue.getTypeDescriptor(), TypeDescriptor.valueOf(clazz));
        if (object == null) {
            throw new IllegalStateException("Null conversion result for value [" + typedValue.getValue() + "]");
        }
        return (T)object;
    }
}

