/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ObjectToObjectConverter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;

final class FallbackObjectToStringConverter
implements ConditionalGenericConverter {
    FallbackObjectToStringConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        Class<?> clazz = typeDescriptor.getObjectType();
        if (String.class == clazz) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(clazz) || StringWriter.class.isAssignableFrom(clazz) || ObjectToObjectConverter.hasConversionMethodOrConstructor(clazz, String.class);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return object != null ? object.toString() : null;
    }
}

