/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class ByteBufferConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor BYTE_BUFFER_TYPE = TypeDescriptor.valueOf(ByteBuffer.class);
    private static final TypeDescriptor BYTE_ARRAY_TYPE = TypeDescriptor.valueOf(byte[].class);
    private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_PAIRS;
    private final ConversionService conversionService;

    public ByteBufferConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return CONVERTIBLE_PAIRS;
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        boolean bl2 = typeDescriptor2.isAssignableTo(BYTE_BUFFER_TYPE);
        if (typeDescriptor.isAssignableTo(BYTE_BUFFER_TYPE)) {
            return bl2 || this.matchesFromByteBuffer(typeDescriptor2);
        }
        return bl2 && this.matchesToByteBuffer(typeDescriptor);
    }

    private boolean matchesFromByteBuffer(TypeDescriptor typeDescriptor) {
        return typeDescriptor.isAssignableTo(BYTE_ARRAY_TYPE) || this.conversionService.canConvert(BYTE_ARRAY_TYPE, typeDescriptor);
    }

    private boolean matchesToByteBuffer(TypeDescriptor typeDescriptor) {
        return typeDescriptor.isAssignableTo(BYTE_ARRAY_TYPE) || this.conversionService.canConvert(typeDescriptor, BYTE_ARRAY_TYPE);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        boolean bl2 = typeDescriptor2.isAssignableTo(BYTE_BUFFER_TYPE);
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            return bl2 ? byteBuffer.duplicate() : this.convertFromByteBuffer(byteBuffer, typeDescriptor2);
        }
        if (bl2) {
            return this.convertToByteBuffer(object, typeDescriptor);
        }
        throw new IllegalStateException("Unexpected source/target types");
    }

    private Object convertFromByteBuffer(ByteBuffer byteBuffer, TypeDescriptor typeDescriptor) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        if (typeDescriptor.isAssignableTo(BYTE_ARRAY_TYPE)) {
            return byArray;
        }
        return this.conversionService.convert(byArray, BYTE_ARRAY_TYPE, typeDescriptor);
    }

    private Object convertToByteBuffer(Object object, TypeDescriptor typeDescriptor) {
        byte[] byArray = (byte[])(object instanceof byte[] ? object : this.conversionService.convert(object, typeDescriptor, BYTE_ARRAY_TYPE));
        if (byArray == null) {
            return ByteBuffer.wrap(new byte[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.put(byArray);
        return ((Buffer)byteBuffer).rewind();
    }

    static {
        HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>(4);
        hashSet.add(new GenericConverter.ConvertiblePair(ByteBuffer.class, byte[].class));
        hashSet.add(new GenericConverter.ConvertiblePair(byte[].class, ByteBuffer.class));
        hashSet.add(new GenericConverter.ConvertiblePair(ByteBuffer.class, Object.class));
        hashSet.add(new GenericConverter.ConvertiblePair(Object.class, ByteBuffer.class));
        CONVERTIBLE_PAIRS = Collections.unmodifiableSet(hashSet);
    }
}

