/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.util;

import com.gradle.maven.extension.internal.dep.org.apache.http.util.TextUtils;
import java.util.Collection;

public class Args {
    public static void check(boolean bl2, String string) {
        if (!bl2) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void check(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static <T> T notNull(T t2, String string) {
        if (t2 == null) {
            throw new IllegalArgumentException(string + " may not be null");
        }
        return t2;
    }

    public static <T extends CharSequence> T notEmpty(T t2, String string) {
        if (t2 == null) {
            throw new IllegalArgumentException(string + " may not be null");
        }
        if (TextUtils.isEmpty(t2)) {
            throw new IllegalArgumentException(string + " may not be empty");
        }
        return t2;
    }

    public static <T extends CharSequence> T notBlank(T t2, String string) {
        if (t2 == null) {
            throw new IllegalArgumentException(string + " may not be null");
        }
        if (TextUtils.isBlank(t2)) {
            throw new IllegalArgumentException(string + " may not be blank");
        }
        return t2;
    }

    public static <T extends CharSequence> T containsNoBlanks(T t2, String string) {
        if (t2 == null) {
            throw new IllegalArgumentException(string + " may not be null");
        }
        if (t2.length() == 0) {
            throw new IllegalArgumentException(string + " may not be empty");
        }
        if (TextUtils.containsBlanks(t2)) {
            throw new IllegalArgumentException(string + " may not contain blanks");
        }
        return t2;
    }

    public static <E, T extends Collection<E>> T notEmpty(T t2, String string) {
        if (t2 == null) {
            throw new IllegalArgumentException(string + " may not be null");
        }
        if (t2.isEmpty()) {
            throw new IllegalArgumentException(string + " may not be empty");
        }
        return t2;
    }

    public static int positive(int n2, String string) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(string + " may not be negative or zero");
        }
        return n2;
    }

    public static int notNegative(int n2, String string) {
        if (n2 < 0) {
            throw new IllegalArgumentException(string + " may not be negative");
        }
        return n2;
    }

    public static long notNegative(long l2, String string) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + " may not be negative");
        }
        return l2;
    }
}

