/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.Builder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.ModelBuilderFactory;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.impl.ModelBuilder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.JavaClassContext;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultDocletTagFactory;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.ClassDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.writer.ModelWriterFactory;

public abstract class AbstractClassLibrary
implements ClassLibrary {
    private AbstractClassLibrary parentClassLibrary;
    private ModelBuilderFactory modelBuilderFactory;
    private ModelWriterFactory modelWriterFactory;
    private JavaClassContext context = new JavaClassContext();

    public AbstractClassLibrary() {
    }

    public AbstractClassLibrary(AbstractClassLibrary abstractClassLibrary) {
        this.parentClassLibrary = abstractClassLibrary;
    }

    @Override
    public final JavaClass getJavaClass(String string) {
        return this.getJavaClass(string, false);
    }

    public final JavaClass getJavaClass(String string, boolean bl2) {
        JavaClass javaClass = this.context.getClassByName(string);
        if (javaClass == null && (javaClass = this.resolveJavaClass(string)) != null) {
            this.context.add(javaClass);
            this.context.add(javaClass.getSource());
            JavaPackage javaPackage = this.context.getPackageByName(javaClass.getPackageName());
            if (javaPackage == null) {
                DefaultJavaPackage defaultJavaPackage = new DefaultJavaPackage(javaClass.getPackageName());
                defaultJavaPackage.setClassLibrary(this);
                this.context.add(defaultJavaPackage);
                javaPackage = defaultJavaPackage;
            }
            javaPackage.getClasses().addAll(javaClass.getNestedClasses());
        }
        if (javaClass == null && this.parentClassLibrary != null) {
            javaClass = this.parentClassLibrary.getJavaClass(string);
        }
        if (javaClass == null && bl2) {
            javaClass = this.createStub(string);
        }
        return javaClass;
    }

    private JavaClass createStub(String string) {
        Builder builder = this.getModelBuilder();
        builder.beginClass(new ClassDef(string));
        builder.endClass();
        JavaSource javaSource = builder.getSource();
        return javaSource.getClasses().get(0);
    }

    protected abstract JavaClass resolveJavaClass(String var1);

    @Override
    public final JavaPackage getJavaPackage(String string) {
        JavaPackage javaPackage = this.context.getPackageByName(string);
        if (javaPackage == null && (javaPackage = this.resolveJavaPackage(string)) != null) {
            this.context.add(javaPackage);
        }
        if (javaPackage == null && this.parentClassLibrary != null) {
            javaPackage = this.parentClassLibrary.getJavaPackage(string);
        }
        return javaPackage;
    }

    protected abstract JavaPackage resolveJavaPackage(String var1);

    @Override
    public boolean hasClassReference(String string) {
        boolean bl2;
        boolean bl3 = bl2 = this.context.getClassByName(string) != null;
        if (!bl2) {
            bl2 = this.containsClassReference(string);
        }
        if (!bl2 && this.parentClassLibrary != null) {
            bl2 = this.parentClassLibrary.hasClassReference(string);
        }
        return bl2;
    }

    protected abstract boolean containsClassReference(String var1);

    protected Builder getModelBuilder() {
        ModelBuilder modelBuilder = this.modelBuilderFactory != null ? this.modelBuilderFactory.newInstance(this) : new ModelBuilder(this, new DefaultDocletTagFactory());
        modelBuilder.setModelWriterFactory(this.modelWriterFactory);
        return modelBuilder;
    }
}

