/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class Chars {
    public static int hashCode(char c2) {
        return c2;
    }

    private static int indexOf(char[] cArray, char c2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(char[] cArray, char c2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public static List<Character> asList(char ... cArray) {
        if (cArray.length == 0) {
            return Collections.emptyList();
        }
        return new CharArrayAsList(cArray);
    }

    private static class CharArrayAsList
    extends AbstractList<Character>
    implements Serializable,
    RandomAccess {
        final char[] array;
        final int start;
        final int end;

        CharArrayAsList(char[] cArray) {
            this(cArray, 0, cArray.length);
        }

        CharArrayAsList(char[] cArray, int n2, int n3) {
            this.array = cArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Character get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return Character.valueOf(this.array[this.start + n2]);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Character && Chars.indexOf(this.array, ((Character)object).charValue(), this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Character && (n2 = Chars.indexOf(this.array, ((Character)object).charValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Character && (n2 = Chars.lastIndexOf(this.array, ((Character)object).charValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Character set(int n2, Character c2) {
            Preconditions.checkElementIndex(n2, this.size());
            char c3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(c2).charValue();
            return Character.valueOf(c3);
        }

        @Override
        public List<Character> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new CharArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CharArrayAsList) {
                CharArrayAsList charArrayAsList = (CharArrayAsList)object;
                int n2 = this.size();
                if (charArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == charArrayAsList.array[charArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Chars.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 3);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }
    }
}

