/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class Bytes {
    public static int hashCode(byte by2) {
        return by2;
    }

    private static int indexOf(byte[] byArray, byte by2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (byArray[i2] != by2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(byte[] byArray, byte by2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (byArray[i2] != by2) continue;
            return i2;
        }
        return -1;
    }

    public static List<Byte> asList(byte ... byArray) {
        if (byArray.length == 0) {
            return Collections.emptyList();
        }
        return new ByteArrayAsList(byArray);
    }

    private static class ByteArrayAsList
    extends AbstractList<Byte>
    implements Serializable,
    RandomAccess {
        final byte[] array;
        final int start;
        final int end;

        ByteArrayAsList(byte[] byArray) {
            this(byArray, 0, byArray.length);
        }

        ByteArrayAsList(byte[] byArray, int n2, int n3) {
            this.array = byArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Byte get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Byte && Bytes.indexOf(this.array, (Byte)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Byte && (n2 = Bytes.indexOf(this.array, (Byte)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Byte && (n2 = Bytes.lastIndexOf(this.array, (Byte)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Byte set(int n2, Byte by2) {
            Preconditions.checkElementIndex(n2, this.size());
            byte by3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(by2);
            return by3;
        }

        @Override
        public List<Byte> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new ByteArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ByteArrayAsList) {
                ByteArrayAsList byteArrayAsList = (ByteArrayAsList)object;
                int n2 = this.size();
                if (byteArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == byteArrayAsList.array[byteArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Bytes.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 5);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }
    }
}

