/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlNameProcessor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlNameProcessors;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLInputFactory2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.io.Stax2ByteArraySource;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.io.Stax2CharArraySource;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XmlFactory
extends JsonFactory {
    static final int DEFAULT_XML_PARSER_FEATURE_FLAGS = FromXmlParser.Feature.collectDefaults();
    static final int DEFAULT_XML_GENERATOR_FEATURE_FLAGS = ToXmlGenerator.Feature.collectDefaults();
    protected int _xmlParserFeatures;
    protected int _xmlGeneratorFeatures;
    protected transient XMLInputFactory _xmlInputFactory;
    protected transient XMLOutputFactory _xmlOutputFactory;
    protected String _cfgNameForTextElement;
    protected XmlNameProcessor _nameProcessor;

    public XmlFactory() {
        this(null, null, null);
    }

    public XmlFactory(XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        this(null, xMLInputFactory, xMLOutputFactory);
    }

    public XmlFactory(ObjectCodec objectCodec, XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        this(objectCodec, DEFAULT_XML_PARSER_FEATURE_FLAGS, DEFAULT_XML_GENERATOR_FEATURE_FLAGS, xMLInputFactory, xMLOutputFactory, null);
    }

    public XmlFactory(ObjectCodec objectCodec, int n2, int n3, XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory, String string) {
        this(objectCodec, n2, n3, xMLInputFactory, xMLOutputFactory, string, XmlNameProcessors.newPassthroughProcessor());
    }

    protected XmlFactory(ObjectCodec objectCodec, int n2, int n3, XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory, String string, XmlNameProcessor xmlNameProcessor) {
        super(objectCodec);
        this._nameProcessor = xmlNameProcessor;
        this._xmlParserFeatures = n2;
        this._xmlGeneratorFeatures = n3;
        this._cfgNameForTextElement = string;
        if (xMLInputFactory == null) {
            xMLInputFactory = StaxUtil.defaultInputFactory(this.getClass().getClassLoader());
            xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xMLInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        }
        if (xMLOutputFactory == null) {
            xMLOutputFactory = StaxUtil.defaultOutputFactory(this.getClass().getClassLoader());
            xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
        this._initFactories(xMLInputFactory, xMLOutputFactory);
        this._xmlInputFactory = xMLInputFactory;
        this._xmlOutputFactory = xMLOutputFactory;
    }

    protected void _initFactories(XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }

    public void setXMLTextElementName(String string) {
        this._cfgNameForTextElement = string;
    }

    @Override
    public String getFormatName() {
        return "XML";
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    @Override
    public JsonParser createParser(String string) throws IOException {
        Reader reader = new StringReader(string);
        IOContext iOContext = this._createContext(this._createContentReference(reader), true);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createParser(reader, iOContext);
    }

    @Override
    public ToXmlGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    @Override
    public ToXmlGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(outputStream), false);
        iOContext.setEncoding(jsonEncoding);
        return new ToXmlGenerator(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(iOContext, outputStream), this._nameProcessor);
    }

    @Override
    public ToXmlGenerator createGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(writer), false);
        return new ToXmlGenerator(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(iOContext, writer), this._nameProcessor);
    }

    @Override
    public ToXmlGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOContext iOContext = this._createContext(this._createContentReference(fileOutputStream), true);
        iOContext.setEncoding(jsonEncoding);
        return new ToXmlGenerator(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(iOContext, fileOutputStream), this._nameProcessor);
    }

    @Override
    protected FromXmlParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory.createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)StaxUtil.throwAsParseException(xMLStreamException, null);
        }
        xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Override
    protected FromXmlParser _createParser(Reader reader, IOContext iOContext) throws IOException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)StaxUtil.throwAsParseException(xMLStreamException, null);
        }
        xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Override
    protected FromXmlParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl2) throws IOException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory instanceof XMLInputFactory2 ? this._xmlInputFactory.createXMLStreamReader(new Stax2CharArraySource(cArray, n2, n3)) : this._xmlInputFactory.createXMLStreamReader(new CharArrayReader(cArray, n2, n3));
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)StaxUtil.throwAsParseException(xMLStreamException, null);
        }
        xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Override
    protected FromXmlParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) throws IOException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory instanceof XMLInputFactory2 ? this._xmlInputFactory.createXMLStreamReader(new Stax2ByteArraySource(byArray, n2, n3)) : this._xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(byArray, n2, n3));
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)StaxUtil.throwAsParseException(xMLStreamException, null);
        }
        xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._parserFeatures, this._xmlParserFeatures, this._objectCodec, xMLStreamReader, this._nameProcessor);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Override
    protected JsonGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        VersionUtil.throwInternal();
        return null;
    }

    protected XMLStreamWriter _createXmlWriter(IOContext iOContext, OutputStream outputStream) throws IOException {
        XMLStreamWriter xMLStreamWriter;
        try {
            xMLStreamWriter = this._xmlOutputFactory.createXMLStreamWriter(this._decorate(iOContext, outputStream), "UTF-8");
        }
        catch (Exception exception) {
            throw new JsonGenerationException(exception.getMessage(), exception, null);
        }
        return this._initializeXmlWriter(xMLStreamWriter);
    }

    protected XMLStreamWriter _createXmlWriter(IOContext iOContext, Writer writer) throws IOException {
        XMLStreamWriter xMLStreamWriter;
        try {
            xMLStreamWriter = this._xmlOutputFactory.createXMLStreamWriter(this._decorate(iOContext, writer));
        }
        catch (Exception exception) {
            throw new JsonGenerationException(exception.getMessage(), exception, null);
        }
        return this._initializeXmlWriter(xMLStreamWriter);
    }

    protected final XMLStreamWriter _initializeXmlWriter(XMLStreamWriter xMLStreamWriter) throws IOException {
        try {
            xMLStreamWriter.setDefaultNamespace("");
        }
        catch (Exception exception) {
            throw new JsonGenerationException(exception.getMessage(), exception, null);
        }
        return xMLStreamWriter;
    }

    protected final XMLStreamReader _initializeXmlReader(XMLStreamReader xMLStreamReader) throws IOException {
        try {
            while (xMLStreamReader.next() != 1) {
            }
        }
        catch (Exception exception) {
            throw new JsonParseException(null, exception.getMessage(), (Throwable)exception);
        }
        return xMLStreamReader;
    }

    protected OutputStream _decorate(IOContext iOContext, OutputStream outputStream) throws IOException {
        OutputStream outputStream2;
        if (this._outputDecorator != null && (outputStream2 = this._outputDecorator.decorate(iOContext, outputStream)) != null) {
            return outputStream2;
        }
        return outputStream;
    }

    protected Writer _decorate(IOContext iOContext, Writer writer) throws IOException {
        Writer writer2;
        if (this._outputDecorator != null && (writer2 = this._outputDecorator.decorate(iOContext, writer)) != null) {
            return writer2;
        }
        return writer;
    }
}

