/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.internal;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.internal.Linked;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class LinkedDeque<E extends Linked<E>>
extends AbstractCollection<E>
implements Deque<E> {
    E first;
    E last;

    LinkedDeque() {
    }

    void linkFirst(E e2) {
        E e3 = this.first;
        this.first = e2;
        if (e3 == null) {
            this.last = e2;
        } else {
            e3.setPrevious(e2);
            e2.setNext(e3);
        }
    }

    void linkLast(E e2) {
        E e3 = this.last;
        this.last = e2;
        if (e3 == null) {
            this.first = e2;
        } else {
            e3.setNext(e2);
            e2.setPrevious(e3);
        }
    }

    E unlinkFirst() {
        E e2 = this.first;
        Object object = e2.getNext();
        e2.setNext(null);
        this.first = object;
        if (object == null) {
            this.last = null;
        } else {
            object.setPrevious(null);
        }
        return e2;
    }

    E unlinkLast() {
        E e2 = this.last;
        Object object = e2.getPrevious();
        e2.setPrevious(null);
        this.last = object;
        if (object == null) {
            this.first = null;
        } else {
            object.setNext(null);
        }
        return e2;
    }

    void unlink(E e2) {
        Object t2 = e2.getPrevious();
        Object t3 = e2.getNext();
        if (t2 == null) {
            this.first = t3;
        } else {
            t2.setNext(t3);
            e2.setPrevious(null);
        }
        if (t3 == null) {
            this.last = t2;
        } else {
            t3.setPrevious(t2);
            e2.setNext(null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    void checkNotEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int size() {
        int n2 = 0;
        for (Object object = this.first; object != null; object = object.getNext()) {
            ++n2;
        }
        return n2;
    }

    @Override
    public void clear() {
        Object object = this.first;
        while (object != null) {
            Object t2 = object.getNext();
            object.setPrevious(null);
            object.setNext(null);
            object = t2;
        }
        this.last = null;
        this.first = null;
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Linked && this.contains((Linked)object);
    }

    boolean contains(Linked<?> linked) {
        return linked.getPrevious() != null || linked.getNext() != null || linked == this.first;
    }

    public void moveToBack(E e2) {
        if (e2 != this.last) {
            this.unlink(e2);
            this.linkLast(e2);
        }
    }

    @Override
    public E peek() {
        return (E)this.peekFirst();
    }

    @Override
    public E peekFirst() {
        return this.first;
    }

    @Override
    public E peekLast() {
        return this.last;
    }

    @Override
    public E getFirst() {
        this.checkNotEmpty();
        return (E)this.peekFirst();
    }

    @Override
    public E getLast() {
        this.checkNotEmpty();
        return (E)this.peekLast();
    }

    @Override
    public E element() {
        return (E)this.getFirst();
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public boolean offerFirst(E e2) {
        if (this.contains((Linked<?>)e2)) {
            return false;
        }
        this.linkFirst(e2);
        return true;
    }

    @Override
    public boolean offerLast(E e2) {
        if (this.contains((Linked<?>)e2)) {
            return false;
        }
        this.linkLast(e2);
        return true;
    }

    @Override
    public boolean add(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public void addFirst(E e2) {
        if (!this.offerFirst(e2)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void addLast(E e2) {
        if (!this.offerLast(e2)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public E poll() {
        return (E)this.pollFirst();
    }

    @Override
    public E pollFirst() {
        return this.isEmpty() ? null : (E)this.unlinkFirst();
    }

    @Override
    public E pollLast() {
        return this.isEmpty() ? null : (E)this.unlinkLast();
    }

    @Override
    public E remove() {
        return (E)this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Linked && this.remove((E)((Linked)object));
    }

    @Override
    boolean remove(E e2) {
        if (this.contains((Linked<?>)e2)) {
            this.unlink(e2);
            return true;
        }
        return false;
    }

    @Override
    public E removeFirst() {
        this.checkNotEmpty();
        return (E)this.pollFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        return this.remove(object);
    }

    @Override
    public E removeLast() {
        this.checkNotEmpty();
        return (E)this.pollLast();
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        return this.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl2 = false;
        for (Object obj : collection) {
            bl2 |= this.remove(obj);
        }
        return bl2;
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public E pop() {
        return (E)this.removeFirst();
    }

    @Override
    public Iterator<E> iterator() {
        return new AbstractLinkedIterator((Linked)this.first){

            @Override
            E computeNext() {
                return this.cursor.getNext();
            }
        };
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new AbstractLinkedIterator((Linked)this.last){

            @Override
            E computeNext() {
                return this.cursor.getPrevious();
            }
        };
    }

    static abstract class AbstractLinkedIterator
    implements Iterator<E> {
        E cursor;
        final /* synthetic */ LinkedDeque this$0;

        AbstractLinkedIterator(E e2) {
            this.this$0 = var1_1;
            this.cursor = e2;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object e2 = this.cursor;
            this.cursor = this.computeNext();
            return e2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        abstract E computeNext();
    }
}

