/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.impl;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;

public abstract class FilteredBeanPropertyWriter {
    public static BeanPropertyWriter constructViewBased(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
        if (classArray.length == 1) {
            return new SingleView(beanPropertyWriter, classArray[0]);
        }
        return new MultiView(beanPropertyWriter, classArray);
    }

    private static final class MultiView
    extends BeanPropertyWriter
    implements Serializable {
        protected final BeanPropertyWriter _delegate;
        protected final Class<?>[] _views;

        protected MultiView(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
            super(beanPropertyWriter);
            this._delegate = beanPropertyWriter;
            this._views = classArray;
        }

        @Override
        public MultiView rename(NameTransformer nameTransformer) {
            return new MultiView(this._delegate.rename(nameTransformer), this._views);
        }

        @Override
        public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
            this._delegate.assignSerializer(jsonSerializer);
        }

        @Override
        public void assignNullSerializer(JsonSerializer<Object> jsonSerializer) {
            this._delegate.assignNullSerializer(jsonSerializer);
        }

        @Override
        public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
            if (this._inView(serializerProvider.getActiveView())) {
                this._delegate.serializeAsField(object, jsonGenerator, serializerProvider);
                return;
            }
            this._delegate.serializeAsOmittedField(object, jsonGenerator, serializerProvider);
        }

        @Override
        public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
            if (this._inView(serializerProvider.getActiveView())) {
                this._delegate.serializeAsElement(object, jsonGenerator, serializerProvider);
                return;
            }
            this._delegate.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
            if (this._inView(serializerProvider.getActiveView())) {
                super.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
            }
        }

        private final boolean _inView(Class<?> clazz) {
            if (clazz == null) {
                return true;
            }
            int n2 = this._views.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this._views[i2].isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SingleView
    extends BeanPropertyWriter
    implements Serializable {
        protected final BeanPropertyWriter _delegate;
        protected final Class<?> _view;

        protected SingleView(BeanPropertyWriter beanPropertyWriter, Class<?> clazz) {
            super(beanPropertyWriter);
            this._delegate = beanPropertyWriter;
            this._view = clazz;
        }

        @Override
        public SingleView rename(NameTransformer nameTransformer) {
            return new SingleView(this._delegate.rename(nameTransformer), this._view);
        }

        @Override
        public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
            this._delegate.assignSerializer(jsonSerializer);
        }

        @Override
        public void assignNullSerializer(JsonSerializer<Object> jsonSerializer) {
            this._delegate.assignNullSerializer(jsonSerializer);
        }

        @Override
        public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
            Class<?> clazz = serializerProvider.getActiveView();
            if (clazz == null || this._view.isAssignableFrom(clazz)) {
                this._delegate.serializeAsField(object, jsonGenerator, serializerProvider);
            } else {
                this._delegate.serializeAsOmittedField(object, jsonGenerator, serializerProvider);
            }
        }

        @Override
        public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
            Class<?> clazz = serializerProvider.getActiveView();
            if (clazz == null || this._view.isAssignableFrom(clazz)) {
                this._delegate.serializeAsElement(object, jsonGenerator, serializerProvider);
            } else {
                this._delegate.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
            }
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
            Class<?> clazz = serializerProvider.getActiveView();
            if (clazz == null || this._view.isAssignableFrom(clazz)) {
                super.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
            }
        }
    }
}

