/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

public class SymbolTable {
    protected static final int DEFAULT_TABLE_SIZE = 128;
    protected static final float DEFAULT_FILL_FACTOR = 0.75f;
    protected static final String EMPTY_STRING = "";
    protected boolean mInternStrings;
    protected String[] mSymbols;
    protected Bucket[] mBuckets;
    protected int mSize;
    protected int mSizeThreshold;
    protected int mIndexMask;
    protected int mThisVersion;
    protected boolean mDirty;

    public SymbolTable() {
        this(true);
    }

    public SymbolTable(boolean bl2) {
        this(bl2, 128);
    }

    public SymbolTable(boolean bl2, int n2) {
        this(bl2, n2, 0.75f);
    }

    public SymbolTable(boolean bl2, int n2, float f2) {
        int n3;
        this.mInternStrings = bl2;
        this.mThisVersion = 1;
        this.mDirty = true;
        if (n2 < 1) {
            throw new IllegalArgumentException("Can not use negative/zero initial size: " + n2);
        }
        for (n3 = 4; n3 < n2; n3 += n3) {
        }
        n2 = n3;
        this.mSymbols = new String[n2];
        this.mBuckets = new Bucket[n2 >> 1];
        this.mIndexMask = n2 - 1;
        this.mSize = 0;
        if (f2 < 0.01f) {
            throw new IllegalArgumentException("Fill factor can not be lower than 0.01.");
        }
        if (f2 > 10.0f) {
            throw new IllegalArgumentException("Fill factor can not be higher than 10.0.");
        }
        this.mSizeThreshold = (int)((double)((float)n2 * f2) + 0.5);
    }

    private SymbolTable(boolean bl2, String[] stringArray, Bucket[] bucketArray, int n2, int n3, int n4, int n5) {
        this.mInternStrings = bl2;
        this.mSymbols = stringArray;
        this.mBuckets = bucketArray;
        this.mSize = n2;
        this.mSizeThreshold = n3;
        this.mIndexMask = n4;
        this.mThisVersion = n5;
        this.mDirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolTable makeChild() {
        int n2;
        int n3;
        int n4;
        int n5;
        Bucket[] bucketArray;
        String[] stringArray;
        boolean bl2;
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            bl2 = this.mInternStrings;
            stringArray = this.mSymbols;
            bucketArray = this.mBuckets;
            n5 = this.mSize;
            n4 = this.mSizeThreshold;
            n3 = this.mIndexMask;
            n2 = this.mThisVersion + 1;
        }
        return new SymbolTable(bl2, stringArray, bucketArray, n5, n4, n3, n2);
    }

    public synchronized void mergeChild(SymbolTable symbolTable) {
        if (symbolTable.size() <= this.size()) {
            return;
        }
        this.mSymbols = symbolTable.mSymbols;
        this.mBuckets = symbolTable.mBuckets;
        this.mSize = symbolTable.mSize;
        this.mSizeThreshold = symbolTable.mSizeThreshold;
        this.mIndexMask = symbolTable.mIndexMask;
        ++this.mThisVersion;
        this.mDirty = false;
        symbolTable.mDirty = false;
    }

    public void setInternStrings(boolean bl2) {
        this.mInternStrings = bl2;
    }

    public int size() {
        return this.mSize;
    }

    public int version() {
        return this.mThisVersion;
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    public boolean isDirectChildOf(SymbolTable symbolTable) {
        return this.mThisVersion == symbolTable.mThisVersion + 1;
    }

    public String findSymbol(char[] cArray, int n2, int n3, int n4) {
        Object object;
        if (n3 < 1) {
            return EMPTY_STRING;
        }
        String string = this.mSymbols[n4 &= this.mIndexMask];
        if (string != null) {
            if (string.length() == n3) {
                int n5 = 0;
                while (string.charAt(n5) == cArray[n2 + n5] && ++n5 < n3) {
                }
                if (n5 == n3) {
                    return string;
                }
            }
            if ((object = this.mBuckets[n4 >> 1]) != null && (string = ((Bucket)object).find(cArray, n2, n3)) != null) {
                return string;
            }
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            n4 = SymbolTable.calcHash(cArray, n2, n3) & this.mIndexMask;
        } else if (!this.mDirty) {
            this.copyArrays();
            this.mDirty = true;
        }
        ++this.mSize;
        object = new String(cArray, n2, n3);
        if (this.mInternStrings) {
            object = ((String)object).intern();
        }
        if (this.mSymbols[n4] == null) {
            this.mSymbols[n4] = object;
        } else {
            int n6 = n4 >> 1;
            this.mBuckets[n6] = new Bucket((String)object, this.mBuckets[n6]);
        }
        return object;
    }

    public String findSymbolIfExists(char[] cArray, int n2, int n3, int n4) {
        if (n3 < 1) {
            return EMPTY_STRING;
        }
        String string = this.mSymbols[n4 &= this.mIndexMask];
        if (string != null) {
            Bucket bucket;
            if (string.length() == n3) {
                int n5 = 0;
                while (string.charAt(n5) == cArray[n2 + n5] && ++n5 < n3) {
                }
                if (n5 == n3) {
                    return string;
                }
            }
            if ((bucket = this.mBuckets[n4 >> 1]) != null && (string = bucket.find(cArray, n2, n3)) != null) {
                return string;
            }
        }
        return null;
    }

    public String findSymbol(String string) {
        int n2 = string.length();
        if (n2 < 1) {
            return EMPTY_STRING;
        }
        int n3 = SymbolTable.calcHash(string) & this.mIndexMask;
        String string2 = this.mSymbols[n3];
        if (string2 != null) {
            Bucket bucket;
            if (string2.length() == n2) {
                int n4;
                for (n4 = 0; n4 < n2 && string2.charAt(n4) == string.charAt(n4); ++n4) {
                }
                if (n4 == n2) {
                    return string2;
                }
            }
            if ((bucket = this.mBuckets[n3 >> 1]) != null && (string2 = bucket.find(string)) != null) {
                return string2;
            }
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            n3 = SymbolTable.calcHash(string) & this.mIndexMask;
        } else if (!this.mDirty) {
            this.copyArrays();
            this.mDirty = true;
        }
        ++this.mSize;
        if (this.mInternStrings) {
            string = string.intern();
        }
        if (this.mSymbols[n3] == null) {
            this.mSymbols[n3] = string;
        } else {
            int n5 = n3 >> 1;
            this.mBuckets[n5] = new Bucket(string, this.mBuckets[n5]);
        }
        return string;
    }

    public static int calcHash(char[] cArray, int n2, int n3) {
        int n4 = cArray[n2];
        for (int i2 = 1; i2 < n3; ++i2) {
            n4 = n4 * 31 + cArray[n2 + i2];
        }
        return n4;
    }

    public static int calcHash(String string) {
        int n2 = string.charAt(0);
        int n3 = string.length();
        for (int i2 = 1; i2 < n3; ++i2) {
            n2 = n2 * 31 + string.charAt(i2);
        }
        return n2;
    }

    private void copyArrays() {
        String[] stringArray = this.mSymbols;
        int n2 = stringArray.length;
        this.mSymbols = new String[n2];
        System.arraycopy(stringArray, 0, this.mSymbols, 0, n2);
        Bucket[] bucketArray = this.mBuckets;
        n2 = bucketArray.length;
        this.mBuckets = new Bucket[n2];
        System.arraycopy(bucketArray, 0, this.mBuckets, 0, n2);
    }

    private void rehash() {
        int n2;
        Object object;
        int n3;
        int n4 = this.mSymbols.length;
        int n5 = n4 + n4;
        String[] stringArray = this.mSymbols;
        Bucket[] bucketArray = this.mBuckets;
        this.mSymbols = new String[n5];
        this.mBuckets = new Bucket[n5 >> 1];
        this.mIndexMask = n5 - 1;
        this.mSizeThreshold += this.mSizeThreshold;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            object = stringArray[n3];
            if (object == null) continue;
            ++n6;
            int n7 = SymbolTable.calcHash((String)object) & this.mIndexMask;
            if (this.mSymbols[n7] == null) {
                this.mSymbols[n7] = object;
                continue;
            }
            n2 = n7 >> 1;
            this.mBuckets[n2] = new Bucket((String)object, this.mBuckets[n2]);
        }
        n4 >>= 1;
        for (n3 = 0; n3 < n4; ++n3) {
            for (object = bucketArray[n3]; object != null; object = ((Bucket)object).getNext()) {
                ++n6;
                String string = ((Bucket)object).getSymbol();
                n2 = SymbolTable.calcHash(string) & this.mIndexMask;
                if (this.mSymbols[n2] == null) {
                    this.mSymbols[n2] = string;
                    continue;
                }
                int n8 = n2 >> 1;
                this.mBuckets[n8] = new Bucket(string, this.mBuckets[n8]);
            }
        }
        if (n6 != this.mSize) {
            throw new IllegalStateException("Internal error on SymbolTable.rehash(): had " + this.mSize + " entries; now have " + n6 + ".");
        }
    }

    public double calcAvgSeek() {
        int n2;
        int n3 = 0;
        int n4 = this.mSymbols.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.mSymbols[n2] == null) continue;
            ++n3;
        }
        n4 = this.mBuckets.length;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = 2;
            for (Bucket bucket = this.mBuckets[n2]; bucket != null; bucket = bucket.getNext()) {
                n3 += n5;
                ++n5;
            }
        }
        return (double)n3 / (double)this.mSize;
    }

    static final class Bucket {
        private final String mSymbol;
        private final Bucket mNext;

        public Bucket(String string, Bucket bucket) {
            this.mSymbol = string;
            this.mNext = bucket;
        }

        public String getSymbol() {
            return this.mSymbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public String find(char[] cArray, int n2, int n3) {
            String string = this.mSymbol;
            Bucket bucket = this.mNext;
            while (true) {
                if (string.length() == n3) {
                    int n4 = 0;
                    while (string.charAt(n4) == cArray[n2 + n4] && ++n4 < n3) {
                    }
                    if (n4 == n3) {
                        return string;
                    }
                }
                if (bucket == null) break;
                string = bucket.getSymbol();
                bucket = bucket.getNext();
            }
            return null;
        }

        public String find(String string) {
            String string2 = this.mSymbol;
            Bucket bucket = this.mNext;
            while (true) {
                if (string2.equals(string)) {
                    return string2;
                }
                if (bucket == null) break;
                string2 = bucket.getSymbol();
                bucket = bucket.getNext();
            }
            return null;
        }
    }
}

