/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.AttributeCollector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputElementStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.BaseNsStreamWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.SimpleOutputElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class SimpleNsStreamWriter
extends BaseNsStreamWriter {
    public SimpleNsStreamWriter(XmlWriter xmlWriter, String string, WriterConfig writerConfig) {
        super(xmlWriter, string, writerConfig, false);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            SimpleNsStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        String string4 = this.mCurrElem.getExplicitPrefix(string);
        if (!this.mReturnNullForDefaultNamespace && string4 == null) {
            SimpleNsStreamWriter.throwOutputError("Unbound namespace URI '" + string + "'");
        }
        this.doWriteAttr(string2, string, string4, string3);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            SimpleNsStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this.doWriteAttr(string3, string2, string, string4);
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            SimpleNsStreamWriter.throwOutputError("Trying to write a namespace declaration when there is no open start element.");
        }
        this.setDefaultNamespace(string);
        this.doWriteDefaultNs(string);
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (string == null || string.length() == 0 || string.equals("xmlns")) {
            this.writeDefaultNamespace(string2);
            return;
        }
        if (!this.mStartElementOpen) {
            SimpleNsStreamWriter.throwOutputError("Trying to write a namespace declaration when there is no open start element.");
        }
        if (!this.mXml11 && string2.length() == 0) {
            SimpleNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this.setPrefix(string, string2);
        this.doWriteNamespace(string, string2);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.mCurrElem.setDefaultNsUri(string);
    }

    @Override
    public void doSetPrefix(String string, String string2) throws XMLStreamException {
        this.mCurrElem.addPrefix(string, string2);
    }

    @Override
    public void writeStartElement(StartElement startElement) throws XMLStreamException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        QName qName = startElement.getName();
        Iterator<Namespace> iterator = startElement.getNamespaces();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            object3 = object4.getPrefix();
            if (object3 == null || ((String)object3).length() == 0) {
                this.setDefaultNamespace(object4.getNamespaceURI());
                continue;
            }
            this.setPrefix((String)object3, object4.getNamespaceURI());
        }
        object4 = qName.getNamespaceURI();
        if (object4 == null) {
            this.writeStartElement(qName.getLocalPart());
        } else {
            object3 = qName.getPrefix();
            this.writeStartElement((String)object3, qName.getLocalPart(), (String)object4);
        }
        object3 = startElement.getNamespaces();
        while (object3.hasNext()) {
            object2 = (Namespace)object3.next();
            object = object2.getPrefix();
            if (object == null || ((String)object).length() == 0) {
                this.writeDefaultNamespace(object2.getNamespaceURI());
                continue;
            }
            this.writeNamespace((String)object, object2.getNamespaceURI());
        }
        object2 = startElement.getAttributes();
        while (object2.hasNext()) {
            object = (Attribute)object2.next();
            qName = object.getName();
            object4 = qName.getNamespaceURI();
            if (object4 != null && ((String)object4).length() > 0) {
                this.writeAttribute(qName.getPrefix(), (String)object4, qName.getLocalPart(), object.getValue());
                continue;
            }
            this.writeAttribute(qName.getLocalPart(), object.getValue());
        }
    }

    @Override
    protected void writeStartOrEmpty(String string, String string2) throws XMLStreamException {
        String string3 = this.mCurrElem.getPrefix(string2);
        if (string3 == null) {
            throw new XMLStreamException("Unbound namespace URI '" + string2 + "'");
        }
        this.checkStartElement(string, string3);
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(string, string2, string3);
        }
        if (this.mOutputElemPool != null) {
            SimpleOutputElement simpleOutputElement = this.mOutputElemPool;
            this.mOutputElemPool = simpleOutputElement.reuseAsChild(this.mCurrElem, string3, string, string2);
            --this.mPoolSize;
            this.mCurrElem = simpleOutputElement;
        } else {
            this.mCurrElem = this.mCurrElem.createChild(string3, string, string2);
        }
        this.doWriteStartTag(string3, string);
    }

    @Override
    protected void writeStartOrEmpty(String string, String string2, String string3) throws XMLStreamException {
        this.checkStartElement(string2, string);
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(string2, string3, string);
        }
        if (this.mOutputElemPool != null) {
            SimpleOutputElement simpleOutputElement = this.mOutputElemPool;
            this.mOutputElemPool = simpleOutputElement.reuseAsChild(this.mCurrElem, string, string2, string3);
            --this.mPoolSize;
            this.mCurrElem = simpleOutputElement;
        } else {
            this.mCurrElem = this.mCurrElem.createChild(string, string2, string3);
        }
        this.doWriteStartTag(string, string2);
    }

    @Override
    public final void copyStartElement(InputElementStack inputElementStack, AttributeCollector attributeCollector) throws IOException, XMLStreamException {
        String string;
        String string2;
        int n2;
        int n3 = inputElementStack.getCurrentNsCount();
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                string2 = inputElementStack.getLocalNsPrefix(n2);
                string = inputElementStack.getLocalNsURI(n2);
                if (string2 == null || string2.length() == 0) {
                    this.setDefaultNamespace(string);
                    continue;
                }
                this.setPrefix(string2, string);
            }
        }
        this.writeStartElement(inputElementStack.getPrefix(), inputElementStack.getLocalName(), inputElementStack.getNsURI());
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                string2 = inputElementStack.getLocalNsPrefix(n2);
                string = inputElementStack.getLocalNsURI(n2);
                if (string2 == null || string2.length() == 0) {
                    this.writeDefaultNamespace(string);
                    continue;
                }
                this.writeNamespace(string2, string);
            }
        }
        int n4 = n2 = this.mCfgCopyDefaultAttrs ? attributeCollector.getCount() : attributeCollector.getSpecifiedCount();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                attributeCollector.writeAttribute(i2, this.mWriter, this.mValidator);
            }
        }
    }

    @Override
    public String validateQNamePrefix(QName qName) {
        return qName.getPrefix();
    }
}

