/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.BinaryExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.UnaryExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StringPair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class ExpressionPool
implements Serializable {
    private final ClosedHash expTable;
    private static final long serialVersionUID = 1L;

    public final Expression createAttribute(NameClass nameClass) {
        return this.unify(new AttributeExp(nameClass, Expression.anyString));
    }

    public final Expression createAttribute(NameClass nameClass, Expression expression, String string) {
        if (expression == Expression.nullSet) {
            return expression;
        }
        AttributeExp attributeExp = new AttributeExp(nameClass, expression);
        attributeExp.setDefaultValue(string);
        return this.unify(attributeExp);
    }

    public final Expression createEpsilon() {
        return Expression.epsilon;
    }

    public final Expression createNullSet() {
        return Expression.nullSet;
    }

    public final Expression createAnyString() {
        return Expression.anyString;
    }

    public final Expression createChoice(Expression expression, Expression expression2) {
        Expression expression3;
        if (expression == Expression.nullSet) {
            return expression2;
        }
        if (expression2 == Expression.nullSet) {
            return expression;
        }
        if (expression == Expression.epsilon && expression2.isEpsilonReducible()) {
            return expression2;
        }
        if (expression2 == Expression.epsilon && expression.isEpsilonReducible()) {
            return expression;
        }
        if (expression2 instanceof ChoiceExp) {
            ChoiceExp choiceExp = (ChoiceExp)expression2;
            return this.createChoice(this.createChoice(expression, choiceExp.exp1), choiceExp.exp2);
        }
        Expression expression4 = expression;
        while (true) {
            if (expression4 == expression2) {
                return expression;
            }
            if (!(expression4 instanceof ChoiceExp)) break;
            expression3 = (ChoiceExp)expression4;
            if (expression3.exp2 == expression2) {
                return expression;
            }
            expression4 = expression3.exp1;
        }
        expression3 = this.expTable.getBinExp(expression, expression2, ChoiceExp.class);
        if (expression3 == null) {
            return this.unify(new ChoiceExp(expression, expression2));
        }
        return expression3;
    }

    public final Expression createOneOrMore(Expression expression) {
        if (expression == Expression.epsilon || expression == Expression.anyString || expression == Expression.nullSet || expression instanceof OneOrMoreExp) {
            return expression;
        }
        return this.unify(new OneOrMoreExp(expression));
    }

    public final Expression createZeroOrMore(Expression expression) {
        return this.createOptional(this.createOneOrMore(expression));
    }

    public final Expression createOptional(Expression expression) {
        return this.createChoice(expression, Expression.epsilon);
    }

    public final Expression createData(XSDatatype xSDatatype) {
        String string = xSDatatype.getNamespaceUri();
        if (string == null) {
            string = "\u0000";
        }
        return this.createData(xSDatatype, new StringPair(string, xSDatatype.displayName()));
    }

    public final Expression createData(Datatype datatype, StringPair stringPair) {
        return this.createData(datatype, stringPair, Expression.nullSet);
    }

    public final Expression createData(Datatype datatype, StringPair stringPair, Expression expression) {
        return this.unify(new DataExp(datatype, stringPair, expression));
    }

    public final Expression createValue(XSDatatype xSDatatype, Object object) {
        return this.createValue(xSDatatype, new StringPair("", xSDatatype.displayName()), object);
    }

    public final Expression createValue(Datatype datatype, StringPair stringPair, Object object) {
        return this.unify(new ValueExp(datatype, stringPair, object));
    }

    public final Expression createList(Expression expression) {
        if (expression == Expression.nullSet) {
            return expression;
        }
        return this.unify(new ListExp(expression));
    }

    public final Expression createMixed(Expression expression) {
        if (expression == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (expression == Expression.epsilon) {
            return Expression.anyString;
        }
        return this.unify(new MixedExp(expression));
    }

    public final Expression createSequence(Expression expression, Expression expression2) {
        if (expression == Expression.nullSet || expression2 == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (expression == Expression.epsilon) {
            return expression2;
        }
        if (expression2 == Expression.epsilon) {
            return expression;
        }
        if (expression2 instanceof SequenceExp) {
            SequenceExp sequenceExp = (SequenceExp)expression2;
            return this.createSequence(this.createSequence(expression, sequenceExp.exp1), sequenceExp.exp2);
        }
        Expression expression3 = this.expTable.getBinExp(expression, expression2, SequenceExp.class);
        if (expression3 == null) {
            return this.unify(new SequenceExp(expression, expression2));
        }
        return expression3;
    }

    public final Expression createConcur(Expression expression, Expression expression2) {
        if (expression == Expression.nullSet || expression2 == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (expression == Expression.epsilon) {
            if (expression2.isEpsilonReducible()) {
                return Expression.epsilon;
            }
            return Expression.nullSet;
        }
        if (expression2 == Expression.epsilon) {
            if (expression.isEpsilonReducible()) {
                return Expression.epsilon;
            }
            return Expression.nullSet;
        }
        if (expression2 instanceof ConcurExp) {
            ConcurExp concurExp = (ConcurExp)expression2;
            return this.createConcur(this.createConcur(expression, concurExp.exp1), concurExp.exp2);
        }
        return this.unify(new ConcurExp(expression, expression2));
    }

    public final Expression createInterleave(Expression expression, Expression expression2) {
        if (expression == Expression.epsilon) {
            return expression2;
        }
        if (expression2 == Expression.epsilon) {
            return expression;
        }
        if (expression == Expression.nullSet || expression2 == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (expression2 instanceof InterleaveExp) {
            InterleaveExp interleaveExp = (InterleaveExp)expression2;
            return this.createInterleave(this.createInterleave(expression, interleaveExp.exp1), interleaveExp.exp2);
        }
        return this.unify(new InterleaveExp(expression, expression2));
    }

    public ExpressionPool(ExpressionPool expressionPool) {
        this.expTable = new ClosedHash(expressionPool.expTable);
    }

    public ExpressionPool() {
        this.expTable = new ClosedHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Expression unify(Expression expression) {
        Expression expression2 = this.expTable.get(expression);
        if (expression2 == null) {
            ClosedHash closedHash = this.expTable;
            synchronized (closedHash) {
                expression2 = this.expTable.get(expression);
                if (expression2 == null) {
                    this.expTable.put(expression);
                    return expression;
                }
            }
        }
        return expression2;
    }

    public static final class ClosedHash
    implements Serializable {
        private Expression[] table = new Expression[191];
        private int count;
        private int threshold = 57;
        private static final float loadFactor = 0.3f;
        private static final int initialCapacity = 191;
        private ClosedHash parent;
        private static final long serialVersionUID = -2924295970572669668L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("count", Integer.TYPE), new ObjectStreamField("streamVersion", Byte.TYPE), new ObjectStreamField("parent", ExpressionPool.class)};

        public ClosedHash() {
            this(null);
        }

        public ClosedHash(ClosedHash closedHash) {
            this.parent = closedHash;
        }

        public Expression getBinExp(Expression expression, Expression expression2, Class<?> clazz) {
            int n2 = expression.hashCode() + expression2.hashCode() ^ clazz.hashCode();
            return this.getBinExp(n2, expression, expression2, clazz);
        }

        private Expression getBinExp(int n2, Expression expression, Expression expression2, Class<?> clazz) {
            Object object;
            if (this.parent != null && (object = this.parent.getBinExp(n2, expression, expression2, clazz)) != null) {
                return object;
            }
            object = this.table;
            int n3 = (n2 & Integer.MAX_VALUE) % ((Expression[])object).length;
            Expression expression3;
            while ((expression3 = object[n3]) != null) {
                if (expression3.hashCode() == n2 && expression3.getClass() == clazz) {
                    BinaryExp binaryExp = (BinaryExp)expression3;
                    if (binaryExp.exp1 == expression && binaryExp.exp2 == expression2) {
                        return binaryExp;
                    }
                }
                n3 = (n3 + 1) % ((Expression[])object).length;
            }
            return null;
        }

        public Expression get(int n2, Expression expression, Class<?> clazz) {
            Object object;
            if (this.parent != null && (object = this.parent.get(n2, expression, clazz)) != null) {
                return object;
            }
            object = this.table;
            int n3 = (n2 & Integer.MAX_VALUE) % ((Expression[])object).length;
            Expression expression2;
            while ((expression2 = object[n3]) != null) {
                if (expression2.hashCode() == n2 && expression2.getClass() == clazz) {
                    UnaryExp unaryExp = (UnaryExp)expression2;
                    if (unaryExp.exp == expression) {
                        return unaryExp;
                    }
                }
                n3 = (n3 + 1) % ((Expression[])object).length;
            }
            return null;
        }

        public Expression get(Expression expression) {
            Object object;
            if (this.parent != null && (object = this.parent.get(expression)) != null) {
                return object;
            }
            object = this.table;
            int n2 = (expression.hashCode() & Integer.MAX_VALUE) % ((Expression[])object).length;
            Expression expression2;
            while ((expression2 = object[n2]) != null) {
                if (expression2.equals(expression)) {
                    return expression2;
                }
                n2 = (n2 + 1) % ((Expression[])object).length;
            }
            return null;
        }

        private void rehash() {
            int n2 = this.table.length;
            Expression[] expressionArray = this.table;
            int n3 = n2 * 2 + 1;
            Expression[] expressionArray2 = new Expression[n3];
            int n4 = n2;
            while (n4-- > 0) {
                if (expressionArray[n4] == null) continue;
                int n5 = (expressionArray[n4].hashCode() & Integer.MAX_VALUE) % expressionArray2.length;
                while (expressionArray2[n5] != null) {
                    n5 = (n5 + 1) % expressionArray2.length;
                }
                expressionArray2[n5] = expressionArray[n4];
            }
            this.threshold = (int)((float)n3 * 0.3f);
            this.table = expressionArray2;
        }

        public void put(Expression expression) {
            if (this.count >= this.threshold) {
                this.rehash();
            }
            Expression[] expressionArray = this.table;
            int n2 = (expression.hashCode() & Integer.MAX_VALUE) % expressionArray.length;
            while (expressionArray[n2] != null) {
                n2 = (n2 + 1) % expressionArray.length;
            }
            expressionArray[n2] = expression;
            ++this.count;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("count", this.count);
            putField.put("parent", this.parent);
            putField.put("streamVersion", (byte)1);
            objectOutputStream.writeFields();
            for (int i2 = 0; i2 < this.table.length; ++i2) {
                if (this.table[i2] == null) continue;
                objectOutputStream.writeObject(this.table[i2]);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            byte by2 = getField.get("streamVersion", (byte)0);
            if (by2 == 0) {
                this.count = getField.get("count", 0);
                this.parent = (ClosedHash)getField.get("parent", null);
                this.table = (Expression[])getField.get("table", null);
                this.threshold = getField.get("threshold", 0);
            } else {
                int n2 = getField.get("count", 0);
                this.parent = (ClosedHash)getField.get("parent", null);
                int n3 = (int)((float)n2 / 0.3f) * 2 + 10;
                this.threshold = this.count * 2;
                this.count = 0;
                this.table = new Expression[n3];
                for (int i2 = 0; i2 < this.count; ++i2) {
                    this.put((Expression)objectInputStream.readObject());
                }
            }
        }
    }
}

