/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

abstract class BaseReader
extends Reader {
    protected static final char NULL_CHAR = '\u0000';
    protected static final char NULL_BYTE = '\u0000';
    protected static final char CONVERT_NEL_TO = '\n';
    protected static final char CONVERT_LSEP_TO = '\n';
    static final char CHAR_DEL = '\u007f';
    protected final ReaderConfig mConfig;
    private InputStream mIn;
    protected byte[] mByteBuffer;
    protected int mBytePtr;
    protected int mByteBufferEnd;
    private final boolean mRecycleBuffer;
    protected char[] mTmpBuf = null;

    protected BaseReader(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl2) {
        this.mConfig = readerConfig;
        this.mIn = inputStream;
        this.mByteBuffer = byArray;
        this.mBytePtr = n2;
        this.mByteBufferEnd = n3;
        this.mRecycleBuffer = bl2;
    }

    public abstract void setXmlCompliancy(int var1);

    protected final boolean canModifyBuffer() {
        return this.mRecycleBuffer;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.mIn;
        if (inputStream != null) {
            this.mIn = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mTmpBuf == null) {
            this.mTmpBuf = new char[1];
        }
        if (this.read(this.mTmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this.mTmpBuf[0];
    }

    protected final InputStream getStream() {
        return this.mIn;
    }

    protected final int readBytes() throws IOException {
        this.mBytePtr = 0;
        this.mByteBufferEnd = 0;
        if (this.mIn != null) {
            int n2 = this.mIn.read(this.mByteBuffer, 0, this.mByteBuffer.length);
            if (n2 > 0) {
                this.mByteBufferEnd = n2;
            }
            return n2;
        }
        return -1;
    }

    protected final int readBytesAt(int n2) throws IOException {
        if (this.mIn != null) {
            int n3 = this.mIn.read(this.mByteBuffer, n2, this.mByteBuffer.length - n2);
            if (n3 > 0) {
                this.mByteBufferEnd += n3;
            }
            return n3;
        }
        return -1;
    }

    public final void freeBuffers() {
        byte[] byArray;
        if (this.mRecycleBuffer && (byArray = this.mByteBuffer) != null) {
            this.mByteBuffer = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(byArray);
            }
        }
    }

    protected void reportBounds(char[] cArray, int n2, int n3) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n2 + "," + n3 + "), cbuf[" + cArray.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }

    protected void reportInvalidXml11(int n2, int n3, int n4) throws IOException {
        throw new CharConversionException("Invalid character 0x" + Integer.toHexString(n2) + ", can only be included in xml 1.1 using character entities (at char #" + n4 + ", byte #" + n3 + ")");
    }
}

