/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ConcatModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ContentSpec;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ModelNode;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.OptionalModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StarModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StructValidator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.TokenContentSpec;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import java.util.Collection;

public class SeqContentSpec
extends ContentSpec {
    final boolean mNsAware;
    final ContentSpec[] mContentSpecs;

    public SeqContentSpec(boolean bl2, char c2, ContentSpec[] contentSpecArray) {
        super(c2);
        this.mNsAware = bl2;
        this.mContentSpecs = contentSpecArray;
    }

    public static SeqContentSpec construct(boolean bl2, char c2, Collection<ContentSpec> collection) {
        ContentSpec[] contentSpecArray = new ContentSpec[collection.size()];
        collection.toArray(contentSpecArray);
        return new SeqContentSpec(bl2, c2, contentSpecArray);
    }

    @Override
    public StructValidator getSimpleValidator() {
        int n2;
        ContentSpec[] contentSpecArray = this.mContentSpecs;
        int n3 = contentSpecArray.length;
        for (n2 = 0; n2 < n3 && contentSpecArray[n2].isLeaf(); ++n2) {
        }
        if (n2 == n3) {
            PrefixedName[] prefixedNameArray = new PrefixedName[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                TokenContentSpec tokenContentSpec = (TokenContentSpec)contentSpecArray[n2];
                prefixedNameArray[n2] = tokenContentSpec.getName();
            }
            return new Validator(this.mArity, prefixedNameArray);
        }
        return null;
    }

    @Override
    public ModelNode rewrite() {
        ModelNode modelNode = this.rewrite(this.mContentSpecs, 0, this.mContentSpecs.length);
        if (this.mArity == '*') {
            return new StarModel(modelNode);
        }
        if (this.mArity == '?') {
            return new OptionalModel(modelNode);
        }
        if (this.mArity == '+') {
            return new ConcatModel(modelNode, new StarModel(modelNode.cloneModel()));
        }
        return modelNode;
    }

    private ModelNode rewrite(ContentSpec[] contentSpecArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 > 3) {
            int n5 = n3 + n2 + 1 >> 1;
            return new ConcatModel(this.rewrite(contentSpecArray, n2, n5), this.rewrite(contentSpecArray, n5, n3));
        }
        ConcatModel concatModel = new ConcatModel(contentSpecArray[n2].rewrite(), contentSpecArray[n2 + 1].rewrite());
        if (n4 == 3) {
            concatModel = new ConcatModel(concatModel, contentSpecArray[n2 + 2].rewrite());
        }
        return concatModel;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i2 = 0; i2 < this.mContentSpecs.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.mContentSpecs[i2].toString());
        }
        stringBuilder.append(')');
        if (this.mArity != ' ') {
            stringBuilder.append(this.mArity);
        }
        return stringBuilder.toString();
    }

    static final class Validator
    extends StructValidator {
        final char mArity;
        final PrefixedName[] mNames;
        int mRounds = 0;
        int mStep = 0;

        public Validator(char c2, PrefixedName[] prefixedNameArray) {
            this.mArity = c2;
            this.mNames = prefixedNameArray;
        }

        @Override
        public StructValidator newInstance() {
            return new Validator(this.mArity, this.mNames);
        }

        @Override
        public String tryToValidate(PrefixedName prefixedName) {
            if (this.mStep == 0 && this.mRounds == 1 && (this.mArity == '?' || this.mArity == ' ')) {
                return "was not expecting any more elements in the sequence (" + Validator.concatNames(this.mNames) + ")";
            }
            PrefixedName prefixedName2 = this.mNames[this.mStep];
            if (!prefixedName.equals(prefixedName2)) {
                return this.expElem(this.mStep);
            }
            if (++this.mStep == this.mNames.length) {
                ++this.mRounds;
                this.mStep = 0;
            }
            return null;
        }

        @Override
        public String fullyValid() {
            if (this.mStep != 0) {
                return this.expElem(this.mStep) + "; got end element";
            }
            switch (this.mArity) {
                case '*': 
                case '?': {
                    return null;
                }
                case ' ': 
                case '+': {
                    if (this.mRounds > 0) {
                        return null;
                    }
                    return "Expected sequence (" + Validator.concatNames(this.mNames) + "); got end element";
                }
            }
            throw new IllegalStateException("Internal error");
        }

        private String expElem(int n2) {
            return "expected element <" + this.mNames[n2] + "> in sequence (" + Validator.concatNames(this.mNames) + ")";
        }

        static final String concatNames(PrefixedName[] prefixedNameArray) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = prefixedNameArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(prefixedNameArray[i2].toString());
            }
            return stringBuilder.toString();
        }
    }
}

