/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.driver.windows.registry;

import com.gradle.scan.plugin.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstalledAppsData {
    private static final Logger LOG = LoggerFactory.getLogger(InstalledAppsData.class);
    private static final Map<WinReg.HKEY, List<String>> REGISTRY_PATHS = new HashMap<WinReg.HKEY, List<String>>();
    private static final int[] ACCESS_FLAGS = new int[]{256, 512};

    private InstalledAppsData() {
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        LinkedHashSet<ApplicationInfo> linkedHashSet = new LinkedHashSet<ApplicationInfo>();
        for (Map.Entry<WinReg.HKEY, List<String>> entry : REGISTRY_PATHS.entrySet()) {
            WinReg.HKEY hKEY = entry.getKey();
            List<String> list = entry.getValue();
            for (String string : list) {
                for (int n2 : ACCESS_FLAGS) {
                    String[] stringArray;
                    for (String string2 : stringArray = Advapi32Util.registryGetKeys(hKEY, string, n2)) {
                        String string3 = string + "\\" + string2;
                        try {
                            String string4 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "DisplayName", n2);
                            if (string4 == null) continue;
                            String string5 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "DisplayVersion", n2);
                            String string6 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "Publisher", n2);
                            String string7 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "InstallDate", n2);
                            String string8 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "InstallLocation", n2);
                            String string9 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "InstallSource", n2);
                            long l2 = ParseUtil.parseDateToEpoch(string7, "yyyyMMdd");
                            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                            linkedHashMap.put("installLocation", string8);
                            linkedHashMap.put("installSource", string9);
                            ApplicationInfo applicationInfo = new ApplicationInfo(string4, string5, string6, l2, linkedHashMap);
                            linkedHashSet.add(applicationInfo);
                        }
                        catch (Win32Exception win32Exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return new ArrayList<ApplicationInfo>(linkedHashSet);
    }

    private static String getRegistryValueOrUnknown(WinReg.HKEY hKEY, String string, String string2, int n2) {
        try {
            String string3 = Advapi32Util.registryGetStringValue(hKEY, string, string2, n2);
            if (string3 != null && !string3.trim().isEmpty()) {
                return string3;
            }
        }
        catch (Win32Exception win32Exception) {
            LOG.trace("Unable to access " + string + " with flag " + n2 + ": " + win32Exception.getMessage());
        }
        return null;
    }

    static {
        REGISTRY_PATHS.put(WinReg.HKEY_LOCAL_MACHINE, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
        REGISTRY_PATHS.put(WinReg.HKEY_CURRENT_USER, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
    }
}

