/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.internal;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.InternalThreadLocalMap;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class StringUtil {
    public static final String NEWLINE = SystemPropertyUtil.get("line.separator", "\n");
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final byte[] HEX2B;

    private StringUtil() {
    }

    public static String byteToHexStringPadded(int n2) {
        return BYTE2HEX_PAD[n2 & 0xFF];
    }

    public static int decodeHexNibble(char c2) {
        return HEX2B[c2];
    }

    public static int decodeHexNibble(byte by2) {
        return HEX2B[by2];
    }

    public static byte decodeHexByte(CharSequence charSequence, int n2) {
        int n3 = StringUtil.decodeHexNibble(charSequence.charAt(n2));
        int n4 = StringUtil.decodeHexNibble(charSequence.charAt(n2 + 1));
        if (n3 == -1 || n4 == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", charSequence.subSequence(n2, n2 + 2), n2, charSequence));
        }
        return (byte)((n3 << 4) + n4);
    }

    public static String simpleClassName(Object object) {
        if (object == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(object.getClass());
    }

    public static String simpleClassName(Class<?> clazz) {
        String string = ObjectUtil.checkNotNull(clazz, "clazz").getName();
        int n2 = string.lastIndexOf(46);
        if (n2 > -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public static CharSequence escapeCsv(CharSequence charSequence, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5 = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (bl2) {
            n4 = StringUtil.indexOfFirstNonOwsChar(charSequence, n5);
            n3 = StringUtil.indexOfLastNonOwsChar(charSequence, n4, n5);
        } else {
            n4 = 0;
            n3 = n5 - 1;
        }
        if (n4 > n3) {
            return "";
        }
        int n6 = -1;
        boolean bl3 = false;
        if (StringUtil.isDoubleQuote(charSequence.charAt(n4))) {
            boolean bl4 = bl3 = StringUtil.isDoubleQuote(charSequence.charAt(n3)) && n3 > n4;
            if (bl3) {
                ++n4;
                --n3;
            } else {
                n6 = n4;
            }
        }
        if (n6 < 0) {
            int n7;
            if (bl3) {
                for (n7 = n4; n7 <= n3; ++n7) {
                    if (!StringUtil.isDoubleQuote(charSequence.charAt(n7))) continue;
                    if (n7 == n3 || !StringUtil.isDoubleQuote(charSequence.charAt(n7 + 1))) {
                        n6 = n7;
                        break;
                    }
                    ++n7;
                }
            } else {
                for (n7 = n4; n7 <= n3; ++n7) {
                    n2 = charSequence.charAt(n7);
                    if (n2 == 10 || n2 == 13 || n2 == 44) {
                        n6 = n7;
                        break;
                    }
                    if (!StringUtil.isDoubleQuote((char)n2)) continue;
                    if (n7 == n3 || !StringUtil.isDoubleQuote(charSequence.charAt(n7 + 1))) {
                        n6 = n7;
                        break;
                    }
                    ++n7;
                }
            }
            if (n6 < 0) {
                return bl3 ? charSequence.subSequence(n4 - 1, n3 + 2) : charSequence.subSequence(n4, n3 + 1);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n4 + 1 + 7);
        stringBuilder.append('\"').append(charSequence, n4, n6);
        for (n2 = n6; n2 <= n3; ++n2) {
            char c2 = charSequence.charAt(n2);
            if (StringUtil.isDoubleQuote(c2)) {
                stringBuilder.append('\"');
                if (n2 < n3 && StringUtil.isDoubleQuote(charSequence.charAt(n2 + 1))) {
                    ++n2;
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.append('\"');
    }

    public static List<CharSequence> unescapeCsvFields(CharSequence charSequence) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(2);
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        boolean bl2 = false;
        int n2 = charSequence.length() - 1;
        block8: for (int i2 = 0; i2 <= n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (bl2) {
                switch (c2) {
                    case '\"': {
                        char c3;
                        if (i2 == n2) {
                            arrayList.add(stringBuilder.toString());
                            return arrayList;
                        }
                        if ((c3 = charSequence.charAt(++i2)) == '\"') {
                            stringBuilder.append('\"');
                            break;
                        }
                        if (c3 == ',') {
                            bl2 = false;
                            arrayList.add(stringBuilder.toString());
                            stringBuilder.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2 - 1);
                    }
                    default: {
                        stringBuilder.append(c2);
                        break;
                    }
                }
                continue;
            }
            switch (c2) {
                case ',': {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue block8;
                }
                case '\"': {
                    if (stringBuilder.length() == 0) {
                        bl2 = true;
                        continue block8;
                    }
                }
                case '\n': 
                case '\r': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2);
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        if (bl2) {
            throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, n2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence charSequence, int n2) {
        return new IllegalArgumentException("invalid escaped CSV field: " + charSequence + " index: " + n2);
    }

    public static boolean isSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udfff';
    }

    private static boolean isDoubleQuote(char c2) {
        return c2 == '\"';
    }

    public static CharSequence trimOws(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return charSequence;
        }
        int n3 = StringUtil.indexOfFirstNonOwsChar(charSequence, n2);
        int n4 = StringUtil.indexOfLastNonOwsChar(charSequence, n3, n2);
        return n3 == 0 && n4 == n2 - 1 ? charSequence : charSequence.subSequence(n3, n4 + 1);
    }

    private static int indexOfFirstNonOwsChar(CharSequence charSequence, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 && StringUtil.isOws(charSequence.charAt(n3)); ++n3) {
        }
        return n3;
    }

    private static int indexOfLastNonOwsChar(CharSequence charSequence, int n2, int n3) {
        int n4;
        for (n4 = n3 - 1; n4 > n2 && StringUtil.isOws(charSequence.charAt(n4)); --n4) {
        }
        return n4;
    }

    private static boolean isOws(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    static {
        for (int i2 = 0; i2 < BYTE2HEX_PAD.length; ++i2) {
            String string = Integer.toHexString(i2);
            StringUtil.BYTE2HEX_PAD[i2] = i2 > 15 ? string : '0' + string;
            StringUtil.BYTE2HEX_NOPAD[i2] = string;
        }
        HEX2B = new byte[65536];
        Arrays.fill(HEX2B, (byte)-1);
        StringUtil.HEX2B[48] = 0;
        StringUtil.HEX2B[49] = 1;
        StringUtil.HEX2B[50] = 2;
        StringUtil.HEX2B[51] = 3;
        StringUtil.HEX2B[52] = 4;
        StringUtil.HEX2B[53] = 5;
        StringUtil.HEX2B[54] = 6;
        StringUtil.HEX2B[55] = 7;
        StringUtil.HEX2B[56] = 8;
        StringUtil.HEX2B[57] = 9;
        StringUtil.HEX2B[65] = 10;
        StringUtil.HEX2B[66] = 11;
        StringUtil.HEX2B[67] = 12;
        StringUtil.HEX2B[68] = 13;
        StringUtil.HEX2B[69] = 14;
        StringUtil.HEX2B[70] = 15;
        StringUtil.HEX2B[97] = 10;
        StringUtil.HEX2B[98] = 11;
        StringUtil.HEX2B[99] = 12;
        StringUtil.HEX2B[100] = 13;
        StringUtil.HEX2B[101] = 14;
        StringUtil.HEX2B[102] = 15;
    }
}

