/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.internal;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.CleanableDirectBuffer;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.Cleaner;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class DirectCleaner
implements Cleaner {
    DirectCleaner() {
    }

    @Override
    public CleanableDirectBuffer allocate(int n2) {
        return new CleanableDirectBufferImpl(PlatformDependent.allocateDirectNoCleaner(n2));
    }

    @Override
    public void freeDirectBuffer(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectNoCleaner(byteBuffer);
    }

    CleanableDirectBuffer reallocate(CleanableDirectBuffer cleanableDirectBuffer, int n2) {
        ByteBuffer byteBuffer = PlatformDependent.reallocateDirectNoCleaner(cleanableDirectBuffer.buffer(), n2);
        return new CleanableDirectBufferImpl(byteBuffer);
    }

    private static final class CleanableDirectBufferImpl
    implements CleanableDirectBuffer {
        private final ByteBuffer buffer;

        private CleanableDirectBufferImpl(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void clean() {
            PlatformDependent.freeDirectNoCleaner(this.buffer);
        }
    }
}

