/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.JdkAlpnSslUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.util.BouncyCastleUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

final class BouncyCastleAlpnSslUtils {
    private static final InternalLogger logger;
    private static final Method SET_APPLICATION_PROTOCOLS;
    private static final Method GET_APPLICATION_PROTOCOL;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL;
    private static final Method SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Class<?> BC_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method BC_APPLICATION_PROTOCOL_SELECTOR_SELECT;

    private BouncyCastleAlpnSslUtils() {
    }

    static String getApplicationProtocol(SSLEngine sSLEngine) {
        try {
            return (String)GET_APPLICATION_PROTOCOL.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static void setApplicationProtocols(SSLEngine sSLEngine, List<String> list) {
        String[] stringArray = list.toArray(EmptyArrays.EMPTY_STRINGS);
        try {
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            SET_APPLICATION_PROTOCOLS.invoke((Object)sSLParameters, new Object[]{stringArray});
            sSLEngine.setSSLParameters(sSLParameters);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        if (PlatformDependent.javaVersion() >= 9) {
            JdkAlpnSslUtils.setApplicationProtocols(sSLEngine, list);
        }
    }

    static String getHandshakeApplicationProtocol(SSLEngine sSLEngine) {
        try {
            return (String)GET_HANDSHAKE_APPLICATION_PROTOCOL.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static void setHandshakeApplicationProtocolSelector(SSLEngine sSLEngine, final BiFunction<SSLEngine, List<String>, String> biFunction) {
        try {
            Object object = Proxy.newProxyInstance(BouncyCastleAlpnSslUtils.class.getClassLoader(), new Class[]{BC_APPLICATION_PROTOCOL_SELECTOR}, new InvocationHandler(){

                @Override
                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    if (method.getName().equals("select")) {
                        try {
                            return biFunction.apply((SSLEngine)objectArray[0], (List)objectArray[1]);
                        }
                        catch (ClassCastException classCastException) {
                            throw new RuntimeException("BCApplicationProtocolSelector select method parameter of invalid type.", classCastException);
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Method '%s' not supported.", method.getName()));
                }
            });
            SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sSLEngine, object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(SSLEngine sSLEngine2) {
        try {
            Object object = GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sSLEngine2, new Object[0]);
            return (sSLEngine, list) -> {
                try {
                    return (String)BC_APPLICATION_PROTOCOL_SELECTOR_SELECT.invoke(object, sSLEngine, list);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Could not call getHandshakeApplicationProtocolSelector", exception);
                }
            };
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static {
        Method method;
        Method method2;
        Method method3;
        Class<?> clazz;
        Method method4;
        Method method5;
        Method method6;
        logger = InternalLoggerFactory.getInstance(BouncyCastleAlpnSslUtils.class);
        try {
            Class<?> clazz2;
            if (!BouncyCastleUtil.isBcTlsAvailable()) {
                throw new IllegalStateException(BouncyCastleUtil.unavailabilityCauseBcTls());
            }
            SSLContext sSLContext = SslUtils.getSSLContext(BouncyCastleUtil.getBcProviderJsse());
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            final Class<?> clazz3 = sSLEngine.getClass();
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            final Class<?> clazz4 = sSLParameters.getClass();
            method6 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz4.getMethod("setApplicationProtocols", String[].class);
                }
            });
            method6.invoke((Object)sSLParameters, new Object[]{EmptyArrays.EMPTY_STRINGS});
            method5 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("getApplicationProtocol", new Class[0]);
                }
            });
            method5.invoke((Object)sSLEngine, new Object[0]);
            method4 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("getHandshakeApplicationProtocol", new Class[0]);
                }
            });
            method4.invoke((Object)sSLEngine, new Object[0]);
            clazz = clazz2 = Class.forName("org.bouncycastle.jsse.BCApplicationProtocolSelector", true, clazz3.getClassLoader());
            method3 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz2.getMethod("select", Object.class, List.class);
                }
            });
            method2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("setBCHandshakeApplicationProtocolSelector", clazz2);
                }
            });
            method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz3.getMethod("getBCHandshakeApplicationProtocolSelector", new Class[0]);
                }
            });
            method.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (Throwable throwable) {
            logger.error("Unable to initialize BouncyCastleAlpnSslUtils.", throwable);
            method6 = null;
            method5 = null;
            method4 = null;
            method2 = null;
            method = null;
            method3 = null;
            clazz = null;
        }
        SET_APPLICATION_PROTOCOLS = method6;
        GET_APPLICATION_PROTOCOL = method5;
        GET_HANDSHAKE_APPLICATION_PROTOCOL = method4;
        SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = method2;
        GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = method;
        BC_APPLICATION_PROTOCOL_SELECTOR_SELECT = method3;
        BC_APPLICATION_PROTOCOL_SELECTOR = clazz;
    }
}

