/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.Crc32c;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.DecompressionException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;

public final class Snappy {
    private static final FastThreadLocal<short[]> HASH_TABLE = new FastThreadLocal();
    private static final boolean DEFAULT_REUSE_HASHTABLE = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.snappy.reuseHashTable", false);
    private final boolean reuseHashtable;
    private State state = State.READING_PREAMBLE;
    private byte tag;
    private int written;

    public Snappy() {
        this(DEFAULT_REUSE_HASHTABLE);
    }

    Snappy(boolean bl2) {
        this.reuseHashtable = bl2;
    }

    public void reset() {
        this.state = State.READING_PREAMBLE;
        this.tag = 0;
        this.written = 0;
    }

    public void decode(ByteBuf byteBuf, ByteBuf byteBuf2) {
        while (byteBuf.isReadable()) {
            block0 : switch (this.state) {
                case READING_PREAMBLE: {
                    int n2 = Snappy.readPreamble(byteBuf);
                    if (n2 == -1) {
                        return;
                    }
                    if (n2 == 0) {
                        return;
                    }
                    byteBuf2.ensureWritable(n2);
                    this.state = State.READING_TAG;
                }
                case READING_TAG: {
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    this.tag = byteBuf.readByte();
                    switch (this.tag & 3) {
                        case 0: {
                            this.state = State.READING_LITERAL;
                            break block0;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            this.state = State.READING_COPY;
                        }
                    }
                    break;
                }
                case READING_LITERAL: {
                    int n3 = Snappy.decodeLiteral(this.tag, byteBuf, byteBuf2);
                    if (n3 != -1) {
                        this.state = State.READING_TAG;
                        this.written += n3;
                        break;
                    }
                    return;
                }
                case READING_COPY: {
                    switch (this.tag & 3) {
                        case 1: {
                            int n4 = Snappy.decodeCopyWith1ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n4 != -1) {
                                this.state = State.READING_TAG;
                                this.written += n4;
                                break block0;
                            }
                            return;
                        }
                        case 2: {
                            int n4 = Snappy.decodeCopyWith2ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n4 != -1) {
                                this.state = State.READING_TAG;
                                this.written += n4;
                                break block0;
                            }
                            return;
                        }
                        case 3: {
                            int n4 = Snappy.decodeCopyWith4ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n4 != -1) {
                                this.state = State.READING_TAG;
                                this.written += n4;
                                break block0;
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private static int readPreamble(ByteBuf byteBuf) {
        int n2 = 0;
        int n3 = 0;
        while (byteBuf.isReadable()) {
            short s2 = byteBuf.readUnsignedByte();
            n2 |= (s2 & 0x7F) << n3++ * 7;
            if ((s2 & 0x80) == 0) {
                return n2;
            }
            if (n3 < 4) continue;
            throw new DecompressionException("Preamble is greater than 4 bytes");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPreamble(ByteBuf byteBuf) {
        if (this.state == State.READING_PREAMBLE) {
            int n2 = byteBuf.readerIndex();
            try {
                int n3 = Snappy.readPreamble(byteBuf);
                return n3;
            }
            finally {
                byteBuf.readerIndex(n2);
            }
        }
        return 0;
    }

    static int decodeLiteral(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        byteBuf.markReaderIndex();
        switch (by2 >> 2 & 0x3F) {
            case 60: {
                if (!byteBuf.isReadable()) {
                    return -1;
                }
                n2 = byteBuf.readUnsignedByte();
                break;
            }
            case 61: {
                if (byteBuf.readableBytes() < 2) {
                    return -1;
                }
                n2 = byteBuf.readUnsignedShortLE();
                break;
            }
            case 62: {
                if (byteBuf.readableBytes() < 3) {
                    return -1;
                }
                n2 = byteBuf.readUnsignedMediumLE();
                break;
            }
            case 63: {
                if (byteBuf.readableBytes() < 4) {
                    return -1;
                }
                n2 = byteBuf.readIntLE();
                break;
            }
            default: {
                n2 = by2 >> 2 & 0x3F;
            }
        }
        if (byteBuf.readableBytes() < ++n2) {
            byteBuf.resetReaderIndex();
            return -1;
        }
        byteBuf2.writeBytes(byteBuf, n2);
        return n2;
    }

    private static int decodeCopyWith1ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        if (!byteBuf.isReadable()) {
            return -1;
        }
        int n3 = byteBuf2.writerIndex();
        int n4 = 4 + ((by2 & 0x1C) >> 2);
        int n5 = (by2 & 0xE0) << 8 >> 5 | byteBuf.readUnsignedByte();
        Snappy.validateOffset(n5, n2);
        byteBuf2.markReaderIndex();
        if (n5 < n4) {
            for (int i2 = n4 / n5; i2 > 0; --i2) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n5);
            }
            if (n4 % n5 != 0) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n4 % n5);
            }
        } else {
            byteBuf2.readerIndex(n3 - n5);
            byteBuf2.readBytes(byteBuf2, n4);
        }
        byteBuf2.resetReaderIndex();
        return n4;
    }

    private static int decodeCopyWith2ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        if (byteBuf.readableBytes() < 2) {
            return -1;
        }
        int n3 = byteBuf2.writerIndex();
        int n4 = 1 + (by2 >> 2 & 0x3F);
        int n5 = byteBuf.readUnsignedShortLE();
        Snappy.validateOffset(n5, n2);
        byteBuf2.markReaderIndex();
        if (n5 < n4) {
            for (int i2 = n4 / n5; i2 > 0; --i2) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n5);
            }
            if (n4 % n5 != 0) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n4 % n5);
            }
        } else {
            byteBuf2.readerIndex(n3 - n5);
            byteBuf2.readBytes(byteBuf2, n4);
        }
        byteBuf2.resetReaderIndex();
        return n4;
    }

    private static int decodeCopyWith4ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        if (byteBuf.readableBytes() < 4) {
            return -1;
        }
        int n3 = byteBuf2.writerIndex();
        int n4 = 1 + (by2 >> 2 & 0x3F);
        int n5 = byteBuf.readIntLE();
        Snappy.validateOffset(n5, n2);
        byteBuf2.markReaderIndex();
        if (n5 < n4) {
            for (int i2 = n4 / n5; i2 > 0; --i2) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n5);
            }
            if (n4 % n5 != 0) {
                byteBuf2.readerIndex(n3 - n5);
                byteBuf2.readBytes(byteBuf2, n4 % n5);
            }
        } else {
            byteBuf2.readerIndex(n3 - n5);
            byteBuf2.readBytes(byteBuf2, n4);
        }
        byteBuf2.resetReaderIndex();
        return n4;
    }

    private static void validateOffset(int n2, int n3) {
        if (n2 == 0) {
            throw new DecompressionException("Offset is less than minimum permissible value");
        }
        if (n2 < 0) {
            throw new DecompressionException("Offset is greater than maximum value supported by this implementation");
        }
        if (n2 > n3) {
            throw new DecompressionException("Offset exceeds size of chunk");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calculateChecksum(ByteBuf byteBuf, int n2, int n3) {
        Crc32c crc32c = new Crc32c();
        try {
            crc32c.update(byteBuf, n2, n3);
            int n4 = Snappy.maskChecksum(crc32c.getValue());
            return n4;
        }
        finally {
            crc32c.reset();
        }
    }

    static void validateChecksum(int n2, ByteBuf byteBuf, int n3, int n4) {
        int n5 = Snappy.calculateChecksum(byteBuf, n3, n4);
        if (n5 != n2) {
            throw new DecompressionException("mismatching checksum: " + Integer.toHexString(n5) + " (expected: " + Integer.toHexString(n2) + ')');
        }
    }

    static int maskChecksum(long l2) {
        return (int)((l2 >> 15 | l2 << 17) + -1568478504L);
    }

    private static enum State {
        READING_PREAMBLE,
        READING_TAG,
        READING_LITERAL,
        READING_COPY;

    }
}

