/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.key;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeKeySerializer
extends JsonSerializer<ZonedDateTime> {
    public static final ZonedDateTimeKeySerializer INSTANCE = new ZonedDateTimeKeySerializer();

    private ZonedDateTimeKeySerializer() {
    }

    @Override
    public void serialize(ZonedDateTime zonedDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_WITH_ZONE_ID)) {
            jsonGenerator.writeFieldName(DateTimeFormatter.ISO_ZONED_DATE_TIME.format(zonedDateTime));
        } else if (ZonedDateTimeKeySerializer.useTimestamps(serializerProvider)) {
            if (ZonedDateTimeKeySerializer.useNanos(serializerProvider)) {
                jsonGenerator.writeFieldName(DecimalUtils.toBigDecimal(zonedDateTime.toEpochSecond(), zonedDateTime.getNano()).toString());
            } else {
                jsonGenerator.writeFieldName(String.valueOf(zonedDateTime.toInstant().toEpochMilli()));
            }
        } else {
            jsonGenerator.writeFieldName(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime));
        }
    }

    private static boolean useNanos(SerializerProvider serializerProvider) {
        return serializerProvider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    private static boolean useTimestamps(SerializerProvider serializerProvider) {
        return serializerProvider.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS);
    }
}

