/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.ClassKey;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    public PropertyName findRootName(Class<?> clazz, MapperConfig<?> mapperConfig) {
        AnnotatedClass annotatedClass;
        ClassKey classKey = new ClassKey(clazz);
        PropertyName propertyName = this._rootNames.get(classKey);
        if (propertyName != null) {
            return propertyName;
        }
        BeanDescription beanDescription = mapperConfig.introspectClassAnnotations(clazz);
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        propertyName = annotationIntrospector.findRootName(annotatedClass = beanDescription.getClassInfo());
        if (propertyName == null || !propertyName.hasSimpleName()) {
            propertyName = PropertyName.construct(clazz.getSimpleName());
        }
        this._rootNames.put(classKey, propertyName);
        return propertyName;
    }
}

