/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;

public class CollectionSerializer
extends AsArraySerializerBase<Collection<?>> {
    private final boolean _maybeEnumSet;

    public CollectionSerializer(JavaType javaType, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(Collection.class, javaType, bl2, typeSerializer, jsonSerializer);
        this._maybeEnumSet = javaType.isEnumType() || javaType.isJavaLangObject();
    }

    public CollectionSerializer(CollectionSerializer collectionSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl2) {
        super(collectionSerializer, beanProperty, typeSerializer, jsonSerializer, bl2);
        this._maybeEnumSet = collectionSerializer._maybeEnumSet;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new CollectionSerializer(this, this._property, typeSerializer, this._elementSerializer, this._unwrapSingle);
    }

    public CollectionSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl2) {
        return new CollectionSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl2);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Collection<?> collection) {
        return collection.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Collection<?> collection) {
        return collection.size() == 1;
    }

    @Override
    public final void serialize(Collection<?> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n2 = collection.size();
        if (n2 == 1 && (this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(collection, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(collection, n2);
        this.serializeContents(collection, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(Collection<?> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.assignCurrentValue(collection);
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(collection, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        Iterator<?> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
        TypeSerializer typeSerializer = this._maybeEnumSet && collection instanceof EnumSet ? null : this._valueTypeSerializer;
        int n2 = 0;
        try {
            do {
                Object obj;
                if ((obj = iterator.next()) == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                } else {
                    Class<?> clazz = obj.getClass();
                    JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
                    if (jsonSerializer == null) {
                        jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                        propertySerializerMap = this._dynamicSerializers;
                    }
                    if (typeSerializer == null) {
                        jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    } else {
                        jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
                    }
                }
                ++n2;
            } while (iterator.hasNext());
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, collection, n2);
        }
    }

    public void serializeContentsUsing(Collection<?> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException {
        Iterator<?> iterator = collection.iterator();
        if (iterator.hasNext()) {
            TypeSerializer typeSerializer = this._maybeEnumSet && collection instanceof EnumSet ? null : this._valueTypeSerializer;
            int n2 = 0;
            do {
                Object obj = iterator.next();
                try {
                    if (obj == null) {
                        serializerProvider.defaultSerializeNull(jsonGenerator);
                    } else if (typeSerializer == null) {
                        jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    } else {
                        jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
                    }
                    ++n2;
                }
                catch (Exception exception) {
                    this.wrapAndThrow(serializerProvider, (Throwable)exception, collection, n2);
                }
            } while (iterator.hasNext());
        }
    }
}

