/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util;

import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakHint;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakTracker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.Nullable;

public class ResourceLeakDetector<T> {
    private static final Level DEFAULT_LEVEL;
    private static final int TARGET_RECORDS;
    static final int SAMPLING_INTERVAL;
    private static final boolean TRACK_CLOSE;
    private static Level level;
    private static final InternalLogger logger;
    private final Set<DefaultResourceLeak<?>> allLeaks = ConcurrentHashMap.newKeySet();
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final Set<String> reportedLeaks = ConcurrentHashMap.newKeySet();
    private final String resourceType;
    private final int samplingInterval;
    private volatile LeakListener leakListener;
    private static final AtomicReference<String[]> excludedMethods;

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > Level.DISABLED.ordinal();
    }

    public static Level getLevel() {
        return level;
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> clazz, int n2, long l2) {
        this(clazz, n2);
    }

    public ResourceLeakDetector(Class<?> clazz, int n2) {
        this(StringUtil.simpleClassName(clazz), n2, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(String string, int n2, long l2) {
        this.resourceType = ObjectUtil.checkNotNull(string, "resourceType");
        this.samplingInterval = n2;
    }

    public ResourceLeakTracker<T> track(T t2) {
        return this.track0(t2, false);
    }

    public ResourceLeakTracker<T> trackForcibly(T t2) {
        return this.track0(t2, true);
    }

    private DefaultResourceLeak<T> track0(T t2, boolean bl2) {
        Level level = ResourceLeakDetector.level;
        if (bl2 || level == Level.PARANOID || level != Level.DISABLED && ThreadLocalRandom.current().nextInt(this.samplingInterval) == 0) {
            this.reportLeak();
            return new DefaultResourceLeak(t2, this.refQueue, this.allLeaks, this.getInitialHint(this.resourceType));
        }
        return null;
    }

    private void clearRefQueue() {
        DefaultResourceLeak defaultResourceLeak;
        while ((defaultResourceLeak = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            defaultResourceLeak.dispose();
        }
    }

    protected boolean needReport() {
        return logger.isErrorEnabled();
    }

    private void reportLeak() {
        DefaultResourceLeak defaultResourceLeak;
        if (!this.needReport()) {
            this.clearRefQueue();
            return;
        }
        while ((defaultResourceLeak = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            LeakListener leakListener;
            String string;
            if (!defaultResourceLeak.dispose() || !this.reportedLeaks.add(string = defaultResourceLeak.getReportAndClearRecords())) continue;
            if (string.isEmpty()) {
                this.reportUntracedLeak(this.resourceType);
            } else {
                this.reportTracedLeak(this.resourceType, string);
            }
            if ((leakListener = this.leakListener) == null) continue;
            leakListener.onLeak(this.resourceType, string);
        }
    }

    protected void reportTracedLeak(String string, String string2) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See https://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)string, (Object)string2);
    }

    protected void reportUntracedLeak(String string) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See https://netty.io/wiki/reference-counted-objects.html for more information.", string, "com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.level", Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    protected Object getInitialHint(String string) {
        return null;
    }

    public static void addExclusions(Class clazz, String ... stringArray) {
        String[] stringArray2;
        Method method;
        int n2;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        Object[] objectArray = clazz.getDeclaredMethods();
        int n3 = objectArray.length;
        for (n2 = 0; !(n2 >= n3 || hashSet.remove((method = objectArray[n2]).getName()) && hashSet.isEmpty()); ++n2) {
        }
        if (!hashSet.isEmpty()) {
            throw new IllegalArgumentException("Can't find '" + hashSet + "' in " + clazz.getName());
        }
        do {
            objectArray = excludedMethods.get();
            stringArray2 = (String[])Arrays.copyOf(objectArray, objectArray.length + 2 * stringArray.length);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray2[objectArray.length + n2 * 2] = clazz.getName();
                stringArray2[objectArray.length + n2 * 2 + 1] = stringArray[n2];
            }
        } while (!excludedMethods.compareAndSet((String[])objectArray, stringArray2));
    }

    static {
        boolean bl2;
        DEFAULT_LEVEL = Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("com.gradle.scan.plugin.internal.dep.io.netty.noResourceLeakDetection") != null) {
            bl2 = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)bl2);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)"com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.level", (Object)Level.DISABLED.name().toLowerCase());
        } else {
            bl2 = false;
        }
        Level level = bl2 ? Level.DISABLED : DEFAULT_LEVEL;
        String string = SystemPropertyUtil.get("com.gradle.scan.plugin.internal.dep.io.netty.leakDetectionLevel", level.name());
        string = SystemPropertyUtil.get("com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.level", string);
        Level level2 = Level.parseLevel(string);
        TARGET_RECORDS = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.targetRecords", 4);
        SAMPLING_INTERVAL = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.samplingInterval", 128);
        TRACK_CLOSE = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.trackClose", true);
        ResourceLeakDetector.level = level2;
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)"com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.level", (Object)level2.name().toLowerCase());
            logger.debug("-D{}: {}", (Object)"com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.targetRecords", (Object)TARGET_RECORDS);
        }
        excludedMethods = new AtomicReference<String[]>(EmptyArrays.EMPTY_STRINGS);
    }

    private static class TraceRecord
    extends Throwable {
        private static final TraceRecord BOTTOM = new TraceRecord(false){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        private final String hintString;
        private final TraceRecord next;
        private final int pos;

        TraceRecord(TraceRecord traceRecord, Object object) {
            this.hintString = object instanceof ResourceLeakHint ? ((ResourceLeakHint)object).toHintString() : object.toString();
            this.next = traceRecord;
            this.pos = traceRecord.pos + 1;
        }

        TraceRecord(TraceRecord traceRecord) {
            this.hintString = null;
            this.next = traceRecord;
            this.pos = traceRecord.pos + 1;
        }

        private TraceRecord(boolean bl2) {
            this.hintString = null;
            this.next = null;
            this.pos = bl2 ? -2 : -1;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(2048);
            if (this.hintString != null) {
                stringBuilder.append("\tHint: ").append(this.hintString).append(StringUtil.NEWLINE);
            }
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            block0: for (int i2 = 3; i2 < stackTraceElementArray.length; ++i2) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i2];
                String[] stringArray = (String[])excludedMethods.get();
                for (int i3 = 0; i3 < stringArray.length; i3 += 2) {
                    if (stringArray[i3].equals(stackTraceElement.getClassName()) && stringArray[i3 + 1].equals(stackTraceElement.getMethodName())) continue block0;
                }
                stringBuilder.append('\t');
                stringBuilder.append(stackTraceElement.toString());
                stringBuilder.append(StringUtil.NEWLINE);
            }
            return stringBuilder.toString();
        }
    }

    private static final class DefaultResourceLeak<T>
    extends WeakReference<Object>
    implements ResourceLeakTracker<T> {
        private static final AtomicReferenceFieldUpdater<DefaultResourceLeak<?>, TraceRecord> headUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultResourceLeak.class, TraceRecord.class, "head");
        private static final AtomicIntegerFieldUpdater<DefaultResourceLeak<?>> droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultResourceLeak.class, "droppedRecords");
        private volatile TraceRecord head;
        private volatile int droppedRecords;
        private final Set<DefaultResourceLeak<?>> allLeaks;
        private final int trackedHash;

        DefaultResourceLeak(Object object, ReferenceQueue<Object> referenceQueue, Set<DefaultResourceLeak<?>> set, Object object2) {
            super(object, referenceQueue);
            assert (object != null);
            this.allLeaks = set;
            this.trackedHash = System.identityHashCode(object);
            set.add(this);
            headUpdater.set(this, object2 == null ? new TraceRecord(TraceRecord.BOTTOM) : new TraceRecord(TraceRecord.BOTTOM, object2));
        }

        @Override
        public void record() {
            this.record0(null);
        }

        @Override
        public void record(Object object) {
            this.record0(object);
        }

        private void record0(Object object) {
            if (TARGET_RECORDS > 0) {
                boolean bl2;
                TraceRecord traceRecord;
                TraceRecord traceRecord2;
                TraceRecord traceRecord3;
                do {
                    traceRecord = traceRecord3 = headUpdater.get(this);
                    if (traceRecord3 == null || traceRecord3.pos == -2) {
                        return;
                    }
                    int n2 = traceRecord3.pos + 1;
                    if (n2 >= TARGET_RECORDS) {
                        int n3 = Math.min(n2 - TARGET_RECORDS, 30);
                        boolean bl3 = bl2 = ThreadLocalRandom.current().nextInt(1 << n3) != 0;
                        if (!bl2) continue;
                        traceRecord = traceRecord3.next;
                        continue;
                    }
                    bl2 = false;
                } while (!headUpdater.compareAndSet(this, traceRecord3, traceRecord2 = object != null ? new TraceRecord(traceRecord, object) : new TraceRecord(traceRecord)));
                if (bl2) {
                    droppedRecordsUpdater.incrementAndGet(this);
                }
            }
        }

        boolean dispose() {
            this.clear();
            return this.allLeaks.remove(this);
        }

        public boolean close() {
            if (this.allLeaks.remove(this)) {
                this.clear();
                headUpdater.set(this, TRACK_CLOSE ? new TraceRecord(true) : null);
                return true;
            }
            return false;
        }

        @Override
        public boolean close(T t2) {
            assert (this.trackedHash == System.identityHashCode(t2));
            try {
                boolean bl2 = this.close();
                return bl2;
            }
            finally {
                DefaultResourceLeak.reachabilityFence0(t2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void reachabilityFence0(Object object) {
            if (object != null) {
                Object object2 = object;
                synchronized (object2) {
                }
            }
        }

        @Override
        @Nullable
        public Throwable getCloseStackTraceIfAny() {
            TraceRecord traceRecord = headUpdater.get(this);
            if (traceRecord != null && traceRecord.pos == -2) {
                return traceRecord;
            }
            return null;
        }

        public String toString() {
            TraceRecord traceRecord = headUpdater.get(this);
            return this.generateReport(traceRecord);
        }

        String getReportAndClearRecords() {
            TraceRecord traceRecord = headUpdater.getAndSet(this, null);
            return this.generateReport(traceRecord);
        }

        private String generateReport(TraceRecord traceRecord) {
            if (traceRecord == null) {
                return "";
            }
            int n2 = droppedRecordsUpdater.get(this);
            int n3 = 0;
            int n4 = traceRecord.pos + 1;
            StringBuilder stringBuilder = new StringBuilder(n4 * 2048).append(StringUtil.NEWLINE);
            stringBuilder.append("Recent access records: ").append(StringUtil.NEWLINE);
            int n5 = 1;
            HashSet<String> hashSet = new HashSet<String>(n4);
            while (traceRecord != TraceRecord.BOTTOM) {
                String string = traceRecord.toString();
                if (hashSet.add(string)) {
                    if (traceRecord.next == TraceRecord.BOTTOM) {
                        stringBuilder.append("Created at:").append(StringUtil.NEWLINE).append(string);
                    } else {
                        stringBuilder.append('#').append(n5++).append(':').append(StringUtil.NEWLINE).append(string);
                    }
                } else {
                    ++n3;
                }
                traceRecord = traceRecord.next;
            }
            if (n3 > 0) {
                stringBuilder.append(": ").append(n3).append(" leak records were discarded because they were duplicates").append(StringUtil.NEWLINE);
            }
            if (n2 > 0) {
                stringBuilder.append(": ").append(n2).append(" leak records were discarded because the leak record count is targeted to ").append(TARGET_RECORDS).append(". Use system property ").append("com.gradle.scan.plugin.internal.dep.io.netty.leakDetection.targetRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
            }
            stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
            return stringBuilder.toString();
        }
    }

    public static interface LeakListener {
        public void onLeak(String var1, String var2);
    }

    public static enum Level {
        DISABLED,
        SIMPLE,
        ADVANCED,
        PARANOID;


        static Level parseLevel(String string) {
            String string2 = string.trim();
            for (Level level : Level.values()) {
                if (!string2.equalsIgnoreCase(level.name()) && !string2.equals(String.valueOf(level.ordinal()))) continue;
                return level;
            }
            return DEFAULT_LEVEL;
        }
    }
}

