/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.dev.failsafe;

import com.gradle.scan.plugin.internal.dep.dev.failsafe.DelayablePolicyBuilder;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.RetryPolicy;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.RetryPolicyConfig;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.event.EventListener;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.event.ExecutionAttemptedEvent;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.function.CheckedPredicate;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.internal.RetryPolicyImpl;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.internal.util.Assert;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.internal.util.Durations;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RetryPolicyBuilder<R>
extends DelayablePolicyBuilder<RetryPolicyBuilder<R>, RetryPolicyConfig<R>, R> {
    RetryPolicyBuilder() {
        super(new RetryPolicyConfig());
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxRetries = 2;
        ((RetryPolicyConfig)this.config).abortConditions = new ArrayList();
    }

    public RetryPolicy<R> build() {
        return new RetryPolicyImpl(new RetryPolicyConfig((RetryPolicyConfig)this.config));
    }

    public RetryPolicyBuilder<R> abortIf(CheckedPredicate<R> checkedPredicate) {
        Assert.notNull(checkedPredicate, "resultPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(checkedPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> clazz) {
        Assert.notNull(clazz, "exception");
        return this.abortOn(Arrays.asList(clazz));
    }

    public RetryPolicyBuilder<R> abortOn(List<Class<? extends Throwable>> list) {
        Assert.notNull(list, "exceptions");
        Assert.isTrue(!list.isEmpty(), "exceptions cannot be empty", new Object[0]);
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(list));
        return this;
    }

    public RetryPolicyBuilder<R> onFailedAttempt(EventListener<ExecutionAttemptedEvent<R>> eventListener) {
        ((RetryPolicyConfig)this.config).failedAttemptListener = Assert.notNull(eventListener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetry(EventListener<ExecutionAttemptedEvent<R>> eventListener) {
        ((RetryPolicyConfig)this.config).retryListener = Assert.notNull(eventListener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> withBackoff(long l2, long l3, ChronoUnit chronoUnit, double d2) {
        return this.withBackoff(Duration.of(l2, chronoUnit), Duration.of(l3, chronoUnit), d2);
    }

    public RetryPolicyBuilder<R> withBackoff(Duration duration, Duration duration2, double d2) {
        Assert.notNull(duration, "delay");
        Assert.notNull(duration2, "maxDelay");
        duration = Durations.ofSafeNanos(duration);
        duration2 = Durations.ofSafeNanos(duration2);
        Assert.isTrue(!duration.isNegative() && !duration.isZero(), "The delay must be > 0", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || duration.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || duration.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delay must be >= the jitter duration", new Object[0]);
        Assert.isTrue(duration.toNanos() < duration2.toNanos(), "delay must be < the maxDelay", new Object[0]);
        Assert.isTrue(d2 > 1.0, "delayFactor must be > 1", new Object[0]);
        ((RetryPolicyConfig)this.config).delay = duration;
        ((RetryPolicyConfig)this.config).maxDelay = duration2;
        ((RetryPolicyConfig)this.config).delayFactor = d2;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    @Override
    public RetryPolicyBuilder<R> withDelay(Duration duration) {
        Assert.notNull(duration, "delay");
        duration = Durations.ofSafeNanos(duration);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || duration.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || duration.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delay must be >= the jitter duration", new Object[0]);
        super.withDelay(duration);
        ((RetryPolicyConfig)this.config).maxDelay = null;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(double d2) {
        Assert.isTrue(d2 >= 0.0 && d2 <= 1.0, "jitterFactor must be >= 0 and <= 1", new Object[0]);
        ((RetryPolicyConfig)this.config).jitterFactor = d2;
        ((RetryPolicyConfig)this.config).jitter = null;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxAttempts(int n2) {
        Assert.isTrue(n2 != 0, "maxAttempts cannot be 0", new Object[0]);
        Assert.isTrue(n2 >= -1, "maxAttempts must be >= -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = n2 == -1 ? -1 : n2 - 1;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxDuration(Duration duration) {
        Assert.notNull(duration, "maxDuration");
        duration = Durations.ofSafeNanos(duration);
        Assert.state(duration.toNanos() > ((RetryPolicyConfig)this.config).delay.toNanos(), "maxDuration must be > the delay", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delayMax == null || duration.toNanos() > ((RetryPolicyConfig)this.config).delayMax.toNanos(), "maxDuration must be > the max random delay", new Object[0]);
        ((RetryPolicyConfig)this.config).maxDuration = duration;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxRetries(int n2) {
        Assert.isTrue(n2 >= -1, "maxRetries must be >= to -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = n2;
        return this;
    }
}

