/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SocketUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;

final class NetUtilInitializations {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NetUtilInitializations.class);

    private NetUtilInitializations() {
    }

    static Inet4Address createLocalhost4() {
        byte[] byArray = new byte[]{127, 0, 0, 1};
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)InetAddress.getByAddress("localhost", byArray);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        return inet4Address;
    }

    static Inet6Address createLocalhost6() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet6Address inet6Address = null;
        try {
            inet6Address = (Inet6Address)InetAddress.getByAddress("localhost", byArray);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        return inet6Address;
    }

    static Collection<NetworkInterface> networkInterfaces() {
        ArrayList<NetworkInterface> arrayList;
        block5: {
            arrayList = new ArrayList<NetworkInterface>();
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        arrayList.add(enumeration.nextElement());
                    }
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to retrieve the list of available network interfaces", socketException);
            }
            catch (NullPointerException nullPointerException) {
                if (PlatformDependent.isAndroid()) break block5;
                throw nullPointerException;
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static NetworkIfaceAndInetAddress determineLoopback(Collection<NetworkInterface> collection, Inet4Address inet4Address, Inet6Address inet6Address) {
        void var5_16;
        void var5_10;
        Enumeration<InetAddress> enumeration;
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        for (NetworkInterface object2 : collection) {
            if (!SocketUtils.addressesFromNetworkInterface(object2).hasMoreElements()) continue;
            arrayList.add(object2);
        }
        Object object3 = null;
        Object var5_6 = null;
        block8: for (NetworkInterface networkInterface : arrayList) {
            enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface);
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!inetAddress.isLoopbackAddress()) continue;
                object3 = networkInterface;
                InetAddress inetAddress2 = inetAddress;
                break block8;
            }
        }
        if (object3 == null) {
            try {
                for (NetworkInterface networkInterface : arrayList) {
                    if (!networkInterface.isLoopback() || !(enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface)).hasMoreElements()) continue;
                    object3 = networkInterface;
                    InetAddress inetAddress = enumeration.nextElement();
                    break;
                }
                if (object3 == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to find the loopback interface", socketException);
            }
        }
        if (object3 != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)object3).getName(), ((NetworkInterface)object3).getDisplayName(), var5_10.getHostAddress());
        } else if (var5_10 == null) {
            try {
                if (NetworkInterface.getByInetAddress(inet6Address) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)inet6Address);
                    Inet6Address inet6Address2 = inet6Address;
                }
            }
            catch (Exception exception) {
            }
            finally {
                void var5_12;
                if (var5_12 == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    Inet4Address inet4Address2 = inet4Address;
                }
            }
        }
        return new NetworkIfaceAndInetAddress((NetworkInterface)object3, (InetAddress)var5_16);
    }

    static final class NetworkIfaceAndInetAddress {
        private final NetworkInterface iface;
        private final InetAddress address;

        NetworkIfaceAndInetAddress(NetworkInterface networkInterface, InetAddress inetAddress) {
            this.iface = networkInterface;
            this.address = inetAddress;
        }

        public NetworkInterface iface() {
            return this.iface;
        }

        public InetAddress address() {
            return this.address;
        }
    }
}

