/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.Year;
import java.time.format.DateTimeFormatter;

public class YearSerializer
extends JSR310FormattedSerializerBase<Year> {
    public static final YearSerializer INSTANCE = new YearSerializer();

    protected YearSerializer() {
        this((DateTimeFormatter)null);
    }

    public YearSerializer(DateTimeFormatter dateTimeFormatter) {
        super(Year.class, dateTimeFormatter);
    }

    protected YearSerializer(YearSerializer yearSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter) {
        super(yearSerializer, bl2, dateTimeFormatter, null);
    }

    protected YearSerializer withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new YearSerializer(this, bl2, dateTimeFormatter);
    }

    @Override
    public void serialize(Year year, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            jsonGenerator.writeNumber(year.getValue());
        } else {
            String string = this._formatter == null ? year.toString() : year.format(this._formatter);
            jsonGenerator.writeString(string);
        }
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonIntegerFormatVisitor jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType);
        if (jsonIntegerFormatVisitor != null) {
            jsonIntegerFormatVisitor.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        return this.useTimestamp(serializerProvider) ? JsonToken.VALUE_NUMBER_INT : JsonToken.VALUE_STRING;
    }
}

