/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.mac;

import com.gradle.scan.plugin.internal.dep.oshi.jna.Struct;
import com.gradle.scan.plugin.internal.dep.oshi.software.common.AbstractOSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.mac.MacOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.util.GlobalConfig;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.mac.SysctlUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.platform.unix.LibCAPI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(MacOSProcess.class);
    private static final int ARGMAX = SysctlUtil.sysctl("kern.argmax", 0);
    private static final long TICKS_PER_MS;
    private static final boolean LOG_MAC_SYSCTL_WARNING;
    private int majorVersion;
    private int minorVersion;
    private final MacOperatingSystem os;
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<Pair<List<String>, Map<String, String>>> argsEnviron = Memoizer.memoize(this::queryArgsAndEnvironment);
    private String name = "";
    private String path = "";
    private String currentWorkingDirectory;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long openFiles;
    private int bitness;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches;

    public MacOSProcess(int n2, int n3, int n4, MacOperatingSystem macOperatingSystem) {
        super(n2);
        this.majorVersion = n3;
        this.minorVersion = n4;
        this.os = macOperatingSystem;
        this.updateAttributes();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String queryCommandLine() {
        return String.join((CharSequence)" ", this.getArguments());
    }

    @Override
    public List<String> getArguments() {
        return this.argsEnviron.get().getA();
    }

    private Pair<List<String>, Map<String, String>> queryArgsAndEnvironment() {
        int n2 = this.getProcessID();
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int[] nArray = new int[]{1, 49, n2};
        try (Memory memory = new Memory(ARGMAX);){
            memory.clear();
            LibCAPI.size_t.ByReference byReference = new LibCAPI.size_t.ByReference((long)ARGMAX);
            if (0 == SystemB.INSTANCE.sysctl(nArray, nArray.length, (Pointer)memory, byReference, null, LibCAPI.size_t.ZERO)) {
                int n3 = memory.getInt(0L);
                if (n3 > 0 && n3 <= 1024) {
                    long l2 = SystemB.INT_SIZE;
                    l2 += (long)memory.getString(l2).length();
                    while (l2 < byReference.longValue()) {
                        while (memory.getByte(l2) == 0 && ++l2 < byReference.longValue()) {
                        }
                        String string = memory.getString(l2);
                        if (n3-- > 0) {
                            arrayList.add(string);
                        } else {
                            int n4 = string.indexOf(61);
                            if (n4 > 0) {
                                linkedHashMap.put(string.substring(0, n4), string.substring(n4 + 1));
                            }
                        }
                        l2 += (long)string.length();
                    }
                }
            } else if (n2 > 0 && LOG_MAC_SYSCTL_WARNING) {
                LOG.warn("Failed sysctl call for process arguments (kern.procargs2), process {} may not exist. Error code: {}", (Object)n2, (Object)Native.getLastError());
            }
        }
        return new Pair<List<String>, Map<String, String>>(Collections.unmodifiableList(arrayList), Collections.unmodifiableMap(linkedHashMap));
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }

    public boolean updateAttributes() {
        long l2 = System.currentTimeMillis();
        try (Structure structure = new Struct.CloseableProcTaskAllInfo();){
            Object object;
            if (0 > SystemB.INSTANCE.proc_pidinfo(this.getProcessID(), 2, 0L, structure, structure.size()) || ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_threadnum < 1) {
                this.state = OSProcess.State.INVALID;
                boolean bl2 = false;
                return bl2;
            }
            try (Object object2 = new Memory(4096L);){
                if (0 < SystemB.INSTANCE.proc_pidpath(this.getProcessID(), (Pointer)object2, 4096)) {
                    this.path = ((Pointer)object2).getString(0L).trim();
                    object = this.path.split("/");
                    if (((String[])object).length > 0) {
                        this.name = object[((String[])object).length - 1];
                    }
                }
            }
            if (this.name.isEmpty()) {
                this.name = Native.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_comm, StandardCharsets.UTF_8);
            }
            switch (((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_status) {
                case 1: {
                    this.state = OSProcess.State.SLEEPING;
                    break;
                }
                case 2: {
                    this.state = OSProcess.State.WAITING;
                    break;
                }
                case 3: {
                    this.state = OSProcess.State.RUNNING;
                    break;
                }
                case 4: {
                    this.state = OSProcess.State.NEW;
                    break;
                }
                case 5: {
                    this.state = OSProcess.State.ZOMBIE;
                    break;
                }
                case 6: {
                    this.state = OSProcess.State.STOPPED;
                    break;
                }
                default: {
                    this.state = OSProcess.State.OTHER;
                }
            }
            this.parentProcessID = ((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_ppid;
            this.userID = Integer.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_uid);
            object2 = SystemB.INSTANCE.getpwuid(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_uid);
            this.user = object2 == null ? Integer.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_uid) : ((SystemB.Passwd)object2).pw_name;
            this.groupID = Integer.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_gid);
            object = SystemB.INSTANCE.getgrgid(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_gid);
            this.group = object == null ? Integer.toString(((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_gid) : object.gr_name;
            this.threadCount = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_threadnum;
            this.priority = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_priority;
            this.virtualSize = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_virtual_size;
            this.residentSetSize = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_resident_size;
            this.kernelTime = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_total_system / TICKS_PER_MS;
            this.userTime = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_total_user / TICKS_PER_MS;
            this.startTime = ((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_start_tvsec * 1000L + ((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_start_tvusec / 1000L;
            this.upTime = l2 - this.startTime;
            this.openFiles = ((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_nfiles;
            this.bitness = (((Struct.CloseableProcTaskAllInfo)structure).pbsd.pbi_flags & 4) == 0 ? 32 : 64;
            this.majorFaults = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_pageins;
            this.minorFaults = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_faults - ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_pageins;
            this.contextSwitches = ((Struct.CloseableProcTaskAllInfo)structure).ptinfo.pti_csw;
        }
        if (this.majorVersion > 10 || this.minorVersion >= 9) {
            structure = new Struct.CloseableRUsageInfoV2();
            try {
                if (0 == SystemB.INSTANCE.proc_pid_rusage(this.getProcessID(), 2, (SystemB.RUsageInfoV2)structure)) {
                    this.bytesRead = ((Struct.CloseableRUsageInfoV2)structure).ri_diskio_bytesread;
                    this.bytesWritten = ((Struct.CloseableRUsageInfoV2)structure).ri_diskio_byteswritten;
                }
            }
            finally {
                ((Struct.CloseableRUsageInfoV2)structure).close();
            }
        }
        structure = new Struct.CloseableVnodePathInfo();
        try {
            if (0 < SystemB.INSTANCE.proc_pidinfo(this.getProcessID(), 9, 0L, structure, structure.size())) {
                this.currentWorkingDirectory = Native.toString(((Struct.CloseableVnodePathInfo)structure).pvi_cdir.vip_path, StandardCharsets.US_ASCII);
            }
        }
        finally {
            ((Struct.CloseableVnodePathInfo)structure).close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long l2 = 1000000000L;
        IOKit.IOIterator iOIterator = IOKitUtil.getMatchingServices("IOPlatformDevice");
        if (iOIterator != null) {
            IOKit.IORegistryEntry iORegistryEntry = iOIterator.next();
            while (iORegistryEntry != null) {
                try {
                    byte[] byArray;
                    String string = iORegistryEntry.getName().toLowerCase(Locale.ROOT);
                    if (string.startsWith("cpu") && string.length() > 3 && (byArray = iORegistryEntry.getByteArrayProperty("timebase-frequency")) != null) {
                        l2 = ParseUtil.byteArrayToLong(byArray, 4, false);
                        break;
                    }
                }
                finally {
                    iORegistryEntry.release();
                }
                iORegistryEntry = iOIterator.next();
            }
            iOIterator.release();
        }
        TICKS_PER_MS = l2 / 1000L;
        LOG_MAC_SYSCTL_WARNING = GlobalConfig.get("com.gradle.scan.plugin.internal.dep.oshi.os.mac.sysctl.logwarning", false);
    }
}

