/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.NumericNode;
import java.io.IOException;

public class DoubleNode
extends NumericNode {
    protected final double _value;

    public DoubleNode(double d2) {
        this._value = d2;
    }

    public static DoubleNode valueOf(double d2) {
        return new DoubleNode(d2);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public long longValue() {
        return (long)this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(this._value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof DoubleNode) {
            double d2 = ((DoubleNode)object)._value;
            return Double.compare(this._value, d2) == 0;
        }
        return false;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this._value);
        return (int)l2 ^ (int)(l2 >> 32);
    }
}

