/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.doubleparser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.doubleparser.AbstractJavaFloatingPointBitsFromCharSequence;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.doubleparser.FastDoubleMath;

final class JavaDoubleBitsFromCharSequence
extends AbstractJavaFloatingPointBitsFromCharSequence {
    @Override
    long nan() {
        return Double.doubleToRawLongBits(Double.NaN);
    }

    @Override
    long negativeInfinity() {
        return Double.doubleToRawLongBits(Double.NEGATIVE_INFINITY);
    }

    @Override
    long positiveInfinity() {
        return Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
    }

    @Override
    long valueOfFloatLiteral(CharSequence charSequence, int n2, int n3, boolean bl2, long l2, int n4, boolean bl3, int n5) {
        double d2 = FastDoubleMath.tryDecFloatToDoubleTruncated(bl2, l2, n4, bl3, n5);
        return Double.doubleToRawLongBits(Double.isNaN(d2) ? Double.parseDouble(charSequence.subSequence(n2, n3).toString()) : d2);
    }

    @Override
    long valueOfHexLiteral(CharSequence charSequence, int n2, int n3, boolean bl2, long l2, int n4, boolean bl3, int n5) {
        double d2 = FastDoubleMath.tryHexFloatToDoubleTruncated(bl2, l2, n4, bl3, n5);
        return Double.doubleToRawLongBits(Double.isNaN(d2) ? Double.parseDouble(charSequence.subSequence(n2, n3).toString()) : d2);
    }
}

