/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.compressors.gzip;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.compressors.CompressorInputStream;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.compressors.gzip.GzipParameters;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.compressors.gzip.GzipUtils;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils.ByteUtils;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils.CountingInputStream;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils.IOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class GzipCompressorInputStream
extends CompressorInputStream {
    private final CountingInputStream countingStream;
    private final InputStream in;
    private final boolean decompressConcatenated;
    private final byte[] buf = new byte[8192];
    private int bufUsed;
    private Inflater inf = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private boolean endReached;
    private final byte[] oneByte = new byte[1];
    private final GzipParameters parameters = new GzipParameters();

    private static byte[] readToNull(DataInput dataInput) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n2;
            while ((n2 = dataInput.readUnsignedByte()) != 0) {
                byteArrayOutputStream.write(n2);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public GzipCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public GzipCompressorInputStream(InputStream inputStream, boolean bl2) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = this.countingStream.markSupported() ? this.countingStream : new BufferedInputStream(this.countingStream);
        this.decompressConcatenated = bl2;
        this.init(true);
    }

    @Override
    public void close() throws IOException {
        if (this.inf != null) {
            this.inf.end();
            this.inf = null;
        }
        if (this.in != System.in) {
            this.in.close();
        }
    }

    private boolean init(boolean bl2) throws IOException {
        assert (bl2 || this.decompressConcatenated);
        int n2 = this.in.read();
        if (n2 == -1 && !bl2) {
            return false;
        }
        if (n2 != 31 || this.in.read() != 139) {
            throw new IOException(bl2 ? "Input is not in the .gz format" : "Garbage after a valid .gz stream");
        }
        DataInputStream dataInputStream = new DataInputStream(this.in);
        int n3 = dataInputStream.readUnsignedByte();
        if (n3 != 8) {
            throw new IOException("Unsupported compression method " + n3 + " in the .gz header");
        }
        int n4 = dataInputStream.readUnsignedByte();
        if ((n4 & 0xE0) != 0) {
            throw new IOException("Reserved flags are set in the .gz header");
        }
        this.parameters.setModificationTime(ByteUtils.fromLittleEndian(dataInputStream, 4) * 1000L);
        switch (dataInputStream.readUnsignedByte()) {
            case 2: {
                this.parameters.setCompressionLevel(9);
                break;
            }
            case 4: {
                this.parameters.setCompressionLevel(1);
                break;
            }
        }
        this.parameters.setOperatingSystem(dataInputStream.readUnsignedByte());
        if ((n4 & 4) != 0) {
            int n5 = dataInputStream.readUnsignedByte();
            n5 |= dataInputStream.readUnsignedByte() << 8;
            while (n5-- > 0) {
                dataInputStream.readUnsignedByte();
            }
        }
        if ((n4 & 8) != 0) {
            this.parameters.setFileName(new String(GzipCompressorInputStream.readToNull(dataInputStream), GzipUtils.GZIP_ENCODING));
        }
        if ((n4 & 0x10) != 0) {
            this.parameters.setComment(new String(GzipCompressorInputStream.readToNull(dataInputStream), GzipUtils.GZIP_ENCODING));
        }
        if ((n4 & 2) != 0) {
            dataInputStream.readShort();
        }
        this.inf.reset();
        this.crc.reset();
        return true;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        if (this.endReached) {
            return -1;
        }
        int n4 = 0;
        while (n3 > 0) {
            int n5;
            if (this.inf.needsInput()) {
                this.in.mark(this.buf.length);
                this.bufUsed = this.in.read(this.buf);
                if (this.bufUsed == -1) {
                    throw new EOFException();
                }
                this.inf.setInput(this.buf, 0, this.bufUsed);
            }
            try {
                n5 = this.inf.inflate(byArray, n2, n3);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException("Gzip-compressed data is corrupt");
            }
            this.crc.update(byArray, n2, n5);
            n2 += n5;
            n3 -= n5;
            n4 += n5;
            this.count(n5);
            if (!this.inf.finished()) continue;
            this.in.reset();
            int n6 = this.bufUsed - this.inf.getRemaining();
            if (IOUtils.skip(this.in, n6) != (long)n6) {
                throw new IOException();
            }
            this.bufUsed = 0;
            DataInputStream dataInputStream = new DataInputStream(this.in);
            long l2 = ByteUtils.fromLittleEndian(dataInputStream, 4);
            if (l2 != this.crc.getValue()) {
                throw new IOException("Gzip-compressed data is corrupt (CRC32 error)");
            }
            long l3 = ByteUtils.fromLittleEndian(dataInputStream, 4);
            if (l3 != (this.inf.getBytesWritten() & 0xFFFFFFFFL)) {
                throw new IOException("Gzip-compressed data is corrupt(uncompressed size mismatch)");
            }
            if (this.decompressConcatenated && this.init(false)) continue;
            this.inf.end();
            this.inf = null;
            this.endReached = true;
            return n4 == 0 ? -1 : n4;
        }
        return n4;
    }
}

