/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.scan.plugin.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

final class WebSocketUtil {
    private static final FastThreadLocal<MessageDigest> MD5 = new FastThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() throws Exception {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("MD5 not supported on this platform - Outdated?");
            }
        }
    };
    private static final FastThreadLocal<MessageDigest> SHA1 = new FastThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() throws Exception {
            try {
                return MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("SHA-1 not supported on this platform - Outdated?");
            }
        }
    };

    static byte[] md5(byte[] byArray) {
        return WebSocketUtil.digest(MD5, byArray);
    }

    static byte[] sha1(byte[] byArray) {
        return WebSocketUtil.digest(SHA1, byArray);
    }

    private static byte[] digest(FastThreadLocal<MessageDigest> fastThreadLocal, byte[] byArray) {
        MessageDigest messageDigest = fastThreadLocal.get();
        messageDigest.reset();
        return messageDigest.digest(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String base64(byte[] byArray) {
        String string;
        if (PlatformDependent.javaVersion() >= 8) {
            return Base64.getEncoder().encodeToString(byArray);
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        try {
            ByteBuf byteBuf2 = com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.base64.Base64.encode(byteBuf);
            try {
                string = byteBuf2.toString(CharsetUtil.UTF_8);
            }
            finally {
                byteBuf2.release();
            }
        }
        finally {
            byteBuf.release();
        }
        return string;
    }

    static byte[] randomBytes(int n2) {
        byte[] byArray = new byte[n2];
        PlatformDependent.threadLocalRandom().nextBytes(byArray);
        return byArray;
    }

    static int randomNumber(int n2, int n3) {
        assert (n2 < n3);
        double d2 = PlatformDependent.threadLocalRandom().nextDouble();
        return (int)((double)n2 + d2 * (double)(n3 - n2));
    }

    static int byteAtIndex(int n2, int n3) {
        return n2 >> 8 * (3 - n3) & 0xFF;
    }

    private WebSocketUtil() {
    }
}

