/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.CiUtils;
import com.gradle.Utils;
import com.gradle.scan.plugin.BuildResult;
import com.gradle.scan.plugin.BuildScanExtension;
import java.net.URI;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;

final class CustomBuildScanEnhancements {
    private static final String SYSTEM_PROP_IDEA_VENDOR_NAME = "idea.vendor.name";
    private static final String SYSTEM_PROP_IDEA_VERSION = "idea.version";
    private static final String PROJECT_PROP_ANDROID_INVOKED_FROM_IDE = "android.injected.invoked.from.ide";
    private static final String PROJECT_PROP_ANDROID_STUDIO_VERSION = "android.injected.studio.version";
    private static final String SYSTEM_PROP_ECLIPSE_BUILD_ID = "eclipse.buildId";
    private static final String SYSTEM_PROP_IDEA_SYNC_ACTIVE = "idea.sync.active";
    private final BuildScanExtension buildScan;
    private final ProviderFactory providers;
    private final Gradle gradle;

    CustomBuildScanEnhancements(BuildScanExtension buildScan, ProviderFactory providers, Gradle gradle) {
        this.buildScan = buildScan;
        this.providers = providers;
        this.gradle = gradle;
    }

    void apply() {
        this.captureOs();
        this.captureIde();
        this.captureCiOrLocal();
        this.captureCiMetadata();
        this.captureGitMetadata();
        this.captureTestParallelization();
    }

    private void captureOs() {
        Utils.sysProperty("os.name", this.providers).ifPresent(arg_0 -> ((BuildScanExtension)this.buildScan).tag(arg_0));
    }

    private void captureIde() {
        if (!CiUtils.isCi(this.providers)) {
            HashMap<String, Provider<String>> ideProperties = new HashMap<String, Provider<String>>();
            ideProperties.put(SYSTEM_PROP_IDEA_VENDOR_NAME, CustomBuildScanEnhancements.systemPropertyProvider(SYSTEM_PROP_IDEA_VENDOR_NAME, this.providers));
            ideProperties.put(SYSTEM_PROP_IDEA_VERSION, CustomBuildScanEnhancements.systemPropertyProvider(SYSTEM_PROP_IDEA_VERSION, this.providers));
            ideProperties.put(PROJECT_PROP_ANDROID_INVOKED_FROM_IDE, CustomBuildScanEnhancements.gradlePropertyProvider(PROJECT_PROP_ANDROID_INVOKED_FROM_IDE, this.gradle, this.providers));
            ideProperties.put(PROJECT_PROP_ANDROID_STUDIO_VERSION, CustomBuildScanEnhancements.gradlePropertyProvider(PROJECT_PROP_ANDROID_STUDIO_VERSION, this.gradle, this.providers));
            ideProperties.put(SYSTEM_PROP_ECLIPSE_BUILD_ID, CustomBuildScanEnhancements.systemPropertyProvider(SYSTEM_PROP_ECLIPSE_BUILD_ID, this.providers));
            ideProperties.put(SYSTEM_PROP_IDEA_SYNC_ACTIVE, CustomBuildScanEnhancements.systemPropertyProvider(SYSTEM_PROP_IDEA_SYNC_ACTIVE, this.providers));
            this.buildScan.buildFinished((Action)new CaptureIdeMetadataAction(this.buildScan, ideProperties));
        }
    }

    private void captureCiOrLocal() {
        this.buildScan.tag(CiUtils.isCi(this.providers) ? "CI" : "LOCAL");
    }

    private void captureCiMetadata() {
        if (CiUtils.isCi(this.providers)) {
            Provider projectDirectory = this.providers.provider(() -> this.gradle.getRootProject().getLayout().getProjectDirectory());
            this.buildScan.buildFinished((Action)new CaptureCiMetadataAction(this.buildScan, this.providers, projectDirectory));
        }
    }

    private void captureGitMetadata() {
        this.buildScan.background((Action)new CaptureGitMetadataAction(this.providers));
    }

    private void captureTestParallelization() {
        this.gradle.afterProject(p -> {
            TaskCollection tests = p.getTasks().withType(Test.class);
            if (Utils.isGradle5OrNewer()) {
                tests.configureEach(CustomBuildScanEnhancements.captureMaxParallelForks(this.buildScan));
            } else {
                tests.all(CustomBuildScanEnhancements.captureMaxParallelForks(this.buildScan));
            }
        });
    }

    private static Action<Test> captureMaxParallelForks(final BuildScanExtension buildScan) {
        return test -> test.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                buildScan.value(test.getIdentityPath() + "#maxParallelForks", String.valueOf(test.getMaxParallelForks()));
            }
        });
    }

    private static void addCustomValueAndSearchLink(BuildScanExtension buildScan, String name, String value) {
        buildScan.value(name, value);
        CustomBuildScanEnhancements.addSearchLink(buildScan, name, name, value);
    }

    private static void addCustomValueAndSearchLink(BuildScanExtension buildScan, String linkLabel, String name, String value) {
        buildScan.value(name, value);
        CustomBuildScanEnhancements.addSearchLink(buildScan, linkLabel, name, value);
    }

    private static void addSearchLink(BuildScanExtension buildScan, String linkLabel, Map<String, String> values) {
        values.entrySet().stream().sorted(Map.Entry.comparingByKey()).reduce((a, b) -> new AbstractMap.SimpleEntry<String, String>((String)a.getKey() + "," + (String)b.getKey(), (String)a.getValue() + "," + (String)b.getValue())).ifPresent(x -> CustomBuildScanEnhancements.addSearchLink(buildScan, linkLabel, (String)x.getKey(), (String)x.getValue()));
    }

    private static void addSearchLink(BuildScanExtension buildScan, String linkLabel, String name, String value) {
        String searchParams = "search.names=" + Utils.urlEncode(name) + "&search.values=" + Utils.urlEncode(value);
        String server = CustomBuildScanEnhancements.getServer(buildScan);
        if (server != null) {
            String url = Utils.appendIfMissing(server, '/') + "scans?" + searchParams + "#selection.buildScanB=" + Utils.urlEncode("{SCAN_ID}");
            buildScan.link(linkLabel + " build scans", url);
        }
    }

    private static String getServer(BuildScanExtension buildScan) {
        try {
            buildScan.getClass().getMethod("getServer", new Class[0]);
            return buildScan.getServer();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Provider<String> systemPropertyProvider(String name, ProviderFactory providers) {
        if (Utils.isGradle61OrNewer()) {
            return providers.systemProperty(name);
        }
        return providers.provider(() -> System.getProperty(name));
    }

    private static Provider<String> gradlePropertyProvider(String name, Gradle gradle, ProviderFactory providers) {
        if (Utils.isGradle62OrNewer()) {
            return providers.gradleProperty(name);
        }
        return providers.provider(() -> (String)gradle.getRootProject().findProperty(name));
    }

    private static final class CaptureGitMetadataAction
    implements Action<BuildScanExtension> {
        private final ProviderFactory providers;

        private CaptureGitMetadataAction(ProviderFactory providers) {
            this.providers = providers;
        }

        public void execute(BuildScanExtension buildScan) {
            if (!this.isGitInstalled()) {
                return;
            }
            String gitRepo = Utils.execAndGetStdOut("git", "config", "--get", "remote.origin.url");
            String gitCommitId = Utils.execAndGetStdOut("git", "rev-parse", "--verify", "HEAD");
            String gitCommitShortId = Utils.execAndGetStdOut("git", "rev-parse", "--short=8", "--verify", "HEAD");
            String gitBranchName = this.getGitBranchName(() -> Utils.execAndGetStdOut("git", "rev-parse", "--abbrev-ref", "HEAD"));
            String gitStatus = Utils.execAndGetStdOut("git", "status", "--porcelain");
            if (Utils.isNotEmpty(gitRepo)) {
                buildScan.value("Git repository", Utils.redactUserInfo(gitRepo));
            }
            if (Utils.isNotEmpty(gitCommitId)) {
                buildScan.value("Git commit id", gitCommitId);
            }
            if (Utils.isNotEmpty(gitCommitShortId)) {
                buildScan.buildFinished(result -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "Git commit id", "Git commit id short", gitCommitShortId));
            }
            if (Utils.isNotEmpty(gitBranchName)) {
                buildScan.tag(gitBranchName);
                buildScan.value("Git branch", gitBranchName);
            }
            if (Utils.isNotEmpty(gitStatus)) {
                buildScan.tag("Dirty");
                buildScan.value("Git status", gitStatus);
            }
            Optional<String> gitHubUrl = Utils.envVariable("GITHUB_SERVER_URL", this.providers);
            Optional<String> gitRepository = Utils.envVariable("GITHUB_REPOSITORY", this.providers);
            if (gitHubUrl.isPresent() && gitRepository.isPresent() && Utils.isNotEmpty(gitCommitId)) {
                buildScan.link("GitHub source", gitHubUrl.get() + "/" + gitRepository.get() + "/tree/" + gitCommitId);
            } else if (Utils.isNotEmpty(gitRepo) && Utils.isNotEmpty(gitCommitId)) {
                Optional<URI> webRepoUri = Utils.toWebRepoUri(gitRepo);
                webRepoUri.ifPresent(uri -> {
                    if (uri.getHost().contains("github")) {
                        buildScan.link("GitHub source", uri + "/tree/" + gitCommitId);
                    } else if (uri.getHost().contains("gitlab")) {
                        buildScan.link("GitLab source", uri + "/-/commit/" + gitCommitId);
                    }
                });
            }
        }

        private boolean isGitInstalled() {
            return Utils.execAndCheckSuccess("git", "--version");
        }

        private String getGitBranchName(Supplier<String> gitCommand) {
            Optional<String> branch;
            if (CiUtils.isJenkins(this.providers) || CiUtils.isHudson(this.providers)) {
                Optional<String> branch2 = Utils.envVariable("BRANCH_NAME", this.providers);
                if (branch2.isPresent()) {
                    return branch2.get();
                }
            } else if (CiUtils.isGitLab(this.providers)) {
                Optional<String> branch3 = Utils.envVariable("CI_COMMIT_REF_NAME", this.providers);
                if (branch3.isPresent()) {
                    return branch3.get();
                }
            } else if (CiUtils.isAzurePipelines(this.providers)) {
                Optional<String> branch4 = Utils.envVariable("BUILD_SOURCEBRANCH", this.providers);
                if (branch4.isPresent()) {
                    return branch4.get();
                }
            } else if (CiUtils.isBuildkite(this.providers) && (branch = Utils.envVariable("BUILDKITE_BRANCH", this.providers)).isPresent()) {
                return branch.get();
            }
            return gitCommand.get();
        }
    }

    private static final class CaptureCiMetadataAction
    implements Action<BuildResult> {
        private final BuildScanExtension buildScan;
        private final ProviderFactory providers;
        private final Provider<Directory> projectDirectory;

        private CaptureCiMetadataAction(BuildScanExtension buildScan, ProviderFactory providers, Provider<Directory> projectDirectory) {
            this.buildScan = buildScan;
            this.providers = providers;
            this.projectDirectory = projectDirectory;
        }

        public void execute(BuildResult buildResult) {
            String buildUrl;
            Optional<String> teamcityBuildPropertiesFile;
            if (CiUtils.isJenkins(this.providers) || CiUtils.isHudson(this.providers)) {
                Optional<String> buildUrl2 = Utils.envVariable("BUILD_URL", this.providers);
                Optional<String> buildNumber = Utils.envVariable("BUILD_NUMBER", this.providers);
                Optional<String> nodeName = Utils.envVariable("NODE_NAME", this.providers);
                Optional<String> jobName = Utils.envVariable("JOB_NAME", this.providers);
                Optional<String> stageName = Utils.envVariable("STAGE_NAME", this.providers);
                buildUrl2.ifPresent(url -> this.buildScan.link(CiUtils.isJenkins(this.providers) ? "Jenkins build" : "Hudson build", url));
                buildNumber.ifPresent(value -> this.buildScan.value("CI build number", value));
                nodeName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI node", value));
                jobName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                stageName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI stage", value));
                jobName.ifPresent(j -> buildNumber.ifPresent(b -> {
                    LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                    params.put("CI job", (String)j);
                    params.put("CI build number", (String)b);
                    CustomBuildScanEnhancements.addSearchLink(this.buildScan, "CI pipeline", params);
                }));
            }
            if (CiUtils.isTeamCity(this.providers) && (teamcityBuildPropertiesFile = Utils.envVariable("TEAMCITY_BUILD_PROPERTIES_FILE", this.providers)).isPresent()) {
                String teamCityAgentName;
                String teamCityBuildTypeId;
                String teamCityBuildNumber;
                Properties configProperties;
                String teamCityServerUrl;
                String teamcityConfigFile;
                Properties buildProperties = Utils.readPropertiesFile(teamcityBuildPropertiesFile.get(), this.providers, (Directory)this.projectDirectory.get());
                String teamCityBuildId = buildProperties.getProperty("teamcity.build.id");
                if (Utils.isNotEmpty(teamCityBuildId) && Utils.isNotEmpty(teamcityConfigFile = buildProperties.getProperty("teamcity.configuration.properties.file")) && Utils.isNotEmpty(teamCityServerUrl = (configProperties = Utils.readPropertiesFile(teamcityConfigFile, this.providers, (Directory)this.projectDirectory.get())).getProperty("teamcity.serverUrl"))) {
                    buildUrl = Utils.appendIfMissing(teamCityServerUrl, '/') + "viewLog.html?buildId=" + Utils.urlEncode(teamCityBuildId);
                    this.buildScan.link("TeamCity build", buildUrl);
                }
                if (Utils.isNotEmpty(teamCityBuildNumber = buildProperties.getProperty("build.number"))) {
                    this.buildScan.value("CI build number", teamCityBuildNumber);
                }
                if (Utils.isNotEmpty(teamCityBuildTypeId = buildProperties.getProperty("teamcity.buildType.id"))) {
                    CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI build config", teamCityBuildTypeId);
                }
                if (Utils.isNotEmpty(teamCityAgentName = buildProperties.getProperty("agent.name"))) {
                    CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI agent", teamCityAgentName);
                }
            }
            if (CiUtils.isCircleCI(this.providers)) {
                Utils.envVariable("CIRCLE_BUILD_URL", this.providers).ifPresent(url -> this.buildScan.link("CircleCI build", url));
                Utils.envVariable("CIRCLE_BUILD_NUM", this.providers).ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("CIRCLE_JOB", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                Utils.envVariable("CIRCLE_WORKFLOW_ID", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI workflow", value));
            }
            if (CiUtils.isBamboo(this.providers)) {
                Utils.envVariable("bamboo_resultsUrl", this.providers).ifPresent(url -> this.buildScan.link("Bamboo build", url));
                Utils.envVariable("bamboo_buildNumber", this.providers).ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("bamboo_planName", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI plan", value));
                Utils.envVariable("bamboo_buildPlanName", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI build plan", value));
                Utils.envVariable("bamboo_agentId", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI agent", value));
            }
            if (CiUtils.isGitHubActions(this.providers)) {
                Optional<String> gitHubUrl = Utils.envVariable("GITHUB_SERVER_URL", this.providers);
                Optional<String> gitRepository = Utils.envVariable("GITHUB_REPOSITORY", this.providers);
                Optional<String> gitHubRunId = Utils.envVariable("GITHUB_RUN_ID", this.providers);
                if (gitHubUrl.isPresent() && gitRepository.isPresent() && gitHubRunId.isPresent()) {
                    this.buildScan.link("GitHub Actions build", gitHubUrl.get() + "/" + gitRepository.get() + "/actions/runs/" + gitHubRunId.get());
                }
                Utils.envVariable("GITHUB_WORKFLOW", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI workflow", value));
                Utils.envVariable("GITHUB_RUN_ID", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI run", value));
            }
            if (CiUtils.isGitLab(this.providers)) {
                Utils.envVariable("CI_JOB_URL", this.providers).ifPresent(url -> this.buildScan.link("GitLab build", url));
                Utils.envVariable("CI_PIPELINE_URL", this.providers).ifPresent(url -> this.buildScan.link("GitLab pipeline", url));
                Utils.envVariable("CI_JOB_NAME", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                Utils.envVariable("CI_JOB_STAGE", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI stage", value));
            }
            if (CiUtils.isTravis(this.providers)) {
                Utils.envVariable("TRAVIS_BUILD_WEB_URL", this.providers).ifPresent(url -> this.buildScan.link("Travis build", url));
                Utils.envVariable("TRAVIS_BUILD_NUMBER", this.providers).ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("TRAVIS_JOB_NAME", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                Utils.envVariable("TRAVIS_EVENT_TYPE", this.providers).ifPresent(arg_0 -> ((BuildScanExtension)this.buildScan).tag(arg_0));
            }
            if (CiUtils.isBitrise(this.providers)) {
                Utils.envVariable("BITRISE_BUILD_URL", this.providers).ifPresent(url -> this.buildScan.link("Bitrise build", url));
                Utils.envVariable("BITRISE_BUILD_NUMBER", this.providers).ifPresent(value -> this.buildScan.value("CI build number", value));
            }
            if (CiUtils.isGoCD(this.providers)) {
                Optional<String> goServerUrl;
                Optional<String> jobName;
                Optional<String> stageNumber;
                Optional<String> stageName;
                Optional<String> pipelineNumber;
                Optional<String> pipelineName = Utils.envVariable("GO_PIPELINE_NAME", this.providers);
                if (Stream.of(pipelineName, pipelineNumber = Utils.envVariable("GO_PIPELINE_COUNTER", this.providers), stageName = Utils.envVariable("GO_STAGE_NAME", this.providers), stageNumber = Utils.envVariable("GO_STAGE_COUNTER", this.providers), jobName = Utils.envVariable("GO_JOB_NAME", this.providers), goServerUrl = Utils.envVariable("GO_SERVER_URL", this.providers)).allMatch(Optional::isPresent)) {
                    buildUrl = String.format("%s/tab/build/detail/%s/%s/%s/%s/%s", goServerUrl.get(), pipelineName.get(), pipelineNumber.get(), stageName.get(), stageNumber.get(), jobName.get());
                    this.buildScan.link("GoCD build", buildUrl);
                } else if (goServerUrl.isPresent()) {
                    this.buildScan.link("GoCD", goServerUrl.get());
                }
                pipelineName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI pipeline", value));
                jobName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                stageName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI stage", value));
            }
            if (CiUtils.isAzurePipelines(this.providers)) {
                Optional<String> buildId;
                Optional<String> azureProject;
                Optional<String> azureServerUrl = Utils.envVariable("SYSTEM_TEAMFOUNDATIONCOLLECTIONURI", this.providers);
                if (Stream.of(azureServerUrl, azureProject = Utils.envVariable("SYSTEM_TEAMPROJECT", this.providers), buildId = Utils.envVariable("BUILD_BUILDID", this.providers)).allMatch(Optional::isPresent)) {
                    String buildUrl3 = String.format("%s%s/_build/results?buildId=%s", azureServerUrl.get(), azureProject.get(), buildId.get());
                    this.buildScan.link("Azure Pipelines build", buildUrl3);
                } else if (azureServerUrl.isPresent()) {
                    this.buildScan.link("Azure Pipelines", azureServerUrl.get());
                }
                buildId.ifPresent(value -> this.buildScan.value("CI build number", value));
            }
            if (CiUtils.isBuildkite(this.providers)) {
                Utils.envVariable("BUILDKITE_BUILD_URL", this.providers).ifPresent(s -> this.buildScan.link("Buildkite build", s));
                Utils.envVariable("BUILDKITE_COMMAND", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI command", value));
                Utils.envVariable("BUILDKITE_BUILD_ID", this.providers).ifPresent(value -> this.buildScan.value("CI build ID", value));
                Optional<String> buildkitePrRepo = Utils.envVariable("BUILDKITE_PULL_REQUEST_REPO", this.providers);
                Optional<String> buildkitePrNumber = Utils.envVariable("BUILDKITE_PULL_REQUEST", this.providers);
                if (buildkitePrRepo.isPresent() && buildkitePrNumber.isPresent()) {
                    String prNumber = buildkitePrNumber.get();
                    Utils.toWebRepoUri(buildkitePrRepo.get()).ifPresent(s -> this.buildScan.link("PR source", s + "/pull/" + prNumber));
                }
            }
        }
    }

    private static final class CaptureIdeMetadataAction
    implements Action<BuildResult> {
        private final BuildScanExtension buildScan;
        private final Map<String, Provider<String>> props;

        private CaptureIdeMetadataAction(BuildScanExtension buildScan, Map<String, Provider<String>> props) {
            this.buildScan = buildScan;
            this.props = props;
        }

        public void execute(BuildResult buildResult) {
            if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VENDOR_NAME).isPresent()) {
                String ideaVendorNameValue = (String)this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VENDOR_NAME).get();
                if ("Google".equals(ideaVendorNameValue)) {
                    this.tagIde("Android Studio", this.getOrEmpty(this.props.get(CustomBuildScanEnhancements.PROJECT_PROP_ANDROID_STUDIO_VERSION)));
                } else if ("JetBrains".equals(ideaVendorNameValue)) {
                    this.tagIde("IntelliJ IDEA", this.getOrEmpty(this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION)));
                }
            } else if (this.props.get(CustomBuildScanEnhancements.PROJECT_PROP_ANDROID_INVOKED_FROM_IDE).isPresent()) {
                this.tagIde("Android Studio", this.getOrEmpty(this.props.get(CustomBuildScanEnhancements.PROJECT_PROP_ANDROID_STUDIO_VERSION)));
            } else if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION).isPresent()) {
                this.tagIde("IntelliJ IDEA", (String)this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION).get());
            } else if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_ECLIPSE_BUILD_ID).isPresent()) {
                this.tagIde("Eclipse", (String)this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_ECLIPSE_BUILD_ID).get());
            } else {
                this.buildScan.tag("Cmd Line");
            }
            if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_SYNC_ACTIVE).isPresent()) {
                this.buildScan.tag("IDE sync");
            }
        }

        private String getOrEmpty(Provider<String> p) {
            if (Utils.isGradle43rNewer()) {
                return (String)p.getOrElse((Object)"");
            }
            String value = (String)p.getOrNull();
            return value != null ? value : "";
        }

        private void tagIde(String ideLabel, String version) {
            this.buildScan.tag(ideLabel);
            if (!version.isEmpty()) {
                this.buildScan.value(ideLabel + " version", version);
            }
        }
    }
}

