/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal;

import com.gradle.scan.plugin.BuildResult;
import com.gradle.scan.plugin.BuildScanException;
import com.gradle.scan.plugin.BuildScanPlugin;
import com.gradle.scan.plugin.UnsupportedGradleVersionException;
import com.gradle.scan.plugin.internal.BuildScanPluginImplementation;
import com.gradle.scan.plugin.internal.a.c;
import com.gradle.scan.plugin.internal.a.d.a;
import com.gradle.scan.plugin.internal.a.x.d;
import com.gradle.scan.plugin.internal.api.e;
import com.gradle.scan.plugin.internal.api.f;
import com.gradle.scan.plugin.internal.api.l;
import com.gradle.scan.plugin.internal.g;
import com.gradle.scan.plugin.internal.h;
import com.gradle.scan.plugin.internal.i;
import com.gradle.scan.plugin.internal.j;
import com.gradle.scan.plugin.internal.j.a.e;
import com.gradle.scan.plugin.internal.k;
import com.gradle.scan.plugin.internal.m.b;
import com.gradle.scan.plugin.internal.meta.CurrentPluginVersion;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.specs.Specs;
import org.gradle.internal.logging.text.StyledTextOutput;

public final class DefaultBuildScanPluginImplementation
implements BuildScanPluginImplementation {
    public static final String a = "buildScan";
    public static final String b = "buildScanPublishPrevious";
    public static final String c = "A build scan will not be published due to this build running offline.";
    public static final String d = "scan.capture-task-input-files";
    private static final String e = "scan.dump";
    private static final String f = "scan.quiet";
    private static final String g = "scan.quiet.error";
    private static final String h = "scan.trigger-attach-capturers-error";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@Nonnull Project project) {
        Gradle gradle = project.getGradle();
        boolean isTopLevelBuild = gradle.getParent() == null;
        com.gradle.scan.b.a.a gradleVersion = com.gradle.scan.b.a.a.a(gradle.getGradleVersion());
        com.gradle.scan.b.a.b pluginVersion = com.gradle.scan.b.a.b.a(CurrentPluginVersion.get());
        j.a();
        DefaultBuildScanPluginImplementation.b(project);
        DefaultBuildScanPluginImplementation.c(project);
        DefaultBuildScanPluginImplementation.a(gradleVersion, pluginVersion);
        if (DefaultBuildScanPluginImplementation.a(project)) {
            return;
        }
        h problemReporter = com.gradle.scan.plugin.internal.h.a(gradle);
        com.gradle.scan.plugin.internal.h.c logging = DefaultBuildScanPluginImplementation.a(gradle, project);
        com.gradle.scan.plugin.internal.api.c buildFinishedActions = new com.gradle.scan.plugin.internal.api.c(problemReporter);
        f buildScanPublishedActions = new f(problemReporter);
        com.gradle.scan.plugin.internal.api.d buildScanErrorActions = new com.gradle.scan.plugin.internal.api.d(problemReporter);
        l termsOfServiceAgreement = l.a(gradle, logging);
        com.gradle.scan.plugin.internal.i.b obfuscators = new com.gradle.scan.plugin.internal.i.b(problemReporter);
        com.gradle.scan.plugin.internal.api.g buildScanServer = new com.gradle.scan.plugin.internal.api.g();
        com.gradle.scan.plugin.internal.api.k publishArbiter = new com.gradle.scan.plugin.internal.api.k();
        com.gradle.scan.plugin.internal.api.a backgroundExecController = new com.gradle.scan.plugin.internal.api.a();
        com.gradle.scan.plugin.internal.b.b checkInResult = null;
        boolean recording = false;
        if (isTopLevelBuild) {
            checkInResult = com.gradle.scan.plugin.internal.b.a.a(gradle, pluginVersion);
            recording = DefaultBuildScanPluginImplementation.a(project, checkInResult, problemReporter);
        }
        if (!isTopLevelBuild || !recording) {
            com.gradle.scan.plugin.internal.a.x.b userDataCapturer = com.gradle.scan.plugin.internal.a.x.c.a();
            final com.gradle.scan.plugin.internal.api.j extensionController = this.a(project, problemReporter, userDataCapturer, obfuscators, buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, termsOfServiceAgreement, buildScanServer, publishArbiter, backgroundExecController);
            gradle.addBuildListener((BuildListener)new BuildAdapter(){

                public void buildFinished(org.gradle.BuildResult result) {
                    extensionController.a();
                }
            });
            return;
        }
        b scanRequest = com.gradle.scan.plugin.internal.m.b.a(checkInResult);
        com.gradle.scan.plugin.internal.m.a.a(gradle, problemReporter);
        DefaultBuildScanPluginImplementation.a(scanRequest, publishArbiter);
        com.gradle.scan.plugin.internal.o.a worker = new com.gradle.scan.plugin.internal.o.a();
        com.gradle.scan.plugin.internal.e.a.a eventClock = com.gradle.scan.plugin.internal.e.a.a.a(gradle);
        com.gradle.scan.plugin.internal.e.c.a eventStreamSpooler = DefaultBuildScanPluginImplementation.a(gradle, pluginVersion);
        com.gradle.scan.plugin.internal.e.a eventSink = new com.gradle.scan.plugin.internal.e.a(eventStreamSpooler);
        com.gradle.scan.plugin.internal.a.m.a memoryMonitor = com.gradle.scan.plugin.internal.a.m.a.a();
        com.gradle.scan.plugin.internal.a.j.b systemInfo = com.gradle.scan.plugin.internal.a.j.b.g();
        com.gradle.scan.plugin.internal.a.i.a fileRefFactory = com.gradle.scan.plugin.internal.a.i.a.a(gradle);
        com.gradle.scan.plugin.internal.a.x.a userDataExclusionTracker = new com.gradle.scan.plugin.internal.a.x.a(problemReporter);
        com.gradle.scan.plugin.internal.a.x.b userDataCapturer = com.gradle.scan.plugin.internal.a.x.c.a(worker, eventClock, eventSink, userDataExclusionTracker);
        com.gradle.scan.plugin.internal.e.b.a store = new com.gradle.scan.plugin.internal.e.b.a(DefaultBuildScanPluginImplementation.b(gradle, pluginVersion));
        com.gradle.scan.plugin.internal.c.a dumpController = new com.gradle.scan.plugin.internal.c.a(project.getRootDir(), logging, gradleVersion, pluginVersion);
        com.gradle.scan.plugin.internal.k.e rawController = com.gradle.scan.plugin.internal.k.b.a(logging, buildScanServer, gradleVersion, pluginVersion);
        com.gradle.scan.plugin.internal.k.i publishController = new com.gradle.scan.plugin.internal.k.i(rawController, () -> DefaultBuildScanPluginImplementation.a(termsOfServiceAgreement, buildScanServer, (com.gradle.scan.plugin.internal.h.e)logging));
        com.gradle.scan.plugin.internal.a.h.a exceptionDataStore = new com.gradle.scan.plugin.internal.a.h.a(fileRefFactory);
        com.gradle.scan.plugin.internal.api.j extensionController = this.a(project, problemReporter, userDataCapturer, obfuscators, buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, termsOfServiceAgreement, buildScanServer, publishArbiter, backgroundExecController);
        String buildScanPublishPreviousTaskPath = DefaultBuildScanPluginImplementation.a(project, store, dumpController, publishController, buildScanPublishedActions);
        gradle.getTaskGraph().addTaskExecutionGraphListener(taskExecutionGraph -> {
            if (taskExecutionGraph.hasTask(buildScanPublishPreviousTaskPath)) {
                publishArbiter.a();
            }
        });
        com.gradle.scan.plugin.internal.a.p.a.e pluginMetadataExtractor = com.gradle.scan.plugin.internal.a.p.a.e.a(project, gradleVersion);
        com.gradle.scan.plugin.internal.a buildScanPluginsTracker = new com.gradle.scan.plugin.internal.a(pluginMetadataExtractor);
        com.gradle.scan.plugin.internal.a.f.h configurationResolutionDataStore = new com.gradle.scan.plugin.internal.a.f.h(exceptionDataStore);
        com.gradle.scan.plugin.internal.a.g.d deprecatedUsageTraceDataStore = new com.gradle.scan.plugin.internal.a.g.d(fileRefFactory);
        try {
            com.gradle.scan.plugin.internal.a.v.a.a captureTaskInputFilesSwitch = DefaultBuildScanPluginImplementation.a(project, problemReporter, systemInfo, fileRefFactory, worker, eventSink, eventClock, userDataCapturer, publishArbiter, exceptionDataStore, pluginMetadataExtractor, buildScanPluginsTracker, configurationResolutionDataStore, deprecatedUsageTraceDataStore);
            DefaultBuildScanPluginImplementation.a(project, worker, eventClock, systemInfo, extensionController, captureTaskInputFilesSwitch);
        }
        finally {
            DefaultBuildScanPluginImplementation.a(project, problemReporter, worker, eventSink, eventClock, eventStreamSpooler, store, systemInfo, memoryMonitor, userDataExclusionTracker, obfuscators, buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, dumpController, publishController, publishArbiter, extensionController, buildScanPluginsTracker, configurationResolutionDataStore, logging, exceptionDataStore, deprecatedUsageTraceDataStore);
        }
    }

    private static void a(Project project, com.gradle.scan.plugin.internal.o.b worker, com.gradle.scan.plugin.internal.e.a.a eventClock, com.gradle.scan.plugin.internal.a.j.b systemInfo, com.gradle.scan.plugin.internal.api.j extensionController, com.gradle.scan.plugin.internal.a.v.a.a captureTaskInputFilesSwitch) {
        project.afterEvaluate(ignore -> {
            extensionController.b();
            com.gradle.scan.plugin.internal.e.a.c timestamp = eventClock.a();
            e.a setting = extensionController.b.a();
            worker.a(() -> {
                switch (setting) {
                    case UNSPECIFIED: 
                    case DISABLED_BY_API: 
                    case DISABLED_BY_ENV: {
                        captureTaskInputFilesSwitch.b(timestamp);
                        break;
                    }
                    case ENABLED_BY_API: 
                    case ENABLED_BY_ENV: {
                        captureTaskInputFilesSwitch.a(timestamp);
                    }
                }
            });
        });
        Properties systemProperties = systemInfo.b();
        if (systemProperties.containsKey(d)) {
            String value = systemProperties.getProperty(d);
            if (value.equals("false")) {
                extensionController.b.c();
            } else {
                extensionController.b.b();
            }
        }
    }

    private com.gradle.scan.plugin.internal.api.j a(@Nonnull Project project, h problemReporter, com.gradle.scan.plugin.internal.a.x.b userDataCapturer, com.gradle.scan.plugin.internal.i.b obfuscators, com.gradle.scan.plugin.internal.api.c buildFinishedActions, f buildScanPublishedActions, com.gradle.scan.plugin.internal.api.d buildScanErrorActions, l termsOfServiceAgreement, com.gradle.scan.plugin.internal.api.g buildScanServer, com.gradle.scan.plugin.internal.api.k publishArbiter, com.gradle.scan.plugin.internal.api.a backgroundExecController) {
        com.gradle.scan.plugin.internal.api.h rawExtension = new com.gradle.scan.plugin.internal.api.h(userDataCapturer, obfuscators.c(), buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, termsOfServiceAgreement, buildScanServer, publishArbiter, backgroundExecController);
        com.gradle.scan.plugin.internal.api.j extensionController = new com.gradle.scan.plugin.internal.api.j(rawExtension, problemReporter, backgroundExecController);
        project.getExtensions().create(a, com.gradle.scan.plugin.internal.api.i.class, new Object[]{extensionController.a});
        return extensionController;
    }

    private static boolean a(Project project) {
        return project.getPlugins().stream().anyMatch(plugin -> plugin.getClass().getName().equals(BuildScanPlugin.class.getName()));
    }

    private static com.gradle.scan.plugin.internal.h.c a(Gradle gradle, Project project) {
        if (DefaultBuildScanPluginImplementation.a(f, project) || DefaultBuildScanPluginImplementation.a(gradle)) {
            return new com.gradle.scan.plugin.internal.h.d();
        }
        boolean suppressError = DefaultBuildScanPluginImplementation.a(g, project);
        return new com.gradle.scan.plugin.internal.h.a(com.gradle.scan.plugin.internal.h.b.a(gradle), !suppressError);
    }

    private static boolean a(Gradle gradle) {
        return gradle.getStartParameter().getLogLevel().equals((Object)LogLevel.QUIET);
    }

    private static boolean a(Project project, com.gradle.scan.plugin.internal.b.b checkInResult, h problemReporter) {
        Gradle gradle = project.getGradle();
        if (!checkInResult.e()) {
            return false;
        }
        String unsupportedMessage = checkInResult.c();
        if (unsupportedMessage != null) {
            problemReporter.a(unsupportedMessage);
            return false;
        }
        if (DefaultBuildScanPluginImplementation.b(gradle)) {
            DefaultBuildScanPluginImplementation.a(problemReporter);
            return false;
        }
        if (DefaultBuildScanPluginImplementation.a(checkInResult)) {
            problemReporter.a("Build scan data will not be captured due to this build containing VCS mappings.");
            return false;
        }
        return true;
    }

    private static void a(h problemReporter) {
        problemReporter.a("Build scan data will not be captured due to this build being part of a Continuous Build.");
    }

    private static void a(b scanRequest, com.gradle.scan.plugin.internal.api.k publishArbiter) {
        switch (scanRequest) {
            case ENABLED: {
                publishArbiter.b();
                break;
            }
            case DISABLED: {
                publishArbiter.d();
            }
        }
    }

    private static boolean b(Gradle gradle) {
        return gradle.getStartParameter().isContinuous();
    }

    private static boolean a(com.gradle.scan.plugin.internal.b.b checkInResult) {
        return checkInResult.d();
    }

    private static com.gradle.scan.plugin.internal.e.c.a a(Gradle gradle, com.gradle.scan.b.a.b pluginVersion) {
        try {
            String id = UUID.randomUUID().toString();
            File scanFile = new File(DefaultBuildScanPluginImplementation.b(gradle, pluginVersion), String.format("spool/%s.scan", id));
            return new com.gradle.scan.plugin.internal.e.c.c(scanFile);
        }
        catch (IOException e2) {
            throw new BuildScanException("Failed to create build scan data file.", e2);
        }
    }

    private static File b(Gradle gradle, com.gradle.scan.b.a.b pluginVersion) {
        return new File(gradle.getGradleUserHomeDir(), "build-scan-data/" + pluginVersion.e().j());
    }

    private static com.gradle.scan.plugin.internal.a.v.a.a a(Project project, h problemReporter, com.gradle.scan.plugin.internal.a.j.b systemInfo, com.gradle.scan.plugin.internal.a.i.a fileRefFactory, com.gradle.scan.plugin.internal.o.b worker, com.gradle.scan.plugin.internal.e.b eventSink, com.gradle.scan.plugin.internal.e.a.a eventClock, com.gradle.scan.plugin.internal.a.x.b userDataCapturer, com.gradle.scan.plugin.internal.api.k publishArbiter, com.gradle.scan.plugin.internal.a.h.a exceptionDataStore, com.gradle.scan.plugin.internal.a.p.a.e pluginMetadataExtractor, com.gradle.scan.plugin.internal.a buildScanPluginsTracker, com.gradle.scan.plugin.internal.a.f.h configurationResolutionDataStore, com.gradle.scan.plugin.internal.a.g.d deprecatedUsageTraceDataStore) {
        com.gradle.scan.plugin.internal.a.v.a.a captureTaskInputFilesSwitch = null;
        try {
            DefaultBuildScanPluginImplementation.a(worker, eventClock, eventSink, project, systemInfo, fileRefFactory);
            captureTaskInputFilesSwitch = DefaultBuildScanPluginImplementation.a(worker, eventSink, eventClock, project, publishArbiter, fileRefFactory, pluginMetadataExtractor, buildScanPluginsTracker, configurationResolutionDataStore, problemReporter, exceptionDataStore, deprecatedUsageTraceDataStore);
        }
        catch (Throwable e2) {
            worker.a(e2);
        }
        com.gradle.scan.plugin.internal.a.j.c.a(systemInfo.b(), userDataCapturer);
        return captureTaskInputFilesSwitch;
    }

    private static void a(com.gradle.scan.plugin.internal.o.b worker, com.gradle.scan.plugin.internal.e.a.a eventClock, com.gradle.scan.plugin.internal.e.b eventSink, Project project, com.gradle.scan.plugin.internal.a.j.b systemInfo, com.gradle.scan.plugin.internal.a.i.a fileRefFactory) {
        Gradle gradle = project.getGradle();
        com.gradle.scan.plugin.internal.a.e.b daemonScanInfoService = com.gradle.scan.plugin.internal.a.e.b.a(gradle);
        com.gradle.scan.plugin.internal.e.a.c buildStartTime = com.gradle.scan.plugin.internal.a.d.a.a(gradle, eventClock);
        worker.a(() -> {
            com.gradle.scan.plugin.internal.a.e.a.a(worker, eventSink, eventClock, buildStartTime, daemonScanInfoService);
            com.gradle.scan.plugin.internal.a.j.a.a(eventSink, buildStartTime, project, systemInfo, daemonScanInfoService);
            com.gradle.scan.plugin.internal.a.i.b.a(eventSink, buildStartTime, fileRefFactory.a());
            com.gradle.scan.plugin.internal.a.s.a.a(eventSink, buildStartTime, gradle);
        });
    }

    private static com.gradle.scan.plugin.internal.a.v.a.a a(com.gradle.scan.plugin.internal.o.b worker, com.gradle.scan.plugin.internal.e.b eventSink, com.gradle.scan.plugin.internal.e.a.a eventClock, Project project, com.gradle.scan.plugin.internal.api.k publishArbiter, com.gradle.scan.plugin.internal.a.i.a fileRefFactory, com.gradle.scan.plugin.internal.a.p.a.e pluginMetadataExtractor, com.gradle.scan.plugin.internal.a buildScanPluginsTracker, com.gradle.scan.plugin.internal.a.f.h configurationResolutionDataStore, h problemReporter, com.gradle.scan.plugin.internal.a.h.a exceptionDataStore, com.gradle.scan.plugin.internal.a.g.d deprecatedUsageTraceDataStore) {
        if (Boolean.getBoolean(h)) {
            throw new Error("Synthetic attach capturers error");
        }
        Gradle gradle = project.getGradle();
        return com.gradle.scan.plugin.internal.j.c.a(worker, eventClock, gradle, (? super e operations) -> {
            com.gradle.scan.plugin.internal.f.h<com.gradle.scan.plugin.internal.a.v.g, Long> taskIdStore = DefaultBuildScanPluginImplementation.a();
            com.gradle.scan.plugin.internal.a.l.a codeUnitApplicationRefStore = new com.gradle.scan.plugin.internal.a.l.a();
            com.gradle.scan.plugin.internal.g.a.a(publishArbiter, problemReporter, operations);
            com.gradle.scan.plugin.internal.a.r.a.a(eventSink, project, fileRefFactory, operations);
            com.gradle.scan.plugin.internal.a.k.a.a(eventSink, operations);
            com.gradle.scan.plugin.internal.a.c.b.a(eventSink, operations);
            com.gradle.scan.plugin.internal.a.n.a.a(eventSink, operations, exceptionDataStore);
            com.gradle.scan.plugin.internal.a.v.d.a(eventSink, operations);
            com.gradle.scan.plugin.internal.a.v.a.a(eventSink, taskIdStore, operations);
            com.gradle.scan.plugin.internal.a.v.a.a captureSwitch = com.gradle.scan.plugin.internal.a.v.a.g.a(eventSink, fileRefFactory, operations);
            com.gradle.scan.plugin.internal.a.w.e.a(eventSink, operations, exceptionDataStore);
            com.gradle.scan.plugin.internal.a.o.a.a(eventSink, operations, exceptionDataStore);
            com.gradle.scan.plugin.internal.a.a.a.a(eventSink, operations);
            com.gradle.scan.plugin.internal.a.p.a.a(eventSink, project, pluginMetadataExtractor, buildScanPluginsTracker, operations, codeUnitApplicationRefStore);
            com.gradle.scan.plugin.internal.a.t.a.a(eventSink, fileRefFactory, operations, codeUnitApplicationRefStore);
            com.gradle.scan.plugin.internal.a.l.b.a(eventSink, operations, codeUnitApplicationRefStore);
            com.gradle.scan.plugin.internal.a.q.a.a(eventSink, operations, exceptionDataStore);
            com.gradle.scan.plugin.internal.a.f.e.a(eventSink, project, configurationResolutionDataStore, fileRefFactory, operations);
            com.gradle.scan.plugin.internal.a.b.c.a(eventSink, operations);
            com.gradle.scan.plugin.internal.a.b.a.a(eventSink, operations, exceptionDataStore);
            com.gradle.scan.plugin.internal.a.g.a.a(eventSink, operations, deprecatedUsageTraceDataStore);
            com.gradle.scan.plugin.internal.a.t.d.a(eventSink, operations);
            return captureSwitch;
        });
    }

    private static com.gradle.scan.plugin.internal.f.h<com.gradle.scan.plugin.internal.a.v.g, Long> a() {
        return com.gradle.scan.plugin.internal.f.b.b();
    }

    private static void a(Project project, h problemReporter, com.gradle.scan.plugin.internal.o.b worker, com.gradle.scan.plugin.internal.e.b eventSink, com.gradle.scan.plugin.internal.e.a.a eventClock, com.gradle.scan.plugin.internal.e.c.a eventStreamSpooler, com.gradle.scan.plugin.internal.e.b.b store, com.gradle.scan.plugin.internal.a.j.b systemInfo, com.gradle.scan.plugin.internal.a.m.a memoryMonitor, d userDataExclusionTracker, com.gradle.scan.plugin.internal.i.b obfuscators, com.gradle.scan.plugin.internal.api.c buildFinishedActions, f buildScanPublishedActions, com.gradle.scan.plugin.internal.api.d buildScanErrorActions, com.gradle.scan.plugin.internal.c.b dumpController, com.gradle.scan.plugin.internal.k.e publishController, com.gradle.scan.plugin.internal.api.k publishArbiter, com.gradle.scan.plugin.internal.api.j extensionController, com.gradle.scan.plugin.internal.a buildScanPluginsTracker, com.gradle.scan.plugin.internal.a.f.h configurationResolutionDataStore, com.gradle.scan.plugin.internal.h.e styledLogger, com.gradle.scan.plugin.internal.a.h.a exceptionDataStore, com.gradle.scan.plugin.internal.a.g.d deprecatedUsageTraceDataStore) {
        Gradle gradle = project.getGradle();
        com.gradle.scan.plugin.internal.d.a.a(gradle, (Action<? super BuildResult>)((Action)result -> {
            boolean discard;
            buildFinishedActions.a(result);
            extensionController.a();
            worker.b(() -> {
                DefaultBuildScanPluginImplementation.a(buildScanPluginsTracker, problemReporter);
                if (!publishArbiter.e()) {
                    userDataExclusionTracker.a();
                }
            });
            worker.b(() -> {
                com.gradle.scan.plugin.internal.a.f.g.a(eventSink, eventClock, configurationResolutionDataStore);
                com.gradle.scan.plugin.internal.a.c.a(eventSink, eventClock, systemInfo, obfuscators, result, memoryMonitor, exceptionDataStore, deprecatedUsageTraceDataStore);
            });
            long buildFinishedTimestamp = eventClock.a().a;
            com.gradle.scan.plugin.internal.e.c.b spooling = DefaultBuildScanPluginImplementation.a(worker, eventStreamSpooler);
            boolean bl = discard = spooling.d() || publishArbiter.e();
            if (discard) {
                DefaultBuildScanPluginImplementation.a(spooling.c());
                if (spooling.d()) {
                    publishController.a(spooling);
                    styledLogger.a("");
                }
            } else {
                if (gradle.getStartParameter().isOffline()) {
                    problemReporter.a(c);
                    publishArbiter.d();
                }
                boolean shouldPromote = true;
                if (DefaultBuildScanPluginImplementation.a(e, project)) {
                    dumpController.a(buildFinishedTimestamp, spooling.c());
                } else if (publishArbiter.a((BuildResult)result)) {
                    com.gradle.scan.plugin.internal.k.g publishResult = publishController.a(spooling);
                    if (publishResult.b()) {
                        shouldPromote = false;
                        buildScanPublishedActions.a(publishResult.a);
                    } else if (publishResult.c()) {
                        String errorMessage;
                        try {
                            errorMessage = publishResult.b.a();
                        }
                        catch (IOException e2) {
                            errorMessage = e2.getMessage();
                        }
                        buildScanErrorActions.a(errorMessage);
                    }
                    styledLogger.a("");
                }
                if (shouldPromote) {
                    DefaultBuildScanPluginImplementation.a(buildFinishedTimestamp, spooling.c(), store, styledLogger);
                }
            }
        }));
    }

    private static void a(com.gradle.scan.plugin.internal.e.c events) {
        if (events != null) {
            try {
                events.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void a(long timestamp, com.gradle.scan.plugin.internal.e.c events, com.gradle.scan.plugin.internal.e.b.b store, com.gradle.scan.plugin.internal.h.e logger) {
        if (events != null) {
            try {
                store.a(timestamp, events);
                events.close();
            }
            catch (Exception e2) {
                logger.a(StyledTextOutput.Style.Failure, "Unable to store build scan data: " + e2.getMessage());
            }
        }
    }

    private static boolean a(l termsOfServiceAgreement, com.gradle.scan.plugin.internal.api.g buildScanServer, com.gradle.scan.plugin.internal.h.e logger) {
        String errorMsg = buildScanServer.a();
        if (errorMsg == null && buildScanServer.e()) {
            termsOfServiceAgreement.b();
            errorMsg = termsOfServiceAgreement.a();
        }
        if (errorMsg == null) {
            return true;
        }
        logger.a("");
        logger.a(StyledTextOutput.Style.Failure, "The build scan was not published due to a configuration problem.");
        logger.a("");
        logger.a(errorMsg);
        return false;
    }

    private static String a(Project project, com.gradle.scan.plugin.internal.e.b.b store, com.gradle.scan.plugin.internal.c.b dumpController, com.gradle.scan.plugin.internal.k.e publishController, f buildScanPublishedActions) {
        g previousBuildHandler = DefaultBuildScanPluginImplementation.a(e, project) ? new com.gradle.scan.plugin.internal.c.c(store, dumpController) : new com.gradle.scan.plugin.internal.k.d(store, publishController, buildScanPublishedActions);
        i.a(project.getTasks(), b, com.gradle.scan.plugin.internal.k.a.class, task -> {
            task.setGroup("Build scan");
            task.setDescription("Publishes the data captured by the last build to the build scan server.");
            task.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
            task.getExtensions().add(g.class.getName(), (Object)previousBuildHandler);
        });
        return project.getPath() + b;
    }

    private static boolean a(String propName, Project project) {
        return project.getGradle().getStartParameter().getSystemPropertiesArgs().containsKey(propName);
    }

    private static void b(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new BuildScanException("The build scan plugin can only be applied to the root project.");
        }
    }

    private static void c(Project rootProject) {
        if (rootProject.getState().getExecuted()) {
            throw new BuildScanException(k.a("The build scan plugin must be applied early in the build lifecycle.", "Fixing this problem requires changing how you are applying the build scan plugin to your build.", "", "Please see https://gradle.com/scans/help/plugin-late-apply for how to resolve this problem."));
        }
    }

    private static void a(com.gradle.scan.b.a.a gradleVersion, com.gradle.scan.b.a.b pluginVersion) {
        if (!gradleVersion.a(com.gradle.scan.plugin.internal.n.a.a)) {
            throw new UnsupportedGradleVersionException(k.a("Build scans are not supported for Gradle 1.x.", "Please use a newer version of Gradle."));
        }
        if (!gradleVersion.a(com.gradle.scan.plugin.internal.n.a.c)) {
            throw new UnsupportedGradleVersionException(k.a("Version " + pluginVersion.j() + " of the build scan plugin requires Gradle 5.0 or later.", "You are currently using Gradle " + gradleVersion.i() + ".", "Please upgrade to a later version of Gradle or use build scan plugin 1.16."));
        }
    }

    private static void a(com.gradle.scan.plugin.internal.a tracker, h problemReporter) {
        Set<String> allVersions = tracker.a();
        if (allVersions.size() > 1) {
            problemReporter.a(k.a("", "WARNING: Several versions of the build scan plugin were applied: [" + k.b(allVersions, ", ") + "].", "The build scan data was captured by version [" + tracker.b() + "].", "This is often caused by multiple init scripts and/or build scripts applying the plugin."));
        }
    }

    private static com.gradle.scan.plugin.internal.e.c.b a(com.gradle.scan.plugin.internal.o.b worker, com.gradle.scan.plugin.internal.e.c.a spooler) {
        List<Throwable> errors;
        Throwable spoolerError = null;
        com.gradle.scan.plugin.internal.e.c events = null;
        try {
            events = worker.a(spooler::a);
        }
        catch (InterruptedException e2) {
            throw new IllegalStateException("Error waiting for build scan event spooler to finish");
        }
        catch (Throwable t) {
            spoolerError = t;
        }
        try {
            errors = worker.b();
        }
        catch (Exception e3) {
            throw new IllegalStateException("Error waiting for build scan worker to stop", e3);
        }
        if (spoolerError != null) {
            return com.gradle.scan.plugin.internal.e.c.b.a(spoolerError);
        }
        if (!errors.isEmpty()) {
            if (events != null) {
                k.a(events);
            }
            return com.gradle.scan.plugin.internal.e.c.b.a(errors);
        }
        return com.gradle.scan.plugin.internal.e.c.b.a(events);
    }
}

