/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin;

import com.gradle.scan.plugin.BuildScanException;
import com.gradle.scan.plugin.UnsupportedGradleVersionException;
import com.gradle.scan.plugin.internal.a.d;
import com.gradle.scan.plugin.internal.a.d.a;
import com.gradle.scan.plugin.internal.a.w.f;
import com.gradle.scan.plugin.internal.d.a.b;
import com.gradle.scan.plugin.internal.d.c.c;
import com.gradle.scan.plugin.internal.e.h;
import com.gradle.scan.plugin.internal.e.i;
import com.gradle.scan.plugin.internal.i.e;
import com.gradle.scan.plugin.internal.i.g;
import com.gradle.scan.plugin.internal.j;
import com.gradle.scan.plugin.internal.j.i;
import com.gradle.scan.plugin.internal.k;
import com.gradle.scan.plugin.internal.meta.CurrentPluginVersion;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.specs.Specs;
import org.gradle.internal.logging.text.StyledTextOutput;

public final class BuildScanPlugin
implements Plugin<Project> {
    public static final String a = "buildScan";
    public static final String b = "buildScanPublishPrevious";
    public static final String c = "A build scan will not be published due to this build running offline.";
    private static final String d = "scan.dump";
    private static final String e = "scan.quiet";
    private static final String f = "scan.quiet.error";
    private static final String g = "scan.trigger-attach-capturers-error";

    public void apply(@Nonnull Project project) {
        com.gradle.scan.plugin.internal.a.x.b userDataCapturer;
        com.gradle.scan.plugin.internal.a.x.d userDataExclusionTracker;
        Gradle gradle = project.getGradle();
        boolean isTopLevelBuild = gradle.getParent() == null;
        com.gradle.scan.b.a.a gradleVersion = com.gradle.scan.b.a.a.a(gradle.getGradleVersion());
        com.gradle.scan.b.a.b pluginVersion = com.gradle.scan.b.a.b.a(CurrentPluginVersion.get());
        j.a();
        BuildScanPlugin.b(project);
        BuildScanPlugin.c(project);
        BuildScanPlugin.a(gradleVersion, pluginVersion);
        if (BuildScanPlugin.a(project)) {
            return;
        }
        com.gradle.scan.plugin.internal.a.m.a memoryMonitor = com.gradle.scan.plugin.internal.a.m.a.a();
        com.gradle.scan.plugin.internal.h problemReporter = com.gradle.scan.plugin.internal.h.a(gradle);
        com.gradle.scan.plugin.internal.a.j.b systemInfo = com.gradle.scan.plugin.internal.a.j.b.g();
        com.gradle.scan.plugin.internal.a.i.a fileRefFactory = com.gradle.scan.plugin.internal.a.i.a.a(gradle);
        final com.gradle.scan.plugin.internal.g.c logging = BuildScanPlugin.a(gradle, project);
        com.gradle.scan.plugin.internal.b.b checkInResult = com.gradle.scan.plugin.internal.b.a.a(gradle, pluginVersion, isTopLevelBuild);
        com.gradle.scan.plugin.internal.l.b scanRequest = isTopLevelBuild ? com.gradle.scan.plugin.internal.l.b.a(checkInResult) : null;
        com.gradle.scan.plugin.internal.l.a.a(gradle, problemReporter);
        boolean recording = isTopLevelBuild && BuildScanPlugin.a(project, checkInResult, problemReporter);
        com.gradle.scan.plugin.internal.d.b eventSink = null;
        if (recording) {
            eventSink = BuildScanPlugin.a(project.getGradle(), pluginVersion);
            userDataExclusionTracker = new com.gradle.scan.plugin.internal.a.x.a(problemReporter);
            userDataCapturer = com.gradle.scan.plugin.internal.a.x.c.a(eventSink, userDataExclusionTracker);
        } else {
            userDataCapturer = com.gradle.scan.plugin.internal.a.x.c.a();
            userDataExclusionTracker = com.gradle.scan.plugin.internal.a.x.d.a;
        }
        com.gradle.scan.plugin.internal.h.b obfuscators = new com.gradle.scan.plugin.internal.h.b(problemReporter);
        final com.gradle.scan.plugin.internal.a buildFinishedWatcher = new com.gradle.scan.plugin.internal.a();
        com.gradle.scan.plugin.internal.api.c buildFinishedActions = new com.gradle.scan.plugin.internal.api.c(problemReporter);
        com.gradle.scan.plugin.internal.api.e buildScanPublishedActions = new com.gradle.scan.plugin.internal.api.e(problemReporter);
        com.gradle.scan.plugin.internal.api.d buildScanErrorActions = new com.gradle.scan.plugin.internal.api.d(problemReporter);
        final com.gradle.scan.plugin.internal.api.k termsOfServiceAgreement = com.gradle.scan.plugin.internal.api.k.a(gradle, logging);
        final com.gradle.scan.plugin.internal.api.f buildScanServer = new com.gradle.scan.plugin.internal.api.f();
        final com.gradle.scan.plugin.internal.api.j publishArbiter = new com.gradle.scan.plugin.internal.api.j();
        com.gradle.scan.plugin.internal.api.a backgroundExecController = new com.gradle.scan.plugin.internal.api.a();
        com.gradle.scan.plugin.internal.api.g rawExtension = new com.gradle.scan.plugin.internal.api.g(userDataCapturer, obfuscators.c(), buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, termsOfServiceAgreement, buildScanServer, publishArbiter, backgroundExecController);
        final com.gradle.scan.plugin.internal.api.i extensionController = new com.gradle.scan.plugin.internal.api.i(rawExtension, problemReporter, backgroundExecController);
        project.getExtensions().create(a, com.gradle.scan.plugin.internal.api.h.class, new Object[]{extensionController.a});
        com.gradle.scan.plugin.internal.d.b.a store = new com.gradle.scan.plugin.internal.d.b.a(BuildScanPlugin.c(gradle, pluginVersion));
        com.gradle.scan.plugin.internal.c.a dumpController = new com.gradle.scan.plugin.internal.c.a(project.getRootDir(), logging, gradleVersion, pluginVersion);
        com.gradle.scan.plugin.internal.j.e rawController = com.gradle.scan.plugin.internal.j.b.a(logging, buildScanServer, gradleVersion, pluginVersion);
        com.gradle.scan.plugin.internal.j.i publishController = new com.gradle.scan.plugin.internal.j.i(rawController, new i.a(){

            @Override
            public boolean a() {
                return BuildScanPlugin.b(termsOfServiceAgreement, buildScanServer, logging);
            }
        });
        final String buildScanPublishPreviousTaskPath = BuildScanPlugin.a(project, store, dumpController, publishController, buildScanPublishedActions);
        gradle.getTaskGraph().addTaskExecutionGraphListener(new TaskExecutionGraphListener(){

            public void graphPopulated(@Nonnull TaskExecutionGraph taskExecutionGraph) {
                if (taskExecutionGraph.hasTask(buildScanPublishPreviousTaskPath)) {
                    publishArbiter.a();
                }
            }
        });
        if (recording) {
            com.gradle.scan.plugin.internal.a.h.a exceptionDataStore = new com.gradle.scan.plugin.internal.a.h.a(fileRefFactory);
            BuildScanPlugin.a(scanRequest, publishArbiter);
            BuildScanPlugin.a(project, gradleVersion, problemReporter, systemInfo, fileRefFactory, eventSink, store, userDataCapturer, userDataExclusionTracker, memoryMonitor, obfuscators, buildFinishedWatcher, buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, dumpController, publishController, publishArbiter, extensionController, logging, exceptionDataStore);
        } else {
            gradle.addBuildListener((BuildListener)new BuildAdapter(){

                public void buildFinished(BuildResult result) {
                    extensionController.a();
                    buildFinishedWatcher.a();
                }
            });
        }
    }

    private static boolean a(Project project) {
        for (Plugin plugin : project.getPlugins()) {
            if (!plugin.getClass().getName().equals(BuildScanPlugin.class.getName())) continue;
            return true;
        }
        return false;
    }

    private static com.gradle.scan.plugin.internal.g.c a(Gradle gradle, Project project) {
        if (BuildScanPlugin.b(e, project) || BuildScanPlugin.a(gradle)) {
            return new com.gradle.scan.plugin.internal.g.d();
        }
        boolean suppressError = BuildScanPlugin.b(f, project);
        return new com.gradle.scan.plugin.internal.g.a(com.gradle.scan.plugin.internal.g.b.a(gradle), !suppressError);
    }

    private static boolean a(Gradle gradle) {
        return gradle.getStartParameter().getLogLevel().equals((Object)LogLevel.QUIET);
    }

    private static boolean a(Project project, com.gradle.scan.plugin.internal.b.b checkInResult, com.gradle.scan.plugin.internal.h problemReporter) {
        Gradle gradle = project.getGradle();
        String unsupportedMessage = checkInResult.c();
        if (unsupportedMessage != null) {
            problemReporter.a(unsupportedMessage);
            return false;
        }
        if (BuildScanPlugin.b(gradle)) {
            BuildScanPlugin.a(problemReporter);
            return false;
        }
        if (BuildScanPlugin.a(checkInResult)) {
            problemReporter.a("Build scan data will not be captured due to this build containing VCS mappings.");
            return false;
        }
        return true;
    }

    private static void a(com.gradle.scan.plugin.internal.h problemReporter) {
        problemReporter.a("Build scan data will not be captured due to this build being part of a Continuous Build.");
    }

    private static void a(com.gradle.scan.plugin.internal.l.b scanRequest, com.gradle.scan.plugin.internal.api.j publishArbiter) {
        switch (scanRequest) {
            case ENABLED: {
                publishArbiter.b();
                break;
            }
            case DISABLED: {
                publishArbiter.d();
            }
        }
    }

    private static boolean b(Gradle gradle) {
        return gradle.getStartParameter().isContinuous();
    }

    private static boolean a(com.gradle.scan.plugin.internal.b.b checkInResult) {
        return checkInResult.d();
    }

    private static com.gradle.scan.plugin.internal.d.b a(Gradle gradle, com.gradle.scan.b.a.b pluginVersion) {
        com.gradle.scan.plugin.internal.d.c.a spooler;
        try {
            spooler = BuildScanPlugin.b(gradle, pluginVersion);
        }
        catch (IOException e2) {
            throw new BuildScanException("Failed to create build scan data file.", e2);
        }
        com.gradle.scan.plugin.internal.d.a.a eventClock = com.gradle.scan.plugin.internal.d.a.b.a(gradle);
        return new com.gradle.scan.plugin.internal.d.b(eventClock, spooler);
    }

    private static com.gradle.scan.plugin.internal.d.c.a b(Gradle gradle, com.gradle.scan.b.a.b pluginVersion) throws IOException {
        String id = UUID.randomUUID().toString();
        File scanFile = new File(BuildScanPlugin.c(gradle, pluginVersion), String.format("spool/%s.scan", id));
        return new c(scanFile);
    }

    private static File c(Gradle gradle, com.gradle.scan.b.a.b pluginVersion) {
        return new File(gradle.getGradleUserHomeDir(), "build-scan-data/" + pluginVersion.b().g());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(Project project, com.gradle.scan.b.a.a gradleVersion, com.gradle.scan.plugin.internal.h problemReporter, com.gradle.scan.plugin.internal.a.j.b systemInfo, com.gradle.scan.plugin.internal.a.i.a fileRefFactory, com.gradle.scan.plugin.internal.d.b eventSink, com.gradle.scan.plugin.internal.d.b.b store, com.gradle.scan.plugin.internal.a.x.b userDataCapturer, com.gradle.scan.plugin.internal.a.x.d userDataExclusionTracker, com.gradle.scan.plugin.internal.a.m.a memoryMonitor, com.gradle.scan.plugin.internal.h.b buildScanDataObfuscators, com.gradle.scan.plugin.internal.a buildFinishedWatcher, com.gradle.scan.plugin.internal.api.c buildFinishedActions, com.gradle.scan.plugin.internal.api.e buildScanPublishedActions, com.gradle.scan.plugin.internal.api.d buildScanErrorActions, com.gradle.scan.plugin.internal.c.b dumpController, com.gradle.scan.plugin.internal.j.e publishController, com.gradle.scan.plugin.internal.api.j publishArbiter, com.gradle.scan.plugin.internal.api.i extensionController, com.gradle.scan.plugin.internal.g.e styledLogger, com.gradle.scan.plugin.internal.a.h.a exceptionDataStore) {
        com.gradle.scan.plugin.internal.a.p.a.e pluginMetadataExtractor = com.gradle.scan.plugin.internal.a.p.a.e.a(project, gradleVersion);
        com.gradle.scan.plugin.internal.b buildScanPluginsTracker = new com.gradle.scan.plugin.internal.b(pluginMetadataExtractor);
        com.gradle.scan.plugin.internal.a.f.i configurationResolutionDataStore = new com.gradle.scan.plugin.internal.a.f.i(exceptionDataStore);
        com.gradle.scan.plugin.internal.a.g.d deprecatedUsageTraceDataStore = new com.gradle.scan.plugin.internal.a.g.d(fileRefFactory);
        try {
            BuildScanPlugin.a(project, systemInfo, fileRefFactory, eventSink);
            BuildScanPlugin.a(project, fileRefFactory, eventSink, pluginMetadataExtractor, buildScanPluginsTracker, configurationResolutionDataStore, problemReporter, exceptionDataStore, deprecatedUsageTraceDataStore);
        }
        catch (Throwable e2) {
            eventSink.a(e2);
        }
        finally {
            BuildScanPlugin.a(project, problemReporter, eventSink, store, systemInfo, memoryMonitor, userDataExclusionTracker, buildScanDataObfuscators, buildFinishedWatcher, buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, dumpController, publishController, publishArbiter, extensionController, buildScanPluginsTracker, configurationResolutionDataStore, styledLogger, exceptionDataStore, deprecatedUsageTraceDataStore);
        }
        com.gradle.scan.plugin.internal.a.j.c.a(systemInfo.b(), userDataCapturer);
    }

    private static void a(Project project, com.gradle.scan.plugin.internal.a.j.b systemInfo, com.gradle.scan.plugin.internal.a.i.a fileRefFactory, com.gradle.scan.plugin.internal.d.b eventSink) {
        Gradle gradle = project.getGradle();
        com.gradle.scan.plugin.internal.d.a.a eventClock = eventSink.a();
        com.gradle.scan.plugin.internal.d.a.f buildStartTime = com.gradle.scan.plugin.internal.a.d.a.a(gradle, eventClock);
        com.gradle.scan.plugin.internal.a.e.b daemonScanInfoService = com.gradle.scan.plugin.internal.a.e.b.a(gradle);
        com.gradle.scan.plugin.internal.a.e.a.a(eventSink, buildStartTime, daemonScanInfoService);
        com.gradle.scan.plugin.internal.a.j.a.a(eventSink, buildStartTime, project, systemInfo, daemonScanInfoService);
        com.gradle.scan.plugin.internal.a.i.b.a(eventSink, buildStartTime, fileRefFactory.a());
        com.gradle.scan.plugin.internal.a.s.a.a(eventSink, buildStartTime, gradle);
    }

    private static void a(final Project project, final com.gradle.scan.plugin.internal.a.i.a fileRefFactory, final com.gradle.scan.plugin.internal.d.b eventSink, final com.gradle.scan.plugin.internal.a.p.a.e pluginMetadataExtractor, final com.gradle.scan.plugin.internal.b buildScanPluginsTracker, final com.gradle.scan.plugin.internal.a.f.i configurationResolutionDataStore, final com.gradle.scan.plugin.internal.h problemReporter, final com.gradle.scan.plugin.internal.a.h.a exceptionDataStore, final com.gradle.scan.plugin.internal.a.g.d deprecatedUsageTraceDataStore) {
        Gradle gradle = project.getGradle();
        com.gradle.scan.plugin.internal.i.g.a(eventSink, gradle, (Action<? super e>)new Action<e>(){

            public void a(@Nonnull e operations) {
                h taskIdStore = BuildScanPlugin.b();
                com.gradle.scan.plugin.internal.a.l.a codeUnitApplicationRefStore = new com.gradle.scan.plugin.internal.a.l.a();
                com.gradle.scan.plugin.internal.f.a.a(eventSink, problemReporter, operations);
                com.gradle.scan.plugin.internal.a.r.a.a(eventSink, project, fileRefFactory, operations);
                com.gradle.scan.plugin.internal.a.k.a.a(eventSink, operations);
                com.gradle.scan.plugin.internal.a.c.b.a(eventSink, operations);
                com.gradle.scan.plugin.internal.a.n.a.a(eventSink, operations, exceptionDataStore);
                com.gradle.scan.plugin.internal.a.v.d.a(eventSink, operations);
                com.gradle.scan.plugin.internal.a.v.a.a(eventSink, taskIdStore, operations);
                com.gradle.scan.plugin.internal.a.v.h.a(eventSink, operations);
                com.gradle.scan.plugin.internal.a.w.f.a(eventSink, operations, exceptionDataStore);
                com.gradle.scan.plugin.internal.a.o.a.a(eventSink, operations, exceptionDataStore);
                com.gradle.scan.plugin.internal.a.a.a.a(eventSink, operations);
                com.gradle.scan.plugin.internal.a.p.a.a(eventSink, project, pluginMetadataExtractor, buildScanPluginsTracker, operations, codeUnitApplicationRefStore);
                com.gradle.scan.plugin.internal.a.t.a.a(eventSink, fileRefFactory, operations, codeUnitApplicationRefStore);
                com.gradle.scan.plugin.internal.a.l.b.a(eventSink, operations, codeUnitApplicationRefStore);
                com.gradle.scan.plugin.internal.a.q.a.a(eventSink, operations, exceptionDataStore);
                com.gradle.scan.plugin.internal.a.f.f.a(eventSink, project, configurationResolutionDataStore, fileRefFactory, operations);
                com.gradle.scan.plugin.internal.a.b.c.a(eventSink, operations);
                com.gradle.scan.plugin.internal.a.b.a.a(eventSink, operations, exceptionDataStore);
                com.gradle.scan.plugin.internal.a.g.a.a(eventSink, operations, deprecatedUsageTraceDataStore);
                com.gradle.scan.plugin.internal.a.t.d.a(eventSink, operations);
            }

            public /* synthetic */ void execute(@Nonnull Object object) {
                this.a((e)object);
            }
        });
        if (Boolean.getBoolean(g)) {
            throw new Error("Synthetic attach capturers error");
        }
    }

    private static h<com.gradle.scan.plugin.internal.a.v.j, Long> b() {
        return i.a(com.gradle.scan.plugin.internal.e.b.a(com.gradle.scan.plugin.internal.a.v.f.a));
    }

    private static void a(final Project project, final com.gradle.scan.plugin.internal.h problemReporter, final com.gradle.scan.plugin.internal.d.b eventSink, final com.gradle.scan.plugin.internal.d.b.b store, final com.gradle.scan.plugin.internal.a.j.b systemInfo, final com.gradle.scan.plugin.internal.a.m.a memoryMonitor, final com.gradle.scan.plugin.internal.a.x.d userDataExclusionTracker, final com.gradle.scan.plugin.internal.h.b obfuscators, final com.gradle.scan.plugin.internal.a buildFinishedWatcher, final com.gradle.scan.plugin.internal.api.c buildFinishedActions, final com.gradle.scan.plugin.internal.api.e buildScanPublishedActions, final com.gradle.scan.plugin.internal.api.d buildScanErrorActions, final com.gradle.scan.plugin.internal.c.b dumpController, final com.gradle.scan.plugin.internal.j.e publishController, final com.gradle.scan.plugin.internal.api.j publishArbiter, final com.gradle.scan.plugin.internal.api.i extensionController, final com.gradle.scan.plugin.internal.b buildScanPluginsTracker, final com.gradle.scan.plugin.internal.a.f.i configurationResolutionDataStore, final com.gradle.scan.plugin.internal.g.e styledLogger, final com.gradle.scan.plugin.internal.a.h.a exceptionDataStore, final com.gradle.scan.plugin.internal.a.g.d deprecatedUsageTraceDataStore) {
        final Gradle gradle = project.getGradle();
        gradle.addBuildListener((BuildListener)new BuildAdapter(){

            public void buildFinished(BuildResult result) {
                buildFinishedActions.a(new com.gradle.scan.plugin.internal.d(result.getFailure()));
                extensionController.a();
                long buildFinishedTimestamp = eventSink.a().a().a;
                if (eventSink.e()) {
                    publishArbiter.a();
                }
                if (!publishArbiter.e()) {
                    if (BuildScanPlugin.b(result)) {
                        if (gradle.getStartParameter().isOffline()) {
                            problemReporter.a(BuildScanPlugin.c);
                            publishArbiter.d();
                        }
                    } else {
                        publishArbiter.a();
                    }
                }
                if (!publishArbiter.e()) {
                    com.gradle.scan.plugin.internal.a.f.h.a(eventSink, configurationResolutionDataStore);
                    com.gradle.scan.plugin.internal.a.d.a(eventSink, systemInfo, obfuscators, result, memoryMonitor, exceptionDataStore, deprecatedUsageTraceDataStore);
                    BuildScanPlugin.b(buildScanPluginsTracker, problemReporter);
                    userDataExclusionTracker.a();
                }
                buildFinishedWatcher.a();
                if (!eventSink.c()) {
                    com.gradle.scan.plugin.internal.d.c.b spooling = eventSink.d();
                    if (publishArbiter.e()) {
                        BuildScanPlugin.b(spooling.c());
                    } else {
                        boolean shouldPromote = true;
                        if (BuildScanPlugin.b(BuildScanPlugin.d, project)) {
                            dumpController.a(buildFinishedTimestamp, spooling.c());
                        } else if (publishArbiter.a(result)) {
                            com.gradle.scan.plugin.internal.j.g publishResult = publishController.a(spooling);
                            if (publishResult.b()) {
                                shouldPromote = false;
                                buildScanPublishedActions.a(publishResult.a);
                            } else if (publishResult.c()) {
                                String errorMessage;
                                try {
                                    errorMessage = publishResult.b.a();
                                }
                                catch (IOException e2) {
                                    errorMessage = e2.getMessage();
                                }
                                buildScanErrorActions.a(errorMessage);
                            }
                            styledLogger.a("");
                        }
                        if (shouldPromote) {
                            BuildScanPlugin.b(buildFinishedTimestamp, spooling.c(), store, styledLogger);
                        }
                    }
                }
            }
        });
    }

    private static void b(com.gradle.scan.plugin.internal.d.d events) {
        if (events != null) {
            try {
                events.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void b(long timestamp, com.gradle.scan.plugin.internal.d.d events, com.gradle.scan.plugin.internal.d.b.b store, com.gradle.scan.plugin.internal.g.e logger) {
        if (events != null) {
            try {
                store.a(timestamp, events);
                events.close();
            }
            catch (Exception e2) {
                logger.a(StyledTextOutput.Style.Failure, "Unable to store build scan data: " + e2.getMessage());
            }
        }
    }

    private static boolean b(BuildResult result) {
        return result.getAction().toUpperCase().equals("BUILD");
    }

    private static boolean b(com.gradle.scan.plugin.internal.api.k termsOfServiceAgreement, com.gradle.scan.plugin.internal.api.f buildScanServer, com.gradle.scan.plugin.internal.g.e logger) {
        String errorMsg = buildScanServer.a();
        if (errorMsg == null && buildScanServer.e()) {
            termsOfServiceAgreement.b();
            errorMsg = termsOfServiceAgreement.a();
        }
        if (errorMsg == null) {
            return true;
        }
        logger.a("");
        logger.a(StyledTextOutput.Style.Failure, "The build scan was not published due to a configuration problem.");
        logger.a("");
        logger.a(errorMsg);
        return false;
    }

    private static String a(Project project, com.gradle.scan.plugin.internal.d.b.b store, com.gradle.scan.plugin.internal.c.b dumpController, com.gradle.scan.plugin.internal.j.e publishController, com.gradle.scan.plugin.internal.api.e buildScanPublishedActions) {
        final com.gradle.scan.plugin.internal.g previousBuildHandler = BuildScanPlugin.b(d, project) ? new com.gradle.scan.plugin.internal.c.c(store, dumpController) : new com.gradle.scan.plugin.internal.j.d(store, publishController, buildScanPublishedActions);
        com.gradle.scan.plugin.internal.i.a(project.getTasks(), b, com.gradle.scan.plugin.internal.j.a.class, new Action<com.gradle.scan.plugin.internal.j.a>(){

            public void a(com.gradle.scan.plugin.internal.j.a task) {
                task.setGroup("Build scan");
                task.setDescription("Publishes the data captured by the last build to the build scan server.");
                task.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
                task.getExtensions().add(com.gradle.scan.plugin.internal.g.class.getName(), (Object)previousBuildHandler);
            }

            public /* synthetic */ void execute(Object object) {
                this.a((com.gradle.scan.plugin.internal.j.a)((Object)object));
            }
        });
        return project.getPath() + b;
    }

    private static boolean b(String propName, Project project) {
        return project.getGradle().getStartParameter().getSystemPropertiesArgs().containsKey(propName);
    }

    private static void b(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new BuildScanException("The build scan plugin can only be applied to the root project.");
        }
    }

    private static void c(Project rootProject) {
        if (rootProject.getState().getExecuted()) {
            throw new BuildScanException(k.a("The build scan plugin must be applied early in the build lifecycle.", "Fixing this problem requires changing how you are applying the build scan plugin to your build.", "", "Please see https://gradle.com/scans/help/plugin-late-apply for how to resolve this problem."));
        }
    }

    private static void a(com.gradle.scan.b.a.a gradleVersion, com.gradle.scan.b.a.b pluginVersion) {
        if (!gradleVersion.a(com.gradle.scan.plugin.internal.m.a.a)) {
            throw new UnsupportedGradleVersionException(k.a("Build scans are not supported for Gradle 1.x.", "Please use a newer version of Gradle."));
        }
        if (!gradleVersion.a(com.gradle.scan.plugin.internal.m.a.c)) {
            throw new UnsupportedGradleVersionException(k.a("Version " + pluginVersion.g() + " of the build scan plugin requires Gradle 5.0 or later.", "You are currently using Gradle " + gradleVersion.e() + ".", "Please upgrade to a later version of Gradle or use build scan plugin 1.16."));
        }
    }

    private static void b(com.gradle.scan.plugin.internal.b tracker, com.gradle.scan.plugin.internal.h problemReporter) {
        Set<String> allVersions = tracker.a();
        if (allVersions.size() > 1) {
            problemReporter.a(k.a("", "WARNING: Several versions of the build scan plugin were applied: [" + k.b(allVersions, ", ") + "].", "The build scan data was captured by version [" + tracker.b() + "].", "This is often caused by multiple init scripts and/or build scripts applying the plugin."));
        }
    }
}

