/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharacterEscapes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberOutput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonWriteContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class UTF8JsonGenerator
extends JsonGeneratorImpl {
    private static final byte BYTE_u = 117;
    private static final byte BYTE_0 = 48;
    private static final byte BYTE_LBRACKET = 91;
    private static final byte BYTE_RBRACKET = 93;
    private static final byte BYTE_LCURLY = 123;
    private static final byte BYTE_RCURLY = 125;
    private static final byte BYTE_BACKSLASH = 92;
    private static final byte BYTE_COMMA = 44;
    private static final byte BYTE_COLON = 58;
    private static final byte BYTE_QUOTE = 34;
    private static final int MAX_BYTES_TO_BUFFER = 512;
    static final byte[] HEX_CHARS = CharTypes.copyHexBytes();
    private static final byte[] NULL_BYTES = new byte[]{110, 117, 108, 108};
    private static final byte[] TRUE_BYTES = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE_BYTES = new byte[]{102, 97, 108, 115, 101};
    protected final OutputStream _outputStream;
    protected byte[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected final int _outputMaxContiguous;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected byte[] _entityBuffer;
    protected boolean _bufferRecyclable;
    protected boolean _cfgUnqNames;

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream) {
        super(iOContext, n2, objectCodec);
        this._outputStream = outputStream;
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this.isEnabled(JsonGenerator$Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
        this._cfgUnqNames = !JsonGenerator$Feature.QUOTE_FIELD_NAMES.enabledIn(n2);
    }

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, byte[] byArray, int n3, boolean bl) {
        super(iOContext, n2, objectCodec);
        this._outputStream = outputStream;
        this._bufferRecyclable = bl;
        this._outputTail = n3;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        this._cfgUnqNames = !JsonGenerator$Feature.QUOTE_FIELD_NAMES.enabledIn(n2);
    }

    @Override
    public Object getOutputTarget() {
        return this._outputStream;
    }

    @Override
    public int getOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public void writeFieldName(String string) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string);
            return;
        }
        int n2 = this._writeContext.writeFieldName(string);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(string, false);
            return;
        }
        n2 = string.length();
        if (n2 > this._charBufferLength) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, 0, n2);
        } else {
            this._writeStringSegments(string, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString);
            return;
        }
        int n2 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeUnq(serializableString);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    private final void _writeUnq(SerializableString serializableString) {
        int n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
            return;
        }
        this._outputTail += n2;
    }

    @Override
    public final void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public final void writeEndArray() {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.getParent();
    }

    @Override
    public final void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public final void writeEndObject() {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.getParent();
    }

    protected final void _writePPFieldName(String string) {
        int n2 = this._writeContext.writeFieldName(string);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(string, false);
            return;
        }
        n2 = string.length();
        if (n2 > this._charBufferLength) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        string.getChars(0, n2, this._charBuffer, 0);
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(this._charBuffer, 0, n2);
        } else {
            this._writeStringSegments(this._charBuffer, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    protected final void _writePPFieldName(SerializableString serializableString) {
        int n2 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if ((n2 = !this._cfgUnqNames ? 1 : 0) != 0) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        }
        this._writeBytes(serializableString.asQuotedUTF8());
        if (n2 != 0) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        }
    }

    @Override
    public void writeString(String string) {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this._writeNull();
            return;
        }
        int n2 = string.length();
        if (n2 > this._outputMaxContiguous) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeStringSegment(string, 0, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        if (n3 <= this._outputMaxContiguous) {
            if (this._outputTail + n3 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n2, n3);
        } else {
            this._writeStringSegments(cArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final void writeString(SerializableString serializableString) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        int n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeBytes(byArray, n2, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        if (n3 <= this._outputMaxContiguous) {
            this._writeUTF8Segment(byArray, n2, n3);
        } else {
            this._writeUTF8Segments(byArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeRaw(String string) {
        int n2;
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            char[] cArray = this._charBuffer;
            n2 = this._charBuffer.length;
            n2 = i2 < n2 ? i2 : n2;
            string.getChars(n3, n3 + n2, cArray, 0);
            this.writeRaw(cArray, 0, n2);
            n3 += n2;
        }
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        while (n3 > 0) {
            char[] cArray = this._charBuffer;
            int n4 = this._charBuffer.length;
            n4 = n3 < n4 ? n3 : n4;
            string.getChars(n2, n2 + n4, cArray, 0);
            this.writeRaw(cArray, 0, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public void writeRaw(SerializableString object) {
        byte[] byArray = object.asUnquotedUTF8();
        object = byArray;
        if (byArray.length > 0) {
            this._writeBytes((byte[])object);
        }
    }

    @Override
    public void writeRawValue(SerializableString object) {
        this._verifyValueWrite("write a raw (unencoded) value");
        byte[] byArray = object.asUnquotedUTF8();
        object = byArray;
        if (byArray.length > 0) {
            this._writeBytes((byte[])object);
        }
    }

    @Override
    public final void writeRaw(char[] cArray, int n2, int n3) {
        int n4 = n3 + n3 + n3;
        if (this._outputTail + n4 > this._outputEnd) {
            if (this._outputEnd < n4) {
                this._writeSegmentedRaw(cArray, n2, n3);
                return;
            }
            this._flushBuffer();
        }
        n3 += n2;
        block0: while (n2 < n3) {
            while ((n4 = cArray[n2]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n4;
                if (++n2 >= n3) break block0;
            }
            if ((n4 = cArray[n2++]) < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n4 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            n2 = this._outputRawMultiByteChar(n4, cArray, n2, n3);
        }
    }

    @Override
    public void writeRaw(char c2) {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        if (c2 <= '\u007f') {
            byArray[this._outputTail++] = (byte)c2;
            return;
        }
        if (c2 < '\u0800') {
            byArray[this._outputTail++] = (byte)(0xC0 | c2 >> 6);
            byArray[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
            return;
        }
        this._outputRawMultiByteChar(c2, null, 0, 0);
    }

    private final void _writeSegmentedRaw(char[] cArray, int n2, int n3) {
        int n4 = this._outputEnd;
        byte[] byArray = this._outputBuffer;
        block0: while (n2 < n3) {
            char c2;
            while ((c2 = cArray[n2]) < '\u0080') {
                if (this._outputTail >= n4) {
                    this._flushBuffer();
                }
                byArray[this._outputTail++] = (byte)c2;
                if (++n2 >= n3) break block0;
            }
            if (this._outputTail + 3 >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((c2 = cArray[n2++]) < '\u0800') {
                byArray[this._outputTail++] = (byte)(0xC0 | c2 >> 6);
                byArray[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n2 = this._outputRawMultiByteChar(c2, cArray, n2, n3);
        }
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeBinary(base64Variant, byArray, n2, n2 + n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        int n3;
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            if (n2 < 0) {
                n3 = this._writeBinary(base64Variant, inputStream, byArray);
            } else {
                n3 = this._writeBinary(base64Variant, inputStream, byArray, n2);
                if (n3 > 0) {
                    this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n2 + ")");
                }
                n3 = n2;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        return n3;
    }

    @Override
    public void writeNumber(short s2) {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedShort(s2);
            return;
        }
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedShort(short s2) {
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(int n2) {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n2);
            return;
        }
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedInt(int n2) {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(long l2) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l2);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedLong(long l2) {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger.toString());
            return;
        }
        this.writeRaw(bigInteger.toString());
    }

    @Override
    public void writeNumber(double d2) {
        if (this._cfgNumbersAsStrings || (Double.isNaN(d2) || Double.isInfinite(d2)) && this.isEnabled(JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(d2));
            return;
        }
        this._verifyValueWrite("write a number");
        this.writeRaw(String.valueOf(d2));
    }

    @Override
    public void writeNumber(float f2) {
        if (this._cfgNumbersAsStrings || (Float.isNaN(f2) || Float.isInfinite(f2)) && this.isEnabled(JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(f2));
            return;
        }
        this._verifyValueWrite("write a number");
        this.writeRaw(String.valueOf(f2));
    }

    @Override
    public void writeNumber(BigDecimal object) {
        this._verifyValueWrite("write a number");
        if (object == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            object = this.isEnabled(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? ((BigDecimal)object).toPlainString() : ((BigDecimal)object).toString();
            this._writeQuotedRaw((String)object);
            return;
        }
        if (this.isEnabled(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN)) {
            this.writeRaw(((BigDecimal)object).toPlainString());
            return;
        }
        this.writeRaw(((BigDecimal)object).toString());
    }

    @Override
    public void writeNumber(String string) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
            return;
        }
        this.writeRaw(string);
    }

    private final void _writeQuotedRaw(String string) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this.writeRaw(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeBoolean(boolean bl) {
        this._verifyValueWrite("write a boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = bl ? TRUE_BYTES : FALSE_BYTES;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite("write a null");
        this._writeNull();
    }

    @Override
    protected final void _verifyValueWrite(String object) {
        int n2 = this._writeContext.writeValue();
        if (n2 == 5) {
            this._reportError("Can not " + (String)object + ", expecting field name");
        }
        if (this._cfgPrettyPrinter == null) {
            int n3;
            switch (n2) {
                case 1: {
                    n3 = 44;
                    break;
                }
                case 2: {
                    n3 = 58;
                    break;
                }
                case 3: {
                    if (this._rootValueSeparator != null) {
                        byte[] byArray = this._rootValueSeparator.asUnquotedUTF8();
                        object = byArray;
                        if (byArray.length > 0) {
                            this._writeBytes((byte[])object);
                        }
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail] = n3;
            ++this._outputTail;
            return;
        }
        this._verifyPrettyValueWrite((String)object, n2);
    }

    protected final void _verifyPrettyValueWrite(String string, int n2) {
        switch (n2) {
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                return;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                return;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                return;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    return;
                }
                if (!this._writeContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                return;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    @Override
    public void flush() {
        this._flushBuffer();
        if (this._outputStream != null && this.isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._outputStream.flush();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        this._outputTail = 0;
        if (this._outputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
                this._outputStream.close();
            } else if (this.isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
                this._outputStream.flush();
            }
        }
        this._releaseBuffers();
    }

    @Override
    protected void _releaseBuffers() {
        Object[] objectArray = this._outputBuffer;
        if (this._outputBuffer != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer((byte[])objectArray);
        }
        objectArray = this._charBuffer;
        if (this._charBuffer != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer((char[])objectArray);
        }
    }

    private final void _writeBytes(byte[] byArray) {
        int n2 = byArray.length;
        if (this._outputTail + n2 > this._outputEnd) {
            this._flushBuffer();
            if (n2 > 512) {
                this._outputStream.write(byArray, 0, n2);
                return;
            }
        }
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    private final void _writeBytes(byte[] byArray, int n2, int n3) {
        if (this._outputTail + n3 > this._outputEnd) {
            this._flushBuffer();
            if (n3 > 512) {
                this._outputStream.write(byArray, n2, n3);
                return;
            }
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail += n3;
    }

    private final void _writeStringSegments(String string, boolean bl) {
        int n2;
        if (bl) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        }
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            n2 = Math.min(this._outputMaxContiguous, i2);
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, n3, n2);
            n3 += n2;
        }
        if (bl) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        }
    }

    private final void _writeStringSegments(char[] cArray, int n2, int n3) {
        int n4;
        do {
            if (this._outputTail + (n4 = Math.min(this._outputMaxContiguous, n3)) > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void _writeStringSegments(String string, int n2, int n3) {
        int n4;
        do {
            if (this._outputTail + (n4 = Math.min(this._outputMaxContiguous, n3)) > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void _writeStringSegment(char[] cArray, int n2, int n3) {
        char c2;
        n3 += n2;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3 && (c2 = cArray[n2]) <= '\u007f' && nArray[c2] == 0) {
            byArray[n4++] = (byte)c2;
            ++n2;
        }
        this._outputTail = n4;
        if (n2 < n3) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(cArray, n2, n3);
                return;
            }
            if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(cArray, n2, n3);
                return;
            }
            this._writeStringSegmentASCII2(cArray, n2, n3);
        }
    }

    private final void _writeStringSegment(String string, int n2, int n3) {
        char c2;
        n3 += n2;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3 && (c2 = string.charAt(n2)) <= '\u007f' && nArray[c2] == 0) {
            byArray[n4++] = (byte)c2;
            ++n2;
        }
        this._outputTail = n4;
        if (n2 < n3) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(string, n2, n3);
                return;
            }
            if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(string, n2, n3);
                return;
            }
            this._writeStringSegmentASCII2(string, n2, n3);
        }
    }

    private final void _writeStringSegment2(char[] cArray, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3) {
            char c2;
            if ((c2 = cArray[n2++]) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n5 = nArray[c2];
                if (n5 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n5;
                    continue;
                }
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this._outputMultiByteChar(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeStringSegment2(String string, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n5 = nArray[c2];
                if (n5 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n5;
                    continue;
                }
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this._outputMultiByteChar(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeStringSegmentASCII2(char[] cArray, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar;
        while (n2 < n3) {
            char c2;
            if ((c2 = cArray[n2++]) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n6 = nArray[c2];
                if (n6 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 > n5) {
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this._outputMultiByteChar(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeStringSegmentASCII2(String string, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar;
        while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n6 = nArray[c2];
                if (n6 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 > n5) {
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this._outputMultiByteChar(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeCustomStringSegment2(char[] cArray, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (n2 < n3) {
            int n6;
            if ((n6 = cArray[n2++]) <= 127) {
                if (nArray[n6] == 0) {
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                int n7 = nArray[n6];
                if (n7 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n7;
                    continue;
                }
                if (n7 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n6) + ", although was supposed to have one");
                    }
                    n4 = this._writeCustomEscape(byArray, n4, serializableString, n3 - n2);
                    continue;
                }
                n4 = this._writeGenericEscape(n6, n4);
                continue;
            }
            if (n6 > n5) {
                n4 = this._writeGenericEscape(n6, n4);
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
            if (serializableString != null) {
                n4 = this._writeCustomEscape(byArray, n4, serializableString, n3 - n2);
                continue;
            }
            if (n6 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
                byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            n4 = this._outputMultiByteChar(n6, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeCustomStringSegment2(String string, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (n2 < n3) {
            int n6;
            if ((n6 = string.charAt(n2++)) <= 127) {
                if (nArray[n6] == 0) {
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                int n7 = nArray[n6];
                if (n7 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n7;
                    continue;
                }
                if (n7 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n6) + ", although was supposed to have one");
                    }
                    n4 = this._writeCustomEscape(byArray, n4, serializableString, n3 - n2);
                    continue;
                }
                n4 = this._writeGenericEscape(n6, n4);
                continue;
            }
            if (n6 > n5) {
                n4 = this._writeGenericEscape(n6, n4);
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
            if (serializableString != null) {
                n4 = this._writeCustomEscape(byArray, n4, serializableString, n3 - n2);
                continue;
            }
            if (n6 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
                byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            n4 = this._outputMultiByteChar(n6, n4);
        }
        this._outputTail = n4;
    }

    private final int _writeCustomEscape(byte[] byArray, int n2, SerializableString object, int n3) {
        byte[] byArray2 = object.asUnquotedUTF8();
        object = byArray2;
        int n4 = byArray2.length;
        if (n4 > 6) {
            return this._handleLongCustomEscape(byArray, n2, this._outputEnd, (byte[])object, n3);
        }
        System.arraycopy(object, 0, byArray, n2, n4);
        return n2 + n4;
    }

    private final int _handleLongCustomEscape(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = byArray2.length;
        if (n2 + n5 > n3) {
            this._outputTail = n2;
            this._flushBuffer();
            n2 = this._outputTail;
            if (n5 > byArray.length) {
                this._outputStream.write(byArray2, 0, n5);
                return n2;
            }
            System.arraycopy(byArray2, 0, byArray, n2, n5);
            n2 += n5;
        }
        if (n2 + n4 * 6 > n3) {
            this._flushBuffer();
            return this._outputTail;
        }
        return n2;
    }

    private final void _writeUTF8Segments(byte[] byArray, int n2, int n3) {
        int n4;
        do {
            n4 = Math.min(this._outputMaxContiguous, n3);
            this._writeUTF8Segment(byArray, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void _writeUTF8Segment(byte[] byArray, int n2, int n3) {
        int[] nArray = this._outputEscapes;
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            byte by;
            if ((by = byArray[n4++]) < 0 || nArray[by] == 0) continue;
            this._writeUTF8Segment2(byArray, n2, n3);
            return;
        }
        if (this._outputTail + n3 > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail += n3;
    }

    private final void _writeUTF8Segment2(byte[] byArray, int n2, int n3) {
        int n4 = this._outputTail;
        if (n4 + n3 * 6 > this._outputEnd) {
            this._flushBuffer();
            n4 = this._outputTail;
        }
        byte[] byArray2 = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        n3 += n2;
        while (n2 < n3) {
            int n5;
            int n6 = n5 = byArray[n2++];
            if (n5 < 0 || nArray[n6] == 0) {
                byArray2[n4++] = n5;
                continue;
            }
            n5 = nArray[n6];
            if (n5 > 0) {
                byArray2[n4++] = 92;
                byArray2[n4++] = (byte)n5;
                continue;
            }
            n4 = this._writeGenericEscape(n6, n4);
        }
        this._outputTail = n4;
    }

    protected final void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n3 - 3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n2 <= n5) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n4 = (byArray[n2++] << 8 | byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n4, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        n4 = n3 - n2;
        if (n4 > 0) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n3 = byArray[n2++] << 16;
            if (n4 == 2) {
                n3 |= (byArray[n2] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n3, n4, this._outputBuffer, this._outputTail);
        }
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = -3;
        int n7 = this._outputEnd - 6;
        int n8 = base64Variant.getMaxLineLength() >> 2;
        while (n2 > 2) {
            if (n4 > n6) {
                n5 = this._readMore(inputStream, byArray, n4, n5, n2);
                n4 = 0;
                if (n5 < 3) break;
                n6 = n5 - 3;
            }
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n3 = (byArray[n4++] << 8 | byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
            n2 -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n8 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n8 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 > 0 && (n5 = this._readMore(inputStream, byArray, n4, n5, n2)) > 0) {
            int n9;
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n3 = byArray[0] << 16;
            if (1 < n5) {
                n3 |= (byArray[1] & 0xFF) << 8;
                n9 = 2;
            } else {
                n9 = 1;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n3, n9, this._outputBuffer, this._outputTail);
            n2 -= n9;
        }
        return n2;
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = 0;
        int n7 = this._outputEnd - 6;
        int n8 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream, byArray, n3, n4, byArray.length);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n2 = (byArray[n3++] << 8 | byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
            n6 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n2, this._outputBuffer, this._outputTail);
            if (--n8 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n8 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n4 > 0) {
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n2 = byArray[0] << 16;
            int n9 = 1;
            if (1 < n4) {
                n2 |= (byArray[1] & 0xFF) << 8;
                n9 = 2;
            }
            n6 += n9;
            this._outputTail = base64Variant.encodeBase64Partial(n2, n9, this._outputBuffer, this._outputTail);
        }
        return n6;
    }

    private final int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n2 < n3) {
            byArray[n5++] = byArray[n2++];
        }
        n3 = n5;
        n4 = Math.min(n4, byArray.length);
        while ((n2 = n4 - n3) != 0) {
            if ((n2 = inputStream.read(byArray, n3, n2)) < 0) {
                return n3;
            }
            if ((n3 += n2) < 3) continue;
        }
        return n3;
    }

    private final int _outputRawMultiByteChar(int n2, char[] objectArray, int n3, int n4) {
        if (n2 >= 55296 && n2 <= 57343) {
            if (n3 >= n4 || objectArray == null) {
                this._reportError("Split surrogate on writeRaw() input (last character)");
            }
            this._outputSurrogates(n2, objectArray[n3]);
            return n3 + 1;
        }
        objectArray = this._outputBuffer;
        this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n2 >> 12);
        objectArray[this._outputTail++] = (char)(0x80 | n2 >> 6 & 0x3F);
        objectArray[this._outputTail++] = (char)(0x80 | n2 & 0x3F);
        return n3;
    }

    protected final void _outputSurrogates(int n2, int n3) {
        n2 = this._decodeSurrogate(n2, n3);
        if (this._outputTail + 4 > this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n2 >> 18);
        byArray[this._outputTail++] = (byte)(0x80 | n2 >> 12 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n2 >> 6 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n2 & 0x3F);
    }

    private final int _outputMultiByteChar(int n2, int n3) {
        byte[] byArray = this._outputBuffer;
        if (n2 >= 55296 && n2 <= 57343) {
            byArray[n3++] = 92;
            byArray[n3++] = 117;
            byArray[n3++] = HEX_CHARS[n2 >> 12 & 0xF];
            byArray[n3++] = HEX_CHARS[n2 >> 8 & 0xF];
            byArray[n3++] = HEX_CHARS[n2 >> 4 & 0xF];
            byArray[n3++] = HEX_CHARS[n2 & 0xF];
        } else {
            byArray[n3++] = (byte)(0xE0 | n2 >> 12);
            byArray[n3++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n2 & 0x3F);
        }
        return n3;
    }

    private final void _writeNull() {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(NULL_BYTES, 0, this._outputBuffer, this._outputTail, 4);
        this._outputTail += 4;
    }

    private int _writeGenericEscape(int n2, int n3) {
        byte[] byArray = this._outputBuffer;
        this._outputBuffer[n3++] = 92;
        byArray[n3++] = 117;
        if (n2 > 255) {
            int n4 = n2 >> 8 & 0xFF;
            byArray[n3++] = HEX_CHARS[n4 >> 4];
            byArray[n3++] = HEX_CHARS[n4 & 0xF];
            n2 &= 0xFF;
        } else {
            byArray[n3++] = 48;
            byArray[n3++] = 48;
        }
        byArray[n3++] = HEX_CHARS[n2 >> 4];
        byArray[n3++] = HEX_CHARS[n2 & 0xF];
        return n3;
    }

    protected final void _flushBuffer() {
        int n2 = this._outputTail;
        if (n2 > 0) {
            this._outputTail = 0;
            this._outputStream.write(this._outputBuffer, 0, n2);
        }
    }
}

