/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonFactory$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer$Bucket;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.BitSet;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    protected static final int DEFAULT_T_SIZE = 64;
    protected static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 100;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer();
    protected CharsToNameCanonicalizer _parent;
    private final int _hashSeed;
    protected final int _flags;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected CharsToNameCanonicalizer$Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _dirty;
    protected BitSet _overflows;

    public static CharsToNameCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        return CharsToNameCanonicalizer.createRoot((int)l2 + (int)(l2 >>> 32) | 1);
    }

    protected static CharsToNameCanonicalizer createRoot(int n2) {
        return sBootstrapSymbolTable.makeOrphan(n2);
    }

    private CharsToNameCanonicalizer() {
        this._canonicalize = true;
        this._flags = -1;
        this._dirty = true;
        this._hashSeed = 0;
        this._longestCollisionList = 0;
        this.initTables(64);
    }

    private void initTables(int n2) {
        this._symbols = new String[n2];
        this._buckets = new CharsToNameCanonicalizer$Bucket[n2 >> 1];
        this._indexMask = n2 - 1;
        this._size = 0;
        this._longestCollisionList = 0;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n2);
    }

    private static int _thresholdSize(int n2) {
        return n2 - (n2 >> 2);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, int n2, String[] stringArray, CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray, int n3, int n4, int n5) {
        this._parent = charsToNameCanonicalizer;
        this._flags = n2;
        this._canonicalize = JsonFactory$Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2);
        this._symbols = stringArray;
        this._buckets = charsToNameCanonicalizer$BucketArray;
        this._size = n3;
        this._hashSeed = n4;
        int n6 = stringArray.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n6);
        this._indexMask = n6 - 1;
        this._longestCollisionList = n5;
        this._dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CharsToNameCanonicalizer makeChild(int n2) {
        int n3;
        int n4;
        int n5;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray;
        String[] stringArray;
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        synchronized (charsToNameCanonicalizer) {
            stringArray = this._symbols;
            charsToNameCanonicalizer$BucketArray = this._buckets;
            n5 = this._size;
            n4 = this._hashSeed;
            n3 = this._longestCollisionList;
        }
        return new CharsToNameCanonicalizer(this, n2, stringArray, charsToNameCanonicalizer$BucketArray, n5, n4, n3);
    }

    private CharsToNameCanonicalizer makeOrphan(int n2) {
        return new CharsToNameCanonicalizer(null, -1, this._symbols, this._buckets, this._size, n2, this._longestCollisionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChild(CharsToNameCanonicalizer charsToNameCanonicalizer) {
        if (charsToNameCanonicalizer.size() > 12000) {
            CharsToNameCanonicalizer charsToNameCanonicalizer2 = this;
            synchronized (charsToNameCanonicalizer2) {
                this.initTables(256);
                this._dirty = false;
                return;
            }
        }
        if (charsToNameCanonicalizer.size() <= this.size()) {
            return;
        }
        CharsToNameCanonicalizer charsToNameCanonicalizer3 = this;
        synchronized (charsToNameCanonicalizer3) {
            this._symbols = charsToNameCanonicalizer._symbols;
            this._buckets = charsToNameCanonicalizer._buckets;
            this._size = charsToNameCanonicalizer._size;
            this._sizeThreshold = charsToNameCanonicalizer._sizeThreshold;
            this._indexMask = charsToNameCanonicalizer._indexMask;
            this._longestCollisionList = charsToNameCanonicalizer._longestCollisionList;
            this._dirty = false;
            return;
        }
    }

    public final void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            this._parent.mergeChild(this);
            this._dirty = false;
        }
    }

    public final int size() {
        return this._size;
    }

    public final int bucketCount() {
        return this._symbols.length;
    }

    public final boolean maybeDirty() {
        return this._dirty;
    }

    public final int hashSeed() {
        return this._hashSeed;
    }

    public final int collisionCount() {
        int n2 = 0;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray = this._buckets;
        int n3 = this._buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$BucketArray[i2];
            if (charsToNameCanonicalizer$Bucket == null) continue;
            n2 += charsToNameCanonicalizer$Bucket.length;
        }
        return n2;
    }

    public final int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public final String findSymbol(char[] cArray, int n2, int n3, int n4) {
        if (n3 <= 0) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n2, n3);
        }
        int n5 = this._hashToIndex(n4);
        String string = this._symbols[n5];
        if (string != null) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
            if (string.length() == n3) {
                int n6 = 0;
                while (string.charAt(n6) == cArray[n2 + n6]) {
                    if (++n6 != n3) continue;
                    return string;
                }
            }
            if ((charsToNameCanonicalizer$Bucket = this._buckets[n5 >> 1]) != null) {
                string = charsToNameCanonicalizer$Bucket.has(cArray, n2, n3);
                if (string != null) {
                    return string;
                }
                string = this._findSymbol2(cArray, n2, n3, charsToNameCanonicalizer$Bucket.next);
                if (string != null) {
                    return string;
                }
            }
        }
        return this._addSymbol(cArray, n2, n3, n4, n5);
    }

    private String _findSymbol2(char[] cArray, int n2, int n3, CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket) {
        while (charsToNameCanonicalizer$Bucket != null) {
            String string = charsToNameCanonicalizer$Bucket.has(cArray, n2, n3);
            if (string != null) {
                return string;
            }
            charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$Bucket.next;
        }
        return null;
    }

    private String _addSymbol(char[] object, int n2, int n3, int n4, int n5) {
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n5 = this._hashToIndex(this.calcHash((char[])object, n2, n3));
        }
        object = new String((char[])object, n2, n3);
        if (JsonFactory$Feature.INTERN_FIELD_NAMES.enabledIn(this._flags)) {
            object = InternCache.instance.intern((String)object);
        }
        ++this._size;
        if (this._symbols[n5] == null) {
            this._symbols[n5] = object;
        } else {
            n2 = n5 >> 1;
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket((String)object, this._buckets[n2]);
            n4 = charsToNameCanonicalizer$Bucket.length;
            if (n4 > 100) {
                this._handleSpillOverflow(n2, charsToNameCanonicalizer$Bucket);
            } else {
                this._buckets[n2] = charsToNameCanonicalizer$Bucket;
                this._longestCollisionList = Math.max(n4, this._longestCollisionList);
            }
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private void _handleSpillOverflow(int var1_1, CharsToNameCanonicalizer$Bucket var2_2) {
        block3: {
            if (this._overflows != null) break block3;
            this._overflows = new BitSet();
            ** GOTO lbl-1000
        }
        if (this._overflows.get(var1_1)) {
            if (JsonFactory$Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._flags)) {
                this.reportTooManyCollisions(100);
            }
            this._canonicalize = false;
        } else lbl-1000:
        // 2 sources

        {
            this._overflows.set(var1_1);
        }
        this._symbols[var1_1 + var1_1] = var2_2.symbol;
        this._buckets[var1_1] = null;
        this._size -= var2_2.length;
        this._longestCollisionList = -1;
    }

    public final int _hashToIndex(int n2) {
        int n3 = n2 + (n2 >>> 15);
        int n4 = n3 ^ n3 << 7;
        return n4 + (n4 >>> 3) & this._indexMask;
    }

    public final int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._hashSeed;
        int n5 = n2;
        n2 += n3;
        while (n5 < n2) {
            n4 = n4 * 33 + cArray[n5];
            ++n5;
        }
        if (n4 == 0) {
            return 1;
        }
        return n4;
    }

    public final int calcHash(String string) {
        int n2 = string.length();
        int n3 = this._hashSeed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 33 + string.charAt(i2);
        }
        if (n3 == 0) {
            return 1;
        }
        return n3;
    }

    private void copyArrays() {
        Object[] objectArray = this._symbols;
        this._symbols = Arrays.copyOf(objectArray, objectArray.length);
        objectArray = this._buckets;
        this._buckets = (CharsToNameCanonicalizer$Bucket[])Arrays.copyOf(objectArray, objectArray.length);
    }

    private void rehash() {
        int n2;
        Object object;
        int n3;
        int n4 = this._symbols.length;
        int n5 = n4 + n4;
        if (n5 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new CharsToNameCanonicalizer$Bucket[32];
            this._indexMask = 63;
            this._dirty = true;
            return;
        }
        Object object2 = this._symbols;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray = this._buckets;
        this._symbols = new String[n5];
        this._buckets = new CharsToNameCanonicalizer$Bucket[n5 >> 1];
        this._indexMask = n5 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n5);
        n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
            object = object2[n3];
            if (object == null) continue;
            ++n5;
            int n7 = this._hashToIndex(this.calcHash((String)object));
            if (this._symbols[n7] == null) {
                this._symbols[n7] = object;
                continue;
            }
            n2 = n7 >> 1;
            this._buckets[n2] = charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket((String)object, this._buckets[n2]);
            n6 = Math.max(n6, charsToNameCanonicalizer$Bucket.length);
        }
        n4 >>= 1;
        for (n3 = 0; n3 < n4; ++n3) {
            object = charsToNameCanonicalizer$BucketArray[n3];
            while (object != null) {
                ++n5;
                String string = ((CharsToNameCanonicalizer$Bucket)object).symbol;
                n2 = this._hashToIndex(this.calcHash(string));
                if (this._symbols[n2] == null) {
                    this._symbols[n2] = string;
                } else {
                    int n8 = n2 >> 1;
                    this._buckets[n8] = object2 = new CharsToNameCanonicalizer$Bucket(string, this._buckets[n8]);
                    n6 = Math.max(n6, object2.length);
                }
                object = ((CharsToNameCanonicalizer$Bucket)object).next;
            }
        }
        this._longestCollisionList = n6;
        this._overflows = null;
        if (n5 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n5 + ".");
        }
    }

    protected final void reportTooManyCollisions(int n2) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }
}

