/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$NumberType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base.ParserBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileConstants;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class SmileParser
extends ParserBase {
    private static final int[] NO_INTS = new int[0];
    private static final String[] NO_STRINGS = new String[0];
    protected ObjectCodec _objectCodec;
    protected boolean _mayContainRawBinary;
    protected final SmileBufferRecycler<String> _smileBufferRecycler;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected int _formatFeatures;
    protected boolean _bufferRecyclable;
    protected boolean _tokenIncomplete = false;
    protected int _typeAsInt;
    protected boolean _got32BitFloat;
    protected int _tokenOffsetForTotal;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quad1;
    protected int _quad2;
    protected int _quad3;
    protected String[] _seenNames = NO_STRINGS;
    protected int _seenNameCount = 0;
    protected String[] _seenStringValues = null;
    protected int _seenStringValueCount = -1;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<String>>> _smileRecyclerRef = new ThreadLocal();

    public SmileParser(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, InputStream inputStream, byte[] byArray, int n4, int n5, boolean bl) {
        super(iOContext, n2);
        this._objectCodec = objectCodec;
        this._symbols = byteQuadsCanonicalizer;
        this._formatFeatures = n3;
        this._inputStream = inputStream;
        this._inputBuffer = byArray;
        this._inputPtr = n4;
        this._inputEnd = n5;
        this._bufferRecyclable = bl;
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
        this._smileBufferRecycler = SmileParser._smileBufferRecycler();
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    protected boolean handleSignature(boolean bl, boolean bl2) {
        if (bl) {
            ++this._inputPtr;
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 41) {
            if (bl2) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0x29");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 10) {
            if (bl2) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a, 0x29, but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0xA");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (bl2 = (bl = this._inputBuffer[this._inputPtr++]) >> 4 & 0xF) {
            this._reportError("Header version number bits (0x" + Integer.toHexString(bl2 ? 1 : 0) + ") indicate unrecognized version; only 0x0 handled by parser");
        }
        if (!(bl & true)) {
            this._seenNames = null;
            this._seenNameCount = -1;
        }
        if ((bl & 2) != 0) {
            this._seenStringValues = NO_STRINGS;
            this._seenStringValueCount = 0;
        }
        this._mayContainRawBinary = (bl & 4) != 0;
        return true;
    }

    protected static final SmileBufferRecycler<String> _smileBufferRecycler() {
        Object object = _smileRecyclerRef.get();
        object = object == null ? null : ((SoftReference)object).get();
        if (object == null) {
            object = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference(object));
        }
        return object;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonParser overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        return this;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this._inputPtr;
        outputStream.write(this._inputBuffer, n3, n2);
        return n2;
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    @Override
    public JsonLocation getTokenLocation() {
        long l2 = this._currInputProcessed + (long)this._tokenOffsetForTotal;
        return new JsonLocation(this._ioContext.getSourceReference(), l2, -1L, -1, (int)l2);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        long l2 = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), l2, -1L, -1, (int)l2);
    }

    @Override
    protected final boolean loadMore() {
        if (this._inputStream != null) {
            int n2 = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            this._currInputProcessed += (long)this._inputEnd;
            this._inputPtr = 0;
            if (n2 > 0) {
                this._inputEnd = n2;
                return true;
            }
            this._inputEnd = 0;
            this._closeInput();
            if (n2 == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final void _loadToHaveAtLeast(int n2) {
        if (this._inputStream == null) {
            throw this._constructError("Needed to read " + n2 + " bytes, reached end-of-input");
        }
        int n3 = this._inputEnd - this._inputPtr;
        this._currInputProcessed += (long)this._inputPtr;
        if (n3 > 0 && this._inputPtr > 0) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n3);
            this._inputEnd = n3;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < n2) {
            int n4 = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n4 <= 0) {
                this._closeInput();
                if (n4 == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + n3 + " bytes");
                }
                throw this._constructError("Needed to read " + n2 + " bytes, missed " + n2 + " before end-of-input");
            }
            this._inputEnd += n4;
        }
    }

    @Override
    protected void _closeInput() {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser$Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    protected void _finishString() {
        this._throwInternal();
    }

    @Override
    public void close() {
        super.close();
        this._symbols.release();
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    protected void _releaseBuffers() {
        Object[] objectArray;
        super._releaseBuffers();
        if (this._bufferRecyclable) {
            objectArray = this._inputBuffer;
            if (this._inputBuffer != null) {
                this._inputBuffer = null;
                this._ioContext.releaseReadIOBuffer((byte[])objectArray);
            }
        }
        objectArray = this._seenNames;
        if (this._seenNames != null && objectArray.length > 0) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(objectArray, 0, this._seenNameCount, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((String[])objectArray);
        }
        objectArray = this._seenStringValues;
        if (this._seenStringValues != null && objectArray.length > 0) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(objectArray, 0, this._seenStringValueCount, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((String[])objectArray);
        }
    }

    public boolean mayContainRawBinary() {
        return this._mayContainRawBinary;
    }

    @Override
    public JsonToken nextToken() {
        int n2;
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenOffsetForTotal = this._inputPtr;
        this._binaryValue = null;
        if (this._currToken != JsonToken.FIELD_NAME && this._parsingContext.inObject()) {
            this._currToken = this._handleFieldName();
            return this._currToken;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return this._eofAsNextToken();
        }
        this._typeAsInt = n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (n2 >> 5) {
            case 0: {
                if (n2 == 0) break;
                return this._handleSharedString(n2 - 1);
            }
            case 1: {
                int n3 = n2 & 0x1F;
                if (n3 < 4) {
                    switch (n3) {
                        case 0: {
                            this._textBuffer.resetWithEmpty();
                            this._currToken = JsonToken.VALUE_STRING;
                            return this._currToken;
                        }
                        case 1: {
                            this._currToken = JsonToken.VALUE_NULL;
                            return this._currToken;
                        }
                        case 2: {
                            this._currToken = JsonToken.VALUE_FALSE;
                            return this._currToken;
                        }
                    }
                    this._currToken = JsonToken.VALUE_TRUE;
                    return this._currToken;
                }
                if (n3 == 4) {
                    this._finishInt();
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    return this._currToken;
                }
                if (n3 <= 6) {
                    this._tokenIncomplete = true;
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    return this._currToken;
                }
                if (n3 < 11 && n3 != 7) {
                    this._got32BitFloat = n3 == 8;
                    this._tokenIncomplete = true;
                    this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                    return this._currToken;
                }
                if (n3 != 26) break;
                if (this.handleSignature(false, false)) {
                    if (this._currToken == null) {
                        return this.nextToken();
                    }
                    this._currToken = null;
                    return null;
                }
                this._reportError("Unrecognized token byte 0x3A (malformed segment header?");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this._seenStringValueCount >= 0) {
                    return this._addSeenStringValue();
                }
                this._tokenIncomplete = true;
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(n2 & 0x1F);
                this._numTypesValid = 1;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 7: {
                switch (n2 & 0x1F) {
                    case 0: 
                    case 4: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_STRING;
                        return this._currToken;
                    }
                    case 8: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        return this._currToken;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        return this._handleSharedString(((n2 & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF));
                    }
                    case 24: {
                        this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                        this._currToken = JsonToken.START_ARRAY;
                        return this._currToken;
                    }
                    case 25: {
                        if (!this._parsingContext.inArray()) {
                            this._reportMismatchedEndMarker(93, '}');
                        }
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    case 26: {
                        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                        this._currToken = JsonToken.START_OBJECT;
                        return this._currToken;
                    }
                    case 27: {
                        this._reportError("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        return this._currToken;
                    }
                    case 31: {
                        this._currToken = null;
                        return null;
                    }
                }
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(n2 & 0xFF) + " for expected value token");
        return null;
    }

    private final JsonToken _handleSharedString(int n2) {
        if (n2 >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(n2);
        }
        this._textBuffer.resetWithString(this._seenStringValues[n2]);
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final JsonToken _addSeenStringValue() {
        this._finishToken();
        String string = this._textBuffer.contentsAsString();
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = string;
        } else {
            this._expandSeenStringValues(string);
        }
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final void _expandSeenStringValues(String string) {
        String[] stringArray = this._seenStringValues;
        int n2 = this._seenStringValues.length;
        if (n2 == 0) {
            stringArray = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (stringArray == null) {
                stringArray = new String[64];
            }
        } else if (n2 == 1024) {
            this._seenStringValueCount = 0;
        } else {
            n2 = n2 == 64 ? 256 : 1024;
            stringArray = Arrays.copyOf(stringArray, n2);
        }
        this._seenStringValues = stringArray;
        this._seenStringValues[this._seenStringValueCount++] = string;
    }

    @Override
    public JsonParser$NumberType getNumberType() {
        if (this._got32BitFloat && this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return JsonParser$NumberType.FLOAT;
        }
        return super.getNumberType();
    }

    @Override
    public boolean nextFieldName(SerializableString object) {
        if (this._currToken != JsonToken.FIELD_NAME && this._parsingContext.inObject()) {
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenOffsetForTotal = this._inputPtr;
            this._binaryValue = null;
            byte[] byArray = object.asQuotedUTF8();
            int n2 = byArray.length;
            if (this._inputPtr + n2 + 1 < this._inputEnd) {
                int n3;
                int n4 = this._inputPtr;
                this._typeAsInt = n3 = this._inputBuffer[n4++] & 0xFF;
                block0 : switch (n3 >> 6) {
                    case 0: {
                        switch (n3) {
                            case 32: {
                                this._currToken = JsonToken.FIELD_NAME;
                                this._inputPtr = n4;
                                this._parsingContext.setCurrentName("");
                                return n2 == 0;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: {
                                n3 = ((n3 & 3) << 8) + (this._inputBuffer[n4++] & 0xFF);
                                if (n3 >= this._seenNameCount) {
                                    this._reportInvalidSharedName(n3);
                                }
                                String string = this._seenNames[n3];
                                this._parsingContext.setCurrentName(string);
                                this._inputPtr = n4;
                                this._currToken = JsonToken.FIELD_NAME;
                                return string.equals(object.getValue());
                            }
                        }
                        break;
                    }
                    case 1: {
                        if ((n3 &= 0x3F) >= this._seenNameCount) {
                            this._reportInvalidSharedName(n3);
                        }
                        this._parsingContext.setCurrentName(this._seenNames[n3]);
                        String string = this._seenNames[n3];
                        this._parsingContext.setCurrentName(string);
                        this._inputPtr = n4;
                        this._currToken = JsonToken.FIELD_NAME;
                        return string.equals(object.getValue());
                    }
                    case 2: {
                        n3 = 1 + (n3 & 0x3F);
                        if (n3 != n2) break;
                        for (n2 = 0; n2 < n3; ++n2) {
                            if (byArray[n2] != this._inputBuffer[n4 + n2]) break block0;
                        }
                        this._inputPtr = n4 + n3;
                        object = object.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = object;
                        }
                        this._parsingContext.setCurrentName((String)object);
                        this._currToken = JsonToken.FIELD_NAME;
                        return true;
                    }
                    case 3: {
                        if ((n3 &= 0x3F) > 55) {
                            if (n3 != 59) break;
                            this._currToken = JsonToken.END_OBJECT;
                            if (!this._parsingContext.inObject()) {
                                this._reportMismatchedEndMarker(125, ']');
                            }
                            this._inputPtr = n4;
                            this._parsingContext = this._parsingContext.getParent();
                            return false;
                        }
                        if ((n3 += 2) != n2) break;
                        for (n2 = 0; n2 < n3; ++n2) {
                            if (byArray[n2] != this._inputBuffer[n4 + n2]) break block0;
                        }
                        this._inputPtr = n4 + n3;
                        object = object.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = object;
                        }
                        this._parsingContext.setCurrentName((String)object);
                        this._currToken = JsonToken.FIELD_NAME;
                        return true;
                    }
                }
            }
        }
        return this.nextToken() == JsonToken.FIELD_NAME && object.getValue().equals(this.getCurrentName());
    }

    @Override
    public String nextFieldName() {
        if (this._currToken != JsonToken.FIELD_NAME && this._parsingContext.inObject()) {
            int n2;
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenOffsetForTotal = this._inputPtr;
            this._binaryValue = null;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            this._typeAsInt = n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            switch (n2 >> 6) {
                case 0: {
                    switch (n2) {
                        case 32: {
                            this._parsingContext.setCurrentName("");
                            this._currToken = JsonToken.FIELD_NAME;
                            return "";
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((n2 = ((n2 & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                                this._reportInvalidSharedName(n2);
                            }
                            String string = this._seenNames[n2];
                            this._parsingContext.setCurrentName(string);
                            this._currToken = JsonToken.FIELD_NAME;
                            return string;
                        }
                        case 52: {
                            this._handleLongFieldName();
                            this._currToken = JsonToken.FIELD_NAME;
                            return this.getCurrentName();
                        }
                    }
                    break;
                }
                case 1: {
                    if ((n2 &= 0x3F) >= this._seenNameCount) {
                        this._reportInvalidSharedName(n2);
                    }
                    String string = this._seenNames[n2];
                    this._parsingContext.setCurrentName(string);
                    this._currToken = JsonToken.FIELD_NAME;
                    return string;
                }
                case 2: {
                    n2 = 1 + (n2 & 0x3F);
                    String string = this._findDecodedFromSymbols(n2);
                    if (string != null) {
                        this._inputPtr += n2;
                    } else {
                        string = this._decodeShortAsciiName(n2);
                        string = this._addDecodedToSymbols(n2, string);
                    }
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = string;
                    }
                    this._parsingContext.setCurrentName(string);
                    this._currToken = JsonToken.FIELD_NAME;
                    return string;
                }
                case 3: {
                    if ((n2 &= 0x3F) > 55) {
                        if (n2 != 59) break;
                        if (!this._parsingContext.inObject()) {
                            this._reportMismatchedEndMarker(125, ']');
                        }
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_OBJECT;
                        return null;
                    }
                    String string = this._findDecodedFromSymbols(n2 += 2);
                    if (string != null) {
                        this._inputPtr += n2;
                    } else {
                        string = this._decodeShortUnicodeName(n2);
                        string = this._addDecodedToSymbols(n2, string);
                    }
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = string;
                    }
                    this._parsingContext.setCurrentName(string);
                    this._currToken = JsonToken.FIELD_NAME;
                    return string;
                }
            }
            this._reportError("Invalid type marker byte 0x" + Integer.toHexString(this._typeAsInt) + " for expected field name (or END_OBJECT marker)");
            return null;
        }
        if (this.nextToken() == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return null;
    }

    @Override
    public String nextTextValue() {
        if (!this._parsingContext.inObject() || this._currToken == JsonToken.FIELD_NAME) {
            int n2;
            int n3;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            if ((n3 = this._inputPtr) >= this._inputEnd) {
                if (!this.loadMore()) {
                    this._eofAsNextToken();
                    return null;
                }
                n3 = this._inputPtr;
            }
            this._tokenOffsetForTotal = n3;
            this._typeAsInt = n2 = this._inputBuffer[n3++] & 0xFF;
            this._binaryValue = null;
            switch (n2 >> 5) {
                case 0: {
                    if (n2 != 0) {
                        if (--n2 >= this._seenStringValueCount) {
                            this._reportInvalidSharedStringValue(n2);
                        }
                        this._inputPtr = n3;
                        String string = this._seenStringValues[n2];
                        this._textBuffer.resetWithString(string);
                        this._currToken = JsonToken.VALUE_STRING;
                        return string;
                    }
                    this._reportError("Invalid token byte 0x00");
                }
                case 1: {
                    if ((n2 & 0x1F) != 0) break;
                    this._inputPtr = n3;
                    this._textBuffer.resetWithEmpty();
                    this._currToken = JsonToken.VALUE_STRING;
                    return "";
                }
                case 2: 
                case 3: {
                    this._currToken = JsonToken.VALUE_STRING;
                    this._inputPtr = n3;
                    String string = this._decodeShortAsciiValue(1 + (n2 & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = string;
                        } else {
                            this._expandSeenStringValues(string);
                        }
                    }
                    return string;
                }
                case 4: 
                case 5: {
                    this._currToken = JsonToken.VALUE_STRING;
                    this._inputPtr = n3;
                    String string = this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = string;
                        } else {
                            this._expandSeenStringValues(string);
                        }
                    }
                    return string;
                }
            }
        }
        if (this.nextToken() == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        return null;
    }

    @Override
    public int nextIntValue(int n2) {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return n2;
    }

    @Override
    public long nextLongValue(long l2) {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return l2;
    }

    @Override
    public Boolean nextBooleanValue() {
        switch (this.nextToken()) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public String getText() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int n2 = this._typeAsInt;
            int n3 = n2 >> 5;
            if (n3 == 2 || n3 == 3) {
                return this._decodeShortAsciiValue(1 + (n2 & 0x3F));
            }
            if (n3 == 4 || n3 == 5) {
                return this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return null;
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName();
        }
        if (jsonToken.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.getTextBuffer();
            }
            if (this._currToken == JsonToken.FIELD_NAME) {
                if (!this._nameCopied) {
                    String string = this._parsingContext.getCurrentName();
                    int n2 = string.length();
                    if (this._nameCopyBuffer == null) {
                        this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                    } else if (this._nameCopyBuffer.length < n2) {
                        this._nameCopyBuffer = new char[n2];
                    }
                    string.getChars(0, n2, this._nameCopyBuffer, 0);
                    this._nameCopied = true;
                }
                return this._nameCopyBuffer;
            }
            if (this._currToken.isNumeric()) {
                return this.getNumberValue().toString().toCharArray();
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.size();
            }
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().length();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() {
        return 0;
    }

    @Override
    public String getValueAsString() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int n2 = this._typeAsInt;
            int n3 = n2 >> 5;
            if (n3 == 2 || n3 == 3) {
                return this._decodeShortAsciiValue(1 + (n2 & 0x3F));
            }
            if (n3 == 4 || n3 == 5) {
                return this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getText();
    }

    @Override
    public String getValueAsString(String string) {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return string;
        }
        return this.getText();
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    @Override
    public Object getEmbeddedObject() {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue == null) {
                return 0;
            }
            int n2 = this._binaryValue.length;
            outputStream.write(this._binaryValue, 0, n2);
            return n2;
        }
        if (this._typeAsInt == 253) {
            int n3;
            int n4;
            for (int i2 = n3 = this._readUnsignedVInt(); i2 > 0; i2 -= n4) {
                n4 = this._inputEnd - this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n4 = this._inputEnd - this._inputPtr;
                }
                n4 = Math.min(n4, i2);
                outputStream.write(this._inputBuffer, this._inputPtr, n4);
                this._inputPtr += n4;
            }
            this._tokenIncomplete = false;
            return n3;
        }
        if (this._typeAsInt != 232) {
            this._throwInternal();
        }
        int n5 = this._readUnsignedVInt();
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            this._readBinaryEncoded(outputStream, n5, byArray);
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        this._tokenIncomplete = false;
        return n5;
    }

    private void _readBinaryEncoded(OutputStream outputStream, int n2, byte[] byArray) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = byArray.length - 7;
        while (n2 > 7) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            n4 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            n3 = this._inputBuffer[this._inputPtr++];
            n4 += n3 >> 3;
            n3 = ((n3 & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            byArray[n5++] = n4 >> 24;
            byArray[n5++] = (byte)(n4 >> 16);
            byArray[n5++] = (byte)(n4 >> 8);
            byArray[n5++] = (byte)n4;
            byArray[n5++] = (byte)(n3 >> 16);
            byArray[n5++] = (byte)(n3 >> 8);
            byArray[n5++] = (byte)n3;
            n2 -= 7;
            if (n5 <= n6) continue;
            outputStream.write(byArray, 0, n5);
            n5 = 0;
        }
        if (n2 > 0) {
            if (this._inputEnd - this._inputPtr < n2 + 1) {
                this._loadToHaveAtLeast(n2 + 1);
            }
            n4 = this._inputBuffer[this._inputPtr++];
            for (n3 = 1; n3 < n2; ++n3) {
                n4 = (n4 << 7) + this._inputBuffer[this._inputPtr++];
                byArray[n5++] = (byte)(n4 >> 7 - n3);
            }
            byArray[n5++] = (byte)((n4 <<= n2) + this._inputBuffer[this._inputPtr++]);
        }
        if (n5 > 0) {
            outputStream.write(byArray, 0, n5);
        }
    }

    protected final JsonToken _handleFieldName() {
        int n2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        this._typeAsInt = n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (n2 >> 6) {
            case 0: {
                switch (n2) {
                    case 32: {
                        this._parsingContext.setCurrentName("");
                        return JsonToken.FIELD_NAME;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((n2 = ((n2 & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(n2);
                        }
                        this._parsingContext.setCurrentName(this._seenNames[n2]);
                        return JsonToken.FIELD_NAME;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        return JsonToken.FIELD_NAME;
                    }
                }
                break;
            }
            case 1: {
                if ((n2 &= 0x3F) >= this._seenNameCount) {
                    this._reportInvalidSharedName(n2);
                }
                this._parsingContext.setCurrentName(this._seenNames[n2]);
                return JsonToken.FIELD_NAME;
            }
            case 2: {
                n2 = 1 + (n2 & 0x3F);
                String string = this._findDecodedFromSymbols(n2);
                if (string != null) {
                    this._inputPtr += n2;
                } else {
                    string = this._decodeShortAsciiName(n2);
                    string = this._addDecodedToSymbols(n2, string);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = string;
                }
                this._parsingContext.setCurrentName(string);
                return JsonToken.FIELD_NAME;
            }
            case 3: {
                if ((n2 &= 0x3F) > 55) {
                    if (n2 != 59) break;
                    if (!this._parsingContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._parsingContext = this._parsingContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                String string = this._findDecodedFromSymbols(n2 += 2);
                if (string != null) {
                    this._inputPtr += n2;
                } else {
                    string = this._decodeShortUnicodeName(n2);
                    string = this._addDecodedToSymbols(n2, string);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = string;
                }
                this._parsingContext.setCurrentName(string);
                return JsonToken.FIELD_NAME;
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(this._typeAsInt) + " for expected field name (or END_OBJECT marker)");
        return null;
    }

    private final String[] _expandSeenNames(String[] stringArray) {
        int n2 = stringArray.length;
        if (n2 == 0) {
            stringArray = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (stringArray == null) {
                stringArray = new String[64];
            }
        } else if (n2 == 1024) {
            this._seenNameCount = 0;
        } else {
            n2 = n2 == 64 ? 256 : 1024;
            stringArray = Arrays.copyOf(stringArray, n2);
        }
        return stringArray;
    }

    private final String _addDecodedToSymbols(int n2, String string) {
        if (n2 < 5) {
            return this._symbols.addName(string, this._quad1);
        }
        if (n2 < 9) {
            return this._symbols.addName(string, this._quad1, this._quad2);
        }
        if (n2 < 13) {
            return this._symbols.addName(string, this._quad1, this._quad2, this._quad3);
        }
        n2 = n2 + 3 >> 2;
        return this._symbols.addName(string, this._quadBuffer, n2);
    }

    private final String _decodeShortAsciiName(int n2) {
        int n3;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n4 = 0;
        byte[] byArray = this._inputBuffer;
        int n5 = n3 + n2;
        for (n3 = this._inputPtr; n3 < n5; ++n3) {
            cArray[n4++] = (char)byArray[n3];
        }
        this._inputPtr = n3;
        return this._textBuffer.setCurrentAndReturn(n2);
    }

    private final String _decodeShortUnicodeName(int n2) {
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n4 = this._inputPtr;
        this._inputPtr += n2;
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        n2 = n4 + n2;
        while (n4 < n2) {
            int n5;
            int n6;
            if ((n6 = nArray[n5 = byArray[n4++] & 0xFF]) != 0) {
                switch (n6) {
                    case 1: {
                        n5 = (n5 & 0x1F) << 6 | byArray[n4++] & 0x3F;
                        break;
                    }
                    case 2: {
                        n5 = (n5 & 0xF) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F;
                        break;
                    }
                    case 3: {
                        n5 = ((n5 & 7) << 18 | (byArray[n4++] & 0x3F) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F) - 65536;
                        cArray[n3++] = (char)(0xD800 | n5 >> 10);
                        n5 = 0xDC00 | n5 & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(n5) + " in short Unicode text block");
                    }
                }
            }
            cArray[n3++] = (char)n5;
        }
        return this._textBuffer.setCurrentAndReturn(n3);
    }

    private final String _decodeLongUnicodeName(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = n2 & 3;
        if (n5 < 4) {
            n4 = nArray[n3 - 1];
            nArray[n3 - 1] = n4 << (4 - n5 << 3);
        } else {
            n4 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = nArray[n7 >> 2];
            int n9 = n7 & 3;
            n8 = n8 >> (3 - n9 << 3) & 0xFF;
            ++n7;
            if (n8 > 127) {
                int n10;
                if ((n8 & 0xE0) == 192) {
                    n8 &= 0x1F;
                    n10 = 1;
                } else if ((n8 & 0xF0) == 224) {
                    n8 &= 0xF;
                    n10 = 2;
                } else if ((n8 & 0xF8) == 240) {
                    n8 &= 7;
                    n10 = 3;
                } else {
                    this._reportInvalidInitial(n8);
                    n8 = 1;
                    n10 = 1;
                }
                if (n7 + n10 > n2) {
                    this._reportInvalidEOF(" in long field name");
                }
                int n11 = nArray[n7 >> 2];
                n9 = n7 & 3;
                ++n7;
                if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n11);
                }
                n8 = n8 << 6 | n11 & 0x3F;
                if (n10 > 1) {
                    n11 = nArray[n7 >> 2];
                    n9 = n7 & 3;
                    ++n7;
                    if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n11);
                    }
                    n8 = n8 << 6 | n11 & 0x3F;
                    if (n10 > 2) {
                        n11 = nArray[n7 >> 2];
                        n9 = n7 & 3;
                        ++n7;
                        if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n11 & 0xFF);
                        }
                        n8 = n8 << 6 | n11 & 0x3F;
                    }
                }
                if (n10 > 2) {
                    n8 -= 65536;
                    if (n6 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n6++] = (char)(55296 + (n8 >> 10));
                    n8 = 0xDC00 | n8 & 0x3FF;
                }
            }
            if (n6 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n6++] = (char)n8;
        }
        String string = new String(cArray, 0, n6);
        if (n5 < 4) {
            nArray[n3 - 1] = n4;
        }
        return this._symbols.addName(string, nArray, n3);
    }

    private final void _handleLongFieldName() {
        String string;
        int n2;
        int n3;
        byte[] byArray = this._inputBuffer;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n3 = byArray[this._inputPtr++])) {
                n2 = 0;
                break;
            }
            n5 = n3 & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n3 = byArray[this._inputPtr++])) {
                n2 = 1;
                break;
            }
            n5 = n5 << 8 | n3 & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n3 = byArray[this._inputPtr++])) {
                n2 = 2;
                break;
            }
            n5 = n5 << 8 | n3 & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n3 = byArray[this._inputPtr++])) {
                n2 = 3;
                break;
            }
            n5 = n5 << 8 | n3 & 0xFF;
            if (n4 >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[n4++] = n5;
        }
        n3 = n4 << 2;
        if (n2 > 0) {
            if (n4 >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[n4++] = n5;
            n3 += n2;
        }
        if ((string = this._symbols.findName(this._quadBuffer, n4)) == null) {
            string = this._decodeLongUnicodeName(this._quadBuffer, n3, n4);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = string;
        }
        this._parsingContext.setCurrentName(string);
    }

    private final String _findDecodedFromSymbols(int n2) {
        if (this._inputEnd - this._inputPtr < n2) {
            this._loadToHaveAtLeast(n2);
        }
        if (n2 < 5) {
            int n3 = this._inputPtr;
            byte[] byArray = this._inputBuffer;
            int n4 = this._inputBuffer[n3] & 0xFF;
            if (n2 > 1) {
                n4 = (n4 << 8) + (byArray[++n3] & 0xFF);
                if (n2 > 2) {
                    n4 = (n4 << 8) + (byArray[++n3] & 0xFF);
                    if (n2 > 3) {
                        n4 = (n4 << 8) + (byArray[++n3] & 0xFF);
                    }
                }
            }
            this._quad1 = n4;
            return this._symbols.findName(n4);
        }
        byte[] byArray = this._inputBuffer;
        int n5 = this._inputPtr;
        int n6 = (((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
        if (n2 < 9) {
            int n7 = byArray[n5++] & 0xFF;
            int n8 = n2 - 5;
            if (n8 > 0) {
                n7 = (n7 << 8) + (byArray[n5++] & 0xFF);
                if (n8 > 1) {
                    n7 = (n7 << 8) + (byArray[n5++] & 0xFF);
                    if (n8 > 2) {
                        n7 = (n7 << 8) + (byArray[n5] & 0xFF);
                    }
                }
            }
            this._quad1 = n6;
            this._quad2 = n7;
            return this._symbols.findName(n6, n7);
        }
        int n9 = (((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
        if (n2 < 13) {
            int n10 = byArray[n5++] & 0xFF;
            if ((n2 -= 9) > 0) {
                n10 = (n10 << 8) + (byArray[n5++] & 0xFF);
                if (n2 > 1) {
                    n10 = (n10 << 8) + (byArray[n5++] & 0xFF);
                    if (n2 > 2) {
                        n10 = (n10 << 8) + (byArray[n5] & 0xFF);
                    }
                }
            }
            this._quad1 = n6;
            this._quad2 = n9;
            this._quad3 = n10;
            return this._symbols.findName(n6, n9, n10);
        }
        return this._findDecodedLong(n2, n6, n9);
    }

    private final String _findDecodedLong(int n2, int n3, int n4) {
        int n5;
        int n6 = n2 + 3 >> 2;
        if (n6 > this._quadBuffer.length) {
            this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, n6);
        }
        this._quadBuffer[0] = n3;
        this._quadBuffer[1] = n4;
        n6 = 2;
        n3 = this._inputPtr + 8;
        n2 -= 8;
        byte[] byArray = this._inputBuffer;
        do {
            n5 = (((byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
            this._quadBuffer[n6++] = n5;
        } while ((n2 -= 4) > 3);
        if (n2 > 0) {
            n5 = byArray[n3] & 0xFF;
            if (n2 > 1) {
                n5 = (n5 << 8) + (byArray[++n3] & 0xFF);
                if (n2 > 2) {
                    n5 = (n5 << 8) + (byArray[++n3] & 0xFF);
                }
            }
            this._quadBuffer[n6++] = n5;
        }
        return this._symbols.findName(this._quadBuffer, n6);
    }

    private static int[] _growArrayTo(int[] nArray, int n2) {
        n2 += 4;
        if (nArray == null) {
            return new int[n2];
        }
        return Arrays.copyOf(nArray, n2);
    }

    @Override
    protected void _parseNumericValue(int n2) {
        if (this._tokenIncomplete) {
            n2 = this._typeAsInt;
            if (n2 >> 5 != 1) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
            }
            this._tokenIncomplete = false;
            this._finishNumberToken(n2);
        }
    }

    @Override
    protected int _parseIntValue() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            if ((this._typeAsInt & 0x1F) == 4) {
                this._finishInt();
                return this._numberInt;
            }
            this._finishNumberToken(this._typeAsInt);
        }
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    protected final void _finishToken() {
        this._tokenIncomplete = false;
        int n2 = this._typeAsInt;
        int n3 = n2 >> 5;
        if (n3 == 1) {
            this._finishNumberToken(n2);
            return;
        }
        if (n3 <= 3) {
            this._decodeShortAsciiValue(1 + (n2 & 0x3F));
            return;
        }
        if (n3 <= 5) {
            this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
            return;
        }
        if (n3 == 7) {
            switch ((n2 & 0x1F) >> 2) {
                case 0: {
                    this._decodeLongAscii();
                    return;
                }
                case 1: {
                    this._decodeLongUnicode();
                    return;
                }
                case 2: {
                    this._binaryValue = this._read7BitBinaryWithLength();
                    return;
                }
                case 7: {
                    this._finishRawBinary();
                    return;
                }
            }
        }
        this._throwInternal();
    }

    protected final void _finishNumberToken(int n2) {
        switch (n2 & 0x1F) {
            case 4: {
                this._finishInt();
                return;
            }
            case 5: {
                this._finishLong();
                return;
            }
            case 6: {
                this._finishBigInteger();
                return;
            }
            case 8: {
                this._finishFloat();
                return;
            }
            case 9: {
                this._finishDouble();
                return;
            }
            case 10: {
                this._finishBigDecimal();
                return;
            }
        }
        this._throwInternal();
    }

    private final void _finishInt() {
        int n2;
        int n3 = this._inputPtr;
        if (n3 + 5 >= this._inputEnd) {
            this._finishIntSlow();
            return;
        }
        if ((n2 = this._inputBuffer[n3++]) < 0) {
            n2 &= 0x3F;
        } else {
            byte by;
            if ((by = this._inputBuffer[n3++]) >= 0) {
                n2 = (n2 << 7) + by;
                if ((by = this._inputBuffer[n3++]) >= 0) {
                    n2 = (n2 << 7) + by;
                    if ((by = this._inputBuffer[n3++]) >= 0) {
                        n2 = (n2 << 7) + by;
                        if ((by = this._inputBuffer[n3++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            n2 = (n2 << 6) + (by & 0x3F);
        }
        this._inputPtr = n3;
        this._numberInt = SmileUtil.zigzagDecode(n2);
        this._numTypesValid = 1;
    }

    private final void _finishIntSlow() {
        int n2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++]) < 0) {
            n2 &= 0x3F;
        } else {
            byte by;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) >= 0) {
                n2 = (n2 << 7) + by;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((by = this._inputBuffer[this._inputPtr++]) >= 0) {
                    n2 = (n2 << 7) + by;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((by = this._inputBuffer[this._inputPtr++]) >= 0) {
                        n2 = (n2 << 7) + by;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((by = this._inputBuffer[this._inputPtr++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            n2 = (n2 << 6) + (by & 0x3F);
        }
        this._numberInt = SmileUtil.zigzagDecode(n2);
        this._numTypesValid = 1;
    }

    private final void _finishLong() {
        int n2 = this._inputPtr;
        int n3 = n2 + 11;
        if (n3 >= this._inputEnd) {
            this._finishLongSlow();
            return;
        }
        long l2 = (((this._inputBuffer[n2++] << 7) + this._inputBuffer[n2++] << 7) + this._inputBuffer[n2++] << 7) + this._inputBuffer[n2++];
        do {
            byte by;
            if ((by = this._inputBuffer[n2++]) < 0) {
                l2 = (l2 << 6) + (long)(by & 0x3F);
                this._inputPtr = n2;
                this._numberLong = SmileUtil.zigzagDecode(l2);
                this._numTypesValid = 2;
                return;
            }
            l2 = (l2 << 7) + (long)by;
        } while (n2 < n3);
        this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
    }

    private final void _finishLongSlow() {
        long l2 = this._fourBytesToInt();
        while (true) {
            byte by;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) < 0) {
                l2 = (l2 << 6) + (long)(by & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(l2);
                this._numTypesValid = 2;
                return;
            }
            l2 = (l2 << 7) + (long)by;
        }
    }

    private final int _fourBytesToInt() {
        int n2 = this._inputPtr;
        if (n2 + 3 >= this._inputEnd) {
            return this._fourBytesToIntSlow();
        }
        int n3 = (((this._inputBuffer[n2++] << 7) + this._inputBuffer[n2++] << 7) + this._inputBuffer[n2++] << 7) + this._inputBuffer[n2++];
        this._inputPtr = n2;
        return n3;
    }

    private final int _fourBytesToIntSlow() {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n2 = this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n2 = (n2 << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n2 = (n2 << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return (n2 << 7) + this._inputBuffer[this._inputPtr++];
    }

    private final void _finishBigInteger() {
        byte[] byArray = this._read7BitBinaryWithLength();
        this._numberBigInt = new BigInteger(byArray);
        this._numTypesValid = 4;
    }

    private final void _finishFloat() {
        int n2 = this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        float f2 = Float.intBitsToFloat((n2 << 7) + this._inputBuffer[this._inputPtr++]);
        this._numberDouble = f2;
        this._numTypesValid = 8;
    }

    private final void _finishDouble() {
        long l2 = ((long)this._fourBytesToInt() << 28) + (long)this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        l2 = (l2 << 7) + (long)this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        l2 = (l2 << 7) + (long)this._inputBuffer[this._inputPtr++];
        this._numberDouble = Double.longBitsToDouble(l2);
        this._numTypesValid = 8;
    }

    private final void _finishBigDecimal() {
        int n2 = SmileUtil.zigzagDecode(this._readUnsignedVInt());
        byte[] byArray = this._read7BitBinaryWithLength();
        this._numberBigDecimal = new BigDecimal(new BigInteger(byArray), n2);
        this._numTypesValid = 16;
    }

    private final int _readUnsignedVInt() {
        int n2 = 0;
        while (true) {
            byte by;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) < 0) {
                return (n2 << 6) + (by & 0x3F);
            }
            n2 = (n2 << 7) + by;
        }
    }

    private final byte[] _read7BitBinaryWithLength() {
        int n2;
        int n3;
        int n4;
        int n5 = this._readUnsignedVInt();
        byte[] byArray = new byte[n5];
        int n6 = 0;
        int n7 = n5 - 7;
        while (n6 <= n7) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            n4 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            n3 = this._inputBuffer[this._inputPtr++];
            n2 = ((n3 & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            byArray[n6++] = (n4 += n3 >> 3) >> 24;
            byArray[n6++] = (byte)(n4 >> 16);
            byArray[n6++] = (byte)(n4 >> 8);
            byArray[n6++] = (byte)n4;
            byArray[n6++] = (byte)(n2 >> 16);
            byArray[n6++] = (byte)(n2 >> 8);
            byArray[n6++] = (byte)n2;
        }
        n4 = n5 - n6;
        if (n4 > 0) {
            if (this._inputEnd - this._inputPtr < n4 + 1) {
                this._loadToHaveAtLeast(n4 + 1);
            }
            n3 = this._inputBuffer[this._inputPtr++];
            for (n2 = 1; n2 < n4; ++n2) {
                n3 = (n3 << 7) + this._inputBuffer[this._inputPtr++];
                byArray[n6++] = (byte)(n3 >> 7 - n2);
            }
            byArray[n6] = (byte)((n3 <<= n4) + this._inputBuffer[this._inputPtr++]);
        }
        return byArray;
    }

    protected final String _decodeShortAsciiValue(int n2) {
        int n3;
        if (this._inputEnd - this._inputPtr < n2) {
            this._loadToHaveAtLeast(n2);
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n4 = 0;
        byte[] byArray = this._inputBuffer;
        int n5 = n3 + n2;
        for (n3 = this._inputPtr; n3 < n5; ++n3) {
            cArray[n4++] = (char)byArray[n3];
        }
        this._inputPtr = n3;
        return this._textBuffer.setCurrentAndReturn(n2);
    }

    protected final String _decodeShortUnicodeValue(int n2) {
        if (this._inputEnd - this._inputPtr < n2) {
            this._loadToHaveAtLeast(n2);
        }
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n4 = this._inputPtr;
        this._inputPtr += n2;
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        n2 = n4 + n2;
        while (n4 < n2) {
            int n5;
            int n6;
            if ((n6 = nArray[n5 = byArray[n4++] & 0xFF]) != 0) {
                switch (n6) {
                    case 1: {
                        n5 = (n5 & 0x1F) << 6 | byArray[n4++] & 0x3F;
                        break;
                    }
                    case 2: {
                        n5 = (n5 & 0xF) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F;
                        break;
                    }
                    case 3: {
                        n5 = ((n5 & 7) << 18 | (byArray[n4++] & 0x3F) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F) - 65536;
                        cArray[n3++] = (char)(0xD800 | n5 >> 10);
                        n5 = 0xDC00 | n5 & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(n5) + " in short Unicode text block");
                    }
                }
            }
            cArray[n3++] = (char)n5;
        }
        return this._textBuffer.setCurrentAndReturn(n3);
    }

    private final void _decodeLongAscii() {
        int n2;
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        block0: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            n2 = this._inputPtr;
            int n4 = this._inputEnd - n2;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            n4 = Math.min(n4, cArray.length - n3);
            do {
                byte by;
                if ((by = this._inputBuffer[n2++]) == -4) break block0;
                cArray[n3++] = (char)by;
            } while (--n4 > 0);
            this._inputPtr = n2;
        }
        this._inputPtr = n2;
        this._textBuffer.setCurrentLength(n3);
    }

    private final void _decodeLongUnicode() {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n3;
            int n4;
            block14: {
                int n5;
                if ((n4 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n4 = this._inputPtr;
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                if ((n3 = n4 + (cArray.length - n2)) < (n5 = this._inputEnd)) {
                    n5 = n3;
                }
                while (n4 < n5) {
                    if (nArray[n3 = byArray[n4++] & 0xFF] == 0) {
                        cArray[n2++] = (char)n3;
                        continue;
                    }
                    break block14;
                }
                this._inputPtr = n4;
                continue;
            }
            this._inputPtr = n4;
            if (n3 == 252) break;
            switch (nArray[n3]) {
                case 1: {
                    n3 = this._decodeUtf8_2(n3);
                    break;
                }
                case 2: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n3 = this._decodeUtf8_3fast(n3);
                        break;
                    }
                    n3 = this._decodeUtf8_3(n3);
                    break;
                }
                case 3: {
                    n3 = this._decodeUtf8_4(n3);
                    cArray[n2++] = (char)(0xD800 | n3 >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n3 = 0xDC00 | n3 & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(n3);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    private final void _finishRawBinary() {
        int n2 = this._readUnsignedVInt();
        this._binaryValue = new byte[n2];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n3 = 0;
        while (true) {
            int n4 = Math.min(n2, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, this._binaryValue, n3, n4);
            this._inputPtr += n4;
            n3 += n4;
            if ((n2 -= n4) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    protected void _skipIncomplete() {
        this._tokenIncomplete = false;
        int n2 = this._typeAsInt;
        switch (n2 >> 5) {
            case 1: {
                switch ((n2 &= 0x1F) >> 2) {
                    case 1: {
                        switch (n2 & 3) {
                            case 1: {
                                this._skipBytes(4);
                            }
                            case 0: {
                                while (true) {
                                    n2 = this._inputEnd;
                                    byte[] byArray = this._inputBuffer;
                                    while (this._inputPtr < n2) {
                                        if (byArray[this._inputPtr++] >= 0) continue;
                                        return;
                                    }
                                    this.loadMoreGuaranteed();
                                }
                            }
                            case 2: {
                                this._skip7BitBinary();
                                return;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (n2 & 3) {
                            case 0: {
                                this._skipBytes(5);
                                return;
                            }
                            case 1: {
                                this._skipBytes(10);
                                return;
                            }
                            case 2: {
                                this._readUnsignedVInt();
                                this._skip7BitBinary();
                                return;
                            }
                        }
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                this._skipBytes(1 + (n2 & 0x3F));
                return;
            }
            case 4: 
            case 5: {
                this._skipBytes(2 + (n2 & 0x3F));
                return;
            }
            case 7: {
                switch ((n2 & 0x1F) >> 2) {
                    case 0: 
                    case 1: {
                        while (true) {
                            n2 = this._inputEnd;
                            byte[] byArray = this._inputBuffer;
                            while (this._inputPtr < n2) {
                                if (byArray[this._inputPtr++] != -4) continue;
                                return;
                            }
                            this.loadMoreGuaranteed();
                        }
                    }
                    case 2: {
                        this._skip7BitBinary();
                        return;
                    }
                    case 7: {
                        this._skipBytes(this._readUnsignedVInt());
                        return;
                    }
                }
            }
        }
        this._throwInternal();
    }

    protected void _skipBytes(int n2) {
        while (true) {
            int n3 = Math.min(n2, this._inputEnd - this._inputPtr);
            this._inputPtr += n3;
            if ((n2 -= n3) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    protected void _skip7BitBinary() {
        int n2 = this._readUnsignedVInt();
        int n3 = n2 / 7;
        int n4 = n3 << 3;
        if ((n2 -= n3 * 7) > 0) {
            n4 += n2 + 1;
        }
        this._skipBytes(n4);
    }

    private final int _decodeUtf8_2(int n2) {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n2 & 0x1F) << 6 | by & 0x3F;
    }

    private final int _decodeUtf8_3(int n2) {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n2 &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return n2 << 6 | by & 0x3F;
    }

    private final int _decodeUtf8_3fast(int n2) {
        byte by;
        n2 &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return n2 << 6 | by & 0x3F;
    }

    private final int _decodeUtf8_4(int n2) {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = (n2 & 7) << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n2 << 6 | by & 0x3F) - 65536;
    }

    protected void _reportInvalidSharedName(int n2) {
        if (this._seenNames == null) {
            this._reportError("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        this._reportError("Invalid shared name reference " + n2 + "; only got " + this._seenNameCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidSharedStringValue(int n2) {
        if (this._seenStringValues == null) {
            this._reportError("Encountered shared text value reference, even though document header did not declared shared text value references may be included");
        }
        this._reportError("Invalid shared text value reference " + n2 + "; only got " + this._seenStringValueCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidChar(int n2) {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    protected void _reportInvalidInitial(int n2) {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2) {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2, int n3) {
        this._inputPtr = n3;
        this._reportInvalidOther(n2);
    }

    private final JsonToken _eofAsNextToken() {
        if (!this._parsingContext.inRoot()) {
            this._handleEOF();
        }
        this.close();
        this._currToken = null;
        return null;
    }
}

