/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io;

import java.math.BigDecimal;

public final class NumberInput {
    public static final String NASTY_SMALL_DOUBLE = "2.2250738585072012e-308";
    static final long L_BILLION = 1000000000L;
    static final String MIN_LONG_STR_NO_SIGN = "-9223372036854775808".substring(1);
    static final String MAX_LONG_STR = "9223372036854775807";

    public static int parseInt(char[] cArray, int n, int n2) {
        int n3 = cArray[n] - 48;
        if (n2 > 4) {
            n3 = (((n3 * 10 + (cArray[++n] - 48)) * 10 + (cArray[++n] - 48)) * 10 + (cArray[++n] - 48)) * 10 + (cArray[++n] - 48);
            if ((n2 -= 4) > 4) {
                return (((n3 * 10 + (cArray[++n] - 48)) * 10 + (cArray[++n] - 48)) * 10 + (cArray[++n] - 48)) * 10 + (cArray[++n] - 48);
            }
        }
        if (n2 > 1) {
            n3 = n3 * 10 + (cArray[++n] - 48);
            if (n2 > 2) {
                n3 = n3 * 10 + (cArray[++n] - 48);
                if (n2 > 3) {
                    n3 = n3 * 10 + (cArray[++n] - 48);
                }
            }
        }
        return n3;
    }

    public static int parseInt(String string) {
        char c2 = string.charAt(0);
        int n = string.length();
        boolean bl = c2 == '-';
        int n2 = 1;
        if (bl) {
            if (n == 1 || n > 10) {
                return Integer.parseInt(string);
            }
            ++n2;
            c2 = string.charAt(1);
        } else if (n > 9) {
            return Integer.parseInt(string);
        }
        if (c2 > '9' || c2 < '0') {
            return Integer.parseInt(string);
        }
        int n3 = c2 - 48;
        if (n2 < n) {
            if ((c2 = string.charAt(n2++)) > '9' || c2 < '0') {
                return Integer.parseInt(string);
            }
            n3 = n3 * 10 + (c2 - 48);
            if (n2 < n) {
                if ((c2 = string.charAt(n2++)) > '9' || c2 < '0') {
                    return Integer.parseInt(string);
                }
                n3 = n3 * 10 + (c2 - 48);
                if (n2 < n) {
                    do {
                        if ((c2 = string.charAt(n2++)) > '9' || c2 < '0') {
                            return Integer.parseInt(string);
                        }
                        n3 = n3 * 10 + (c2 - 48);
                    } while (n2 < n);
                }
            }
        }
        if (bl) {
            return -n3;
        }
        return n3;
    }

    public static long parseLong(char[] cArray, int n, int n2) {
        return (long)NumberInput.parseInt(cArray, n, n2 -= 9) * 1000000000L + (long)NumberInput.parseInt(cArray, n + n2, 9);
    }

    public static long parseLong(String string) {
        if (string.length() <= 9) {
            return NumberInput.parseInt(string);
        }
        return Long.parseLong(string);
    }

    public static boolean inLongRange(char[] cArray, int n, int n2, boolean bl) {
        String string = bl ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int n3 = string.length();
        if (n2 < n3) {
            return true;
        }
        if (n2 > n3) {
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = cArray[n + n2] - string.charAt(n2);
            if (n4 == 0) continue;
            return n4 < 0;
        }
        return true;
    }

    public static boolean inLongRange(String string, boolean bl) {
        String string2 = bl ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int n = string2.length();
        int n2 = string.length();
        if (n2 < n) {
            return true;
        }
        if (n2 > n) {
            return false;
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = string.charAt(n2) - string2.charAt(n2);
            if (n3 == 0) continue;
            return n3 < 0;
        }
        return true;
    }

    public static int parseAsInt(String string, int n) {
        char c2;
        if (string == null) {
            return n;
        }
        int n2 = (string = string.trim()).length();
        if (n2 == 0) {
            return n;
        }
        int n3 = 0;
        if (n2 > 0) {
            c2 = string.charAt(0);
            if (c2 == '+') {
                string = string.substring(1);
                n2 = string.length();
            } else if (c2 == '-') {
                ++n3;
            }
        }
        while (n3 < n2) {
            c2 = string.charAt(n3);
            if (c2 > '9' || c2 < '0') {
                try {
                    return (int)NumberInput.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return n;
                }
            }
            ++n3;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static long parseAsLong(String string, long l) {
        char c2;
        if (string == null) {
            return l;
        }
        int n = (string = string.trim()).length();
        if (n == 0) {
            return l;
        }
        int n2 = 0;
        if (n > 0) {
            c2 = string.charAt(0);
            if (c2 == '+') {
                string = string.substring(1);
                n = string.length();
            } else if (c2 == '-') {
                ++n2;
            }
        }
        while (n2 < n) {
            c2 = string.charAt(n2);
            if (c2 > '9' || c2 < '0') {
                try {
                    return (long)NumberInput.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return l;
                }
            }
            ++n2;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static double parseAsDouble(String string, double d2) {
        if (string == null) {
            return d2;
        }
        if ((string = string.trim()).length() == 0) {
            return d2;
        }
        try {
            return NumberInput.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d2;
        }
    }

    public static double parseDouble(String string) {
        if (NASTY_SMALL_DOUBLE.equals(string)) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(string);
    }

    public static BigDecimal parseBigDecimal(String string) {
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw NumberInput._badBD(string);
        }
    }

    public static BigDecimal parseBigDecimal(char[] cArray) {
        return NumberInput.parseBigDecimal(cArray, 0, cArray.length);
    }

    public static BigDecimal parseBigDecimal(char[] cArray, int n, int n2) {
        try {
            return new BigDecimal(cArray, n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw NumberInput._badBD(new String(cArray, n, n2));
        }
    }

    private static NumberFormatException _badBD(String string) {
        return new NumberFormatException("Value \"" + string + "\" can not be represented as BigDecimal");
    }
}

