/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;

public class JsonPointer {
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected volatile JsonPointer _head;
    protected final String _asString;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = "";
        this._matchingElementIndex = -1;
        this._asString = "";
    }

    protected JsonPointer(String string, String string2, JsonPointer jsonPointer) {
        this._asString = string;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = JsonPointer._parseIndex(string2);
    }

    protected JsonPointer(String string, String string2, int n, JsonPointer jsonPointer) {
        this._asString = string;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = n;
    }

    public static JsonPointer compile(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        if (string.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + string + "\"");
        }
        return JsonPointer._parseTail(string);
    }

    public static JsonPointer valueOf(String string) {
        return JsonPointer.compile(string);
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer last() {
        JsonPointer jsonPointer;
        JsonPointer jsonPointer2 = this;
        if (jsonPointer2 == EMPTY) {
            return null;
        }
        while ((jsonPointer = jsonPointer2._nextSegment) != EMPTY) {
            jsonPointer2 = jsonPointer;
        }
        return jsonPointer2;
    }

    public JsonPointer append(JsonPointer jsonPointer) {
        if (this == EMPTY) {
            return jsonPointer;
        }
        if (jsonPointer == EMPTY) {
            return this;
        }
        String string = this._asString;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return JsonPointer.compile(string + jsonPointer._asString);
    }

    public boolean matchesProperty(String string) {
        return this._nextSegment != null && this._matchingPropertyName.equals(string);
    }

    public JsonPointer matchProperty(String string) {
        if (this._nextSegment != null && this._matchingPropertyName.equals(string)) {
            return this._nextSegment;
        }
        return null;
    }

    public boolean matchesElement(int n) {
        return n == this._matchingElementIndex && n >= 0;
    }

    public JsonPointer matchElement(int n) {
        if (n != this._matchingElementIndex || n < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public JsonPointer head() {
        JsonPointer jsonPointer = this._head;
        if (jsonPointer == null) {
            if (this != EMPTY) {
                jsonPointer = this._constructHead();
            }
            this._head = jsonPointer;
        }
        return jsonPointer;
    }

    public String toString() {
        return this._asString;
    }

    public int hashCode() {
        return this._asString.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonPointer)) {
            return false;
        }
        return this._asString.equals(((JsonPointer)object)._asString);
    }

    private static final int _parseIndex(String string) {
        int n = string.length();
        if (n == 0 || n > 10) {
            return -1;
        }
        char c2 = string.charAt(0);
        if (c2 <= '0') {
            if (n == 1 && c2 == '0') {
                return 0;
            }
            return -1;
        }
        if (c2 > '9') {
            return -1;
        }
        for (int k = 1; k < n; ++k) {
            c2 = string.charAt(k);
            if (c2 <= '9' && c2 >= '0') continue;
            return -1;
        }
        if (n == 10 && NumberInput.parseLong(string) > Integer.MAX_VALUE) {
            return -1;
        }
        return NumberInput.parseInt(string);
    }

    protected static JsonPointer _parseTail(String string) {
        int n = string.length();
        int n2 = 1;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == '/') {
                return new JsonPointer(string, string.substring(1, n2), JsonPointer._parseTail(string.substring(n2)));
            }
            if (c2 != '~' || ++n2 >= n) continue;
            return JsonPointer._parseQuotedTail(string, n2);
        }
        return new JsonPointer(string, string.substring(1), EMPTY);
    }

    protected static JsonPointer _parseQuotedTail(String string, int n) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(Math.max(16, n2));
        if (n > 2) {
            stringBuilder.append(string, 1, n - 1);
        }
        block0: while (true) {
            JsonPointer._appendEscape(stringBuilder, string.charAt(n++));
            while (n < n2) {
                char c2 = string.charAt(n);
                if (c2 == '/') {
                    return new JsonPointer(string, stringBuilder.toString(), JsonPointer._parseTail(string.substring(n)));
                }
                if (c2 == '~' && ++n < n2) continue block0;
                stringBuilder.append(c2);
            }
            break;
        }
        return new JsonPointer(string, stringBuilder.toString(), EMPTY);
    }

    protected JsonPointer _constructHead() {
        JsonPointer jsonPointer = this.last();
        if (jsonPointer == this) {
            return EMPTY;
        }
        int n = jsonPointer._asString.length();
        JsonPointer jsonPointer2 = this._nextSegment;
        return new JsonPointer(this._asString.substring(0, this._asString.length() - n), this._matchingPropertyName, this._matchingElementIndex, jsonPointer2._constructHead(n, jsonPointer));
    }

    protected JsonPointer _constructHead(int n, JsonPointer jsonPointer) {
        if (this == jsonPointer) {
            return EMPTY;
        }
        JsonPointer jsonPointer2 = this._nextSegment;
        String string = this._asString;
        return new JsonPointer(string.substring(0, string.length() - n), this._matchingPropertyName, this._matchingElementIndex, jsonPointer2._constructHead(n, jsonPointer));
    }

    private static void _appendEscape(StringBuilder stringBuilder, char c2) {
        if (c2 == '0') {
            c2 = (char)126;
        } else if (c2 == '1') {
            c2 = (char)47;
        } else {
            stringBuilder.append('~');
        }
        stringBuilder.append(c2);
    }
}

