/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.eventmodel;

import com.gradle.scan.eventmodel.EventData;
import com.gradle.scan.eventmodel.Nullable;
import com.gradle.scan.eventmodel.Preconditions;

public final class Event<T extends EventData> {
    public final String type;
    public final long timestamp;
    @Nullable
    public final Long actualTimestamp;
    public final int ordinal;
    public final T data;

    private Event(long timestamp, @Nullable Long actualTimestamp, int ordinal, T data) {
        Preconditions.a(data);
        this.type = data.getClass().getSimpleName();
        this.timestamp = timestamp;
        this.actualTimestamp = actualTimestamp;
        this.ordinal = ordinal;
        this.data = data;
    }

    public static <T extends EventData> Event<T> a(long normalized, Long actual, int ordinal, T eventData) {
        if (actual == null || actual == normalized) {
            return new Event<T>(normalized, null, ordinal, eventData);
        }
        return new Event<T>(normalized, actual, ordinal, eventData);
    }

    public String toString() {
        return "Event{type='" + this.type + '\'' + ", timestamp=" + this.timestamp + ", actualTimestamp=" + this.actualTimestamp + ", ordinal=" + this.ordinal + ", data=" + this.data + '}';
    }
}

